/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.task;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.common.UserOperationDataContext;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.operation.DeployUserOperationData;
import com.huawei.ism.tool.distributeddeploy.service.task.FutureTaskWithComparable;
import com.huawei.ism.tool.distributeddeploy.service.task.ThreadPoolExecutorWithPriority;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployTaskManager.class);
    private static final PriorityBlockingQueue TASK_QUEUE = new PriorityBlockingQueue(30, new ComparatorImpl().reversed());
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutorWithPriority(ToolConfig.getThreadNum(), ToolConfig.getMaxThreadNum(), 0L, TimeUnit.MILLISECONDS, TASK_QUEUE);
    private final boolean sync;
    private final IUIObserver obs;
    private final Vector<Future> results = new Vector();
    private DeployUserOperationData userOperationData = null;

    public DeployTaskManager(IUIObserver obs, boolean sync) {
        this.sync = sync;
        this.obs = obs;
        if (Context.INS.isFitDeployScene()) {
            this.userOperationData = new DeployUserOperationData();
            UserOperationDataContext.getInstance().getDeployUserOperationDatas().add(this.userOperationData);
            obs.setUserOpData(this.userOperationData);
        }
    }

    public void startDeployTask(List<DeployNode> deployNodes) {
        this.startDeployInit(deployNodes);
        List resultList = deployNodes.stream().map(node -> EXECUTOR.submit(node.getDeployTask())).collect(Collectors.toList());
        this.results.addAll(resultList);
        this.waitFinish();
    }

    private void startDeployInit(List<DeployNode> deployNodes) {
        Context.INS.getMain().getMainLayout().getImportConfig().setEnabled(false);
        deployNodes.stream().peek(DeployNode::startInit).map(DeployNode::getDeployTask).forEach(DeployTask::updateStatus2WaitExec);
    }

    public void startDeployTaskByScene(List<DeployNode> deployNodes) {
        this.setUserOpData();
        List resultList = deployNodes.stream().peek(this::startDeployInitByScene).map(node -> EXECUTOR.submit(node.getDeployTask())).collect(Collectors.toList());
        this.results.addAll(resultList);
        this.waitFinish();
    }

    private synchronized void setUserOpData() {
        if (Objects.nonNull(this.userOperationData) && this.userOperationData.getTaskStartTime() == 0L) {
            this.userOperationData.setTaskStartTime(System.currentTimeMillis());
        }
    }

    public void startDeployInitByScene(DeployNode deployNode) {
        this.obs.addRunningDevNum();
        deployNode.getDeployTask().updateStatus2WaitExec();
    }

    private void waitFinish() {
        if (this.sync) {
            return;
        }
        this.results.forEach(this::waitTask);
        this.obs.finishAll();
    }

    private void waitTask(Future future) {
        try {
            future.get();
        }
        catch (Exception e) {
            LOGGER.error("Execute task failed.", (Throwable)e);
        }
    }

    public static ThreadPoolExecutor getEXECUTOR() {
        return EXECUTOR;
    }

    public IUIObserver getObs() {
        return this.obs;
    }

    public DeployUserOperationData getUserOperationData() {
        return this.userOperationData;
    }

    static class ComparatorImpl
    implements Comparator<FutureTaskWithComparable> {
        ComparatorImpl() {
        }

        @Override
        public int compare(FutureTaskWithComparable task1, FutureTaskWithComparable task2) {
            return task1.compareTo(task2);
        }
    }
}

