/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.ui;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.TaskRunningDetail;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.component.Label;
import com.huawei.ism.tool.distributeddeploy.ui.component.LabelComponent;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ItemParams;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIObserver
implements IUIObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIObserver.class);
    private Map<DeployNode, Map<StepTask, DefaultListModel>> devDetailMap = new ConcurrentHashMap<DeployNode, Map<StepTask, DefaultListModel>>();
    private AtomicInteger runningDevNum = new AtomicInteger();

    @Override
    public void initDevUIData(List<DeployNode> deployNodes) {
        deployNodes.forEach(this::initDevDetail);
    }

    private void initDevDetail(DeployNode node) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        node.getDeployTask().getSubTasks().forEach(subTask -> map.put(subTask, new DefaultListModel()));
        this.devDetailMap.put(node, map);
    }

    public UIObserver() {
        this.initDefaultNodeDetail();
    }

    private void initDefaultNodeDetail() {
        this.initDevDetail(Context.INS.defaultNode);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof ItemTask) {
            ItemTask itemTask = (ItemTask)observable;
            this.updateWhenItemTaskChange(itemTask);
        }
        if (observable instanceof StepTask) {
            StepTask stepTask = (StepTask)observable;
            this.updateLabelStatus(stepTask);
        }
        if (observable instanceof DeployTask) {
            DeployTask deployTask = (DeployTask)observable;
            this.updateDeployUI(deployTask);
        }
    }

    private void updateWhenItemTaskChange(ItemTask itemTask) {
        this.updateDetailInMemory(itemTask);
        this.updateDetailAndLabel(itemTask.getParentTask());
    }

    private void updateLabelStatus(StepTask stepTask) {
        if (stepTask.getNode() != Context.INS.getCurrentSelectNode()) {
            return;
        }
        Context.INS.getMain().getMainLayout().getLabelComponent().findLabel(stepTask).setIcon(stepTask.getStatus().getIcon());
    }

    @Override
    public void updateDetailWhenLabelChange(Observable observable) {
        if (!(observable instanceof Label.LabelObservable)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Label.LabelObservable observable1Label = (Label.LabelObservable)observable;
            Label label = observable1Label.getLabel();
            DeployNode node = Context.INS.getCurrentSelectNode();
            this.updateDetailUI(node.getDeployTask().findTargetSubTask(label.getLabelId()));
        });
    }

    @Override
    public void updateWhenDevChange() {
        DeployNode node = Context.INS.getCurrentSelectNode();
        if (Context.INS.defaultNode.equals(node)) {
            Context.INS.getMain().getLabelComponent().setVisible(false);
            Context.INS.getMain().getStepTaskDetail().setVisible(false);
            return;
        }
        StepTask stepTask = node.getDeployTask().findNowSubTask();
        SwingUtilities.invokeLater(() -> {
            this.initLabelStatus(node.getDeployTask().getSubTasks());
            Context.INS.getMain().getLabelComponent().findLabel(stepTask).getObservable().click();
            Context.INS.getMain().getLabelComponent().setVisible(true);
            Context.INS.getMain().getStepTaskDetail().setVisible(true);
        });
    }

    private void initLabelStatus(List<StepTask> subTasks) {
        LabelComponent labelComponent = Context.INS.getMain().getLabelComponent();
        subTasks.forEach(subTask -> labelComponent.findLabel((StepTask)subTask).setIcon(subTask.getStatus().getIcon()));
    }

    private void updateDetailUI(StepTask stepTask) {
        DefaultListModel showModel = (DefaultListModel)Context.INS.getMain().getStepTaskDetail().getDetailList().getModel();
        DefaultListModel subTaskModel = this.devDetailMap.get(stepTask.getNode()).getOrDefault(stepTask, new DefaultListModel());
        JList list = Context.INS.getMain().getStepTaskDetail().getDetailList();
        if (showModel.equals(subTaskModel)) {
            list.repaint();
            return;
        }
        SwingUtilities.invokeLater(() -> {
            list.setModel(subTaskModel);
            list.revalidate();
            list.repaint();
        });
    }

    private void updateDetailAndLabel(StepTask stepTask) {
        DeployNode node = stepTask.getNode();
        if (node != Context.INS.getCurrentSelectNode()) {
            return;
        }
        Label label = Context.INS.getMain().getLabelComponent().findLabel(stepTask);
        if (label.isSelected()) {
            this.updateDetailUI(stepTask);
        }
        label.setIcon(stepTask.getStatus().getIcon());
    }

    private void updateDetailInMemory(ItemTask itemTask) {
        DeployNode node = itemTask.getNode();
        DefaultListModel model = this.devDetailMap.get(node).get(itemTask.getParentTask());
        if (!model.contains(itemTask)) {
            model.addElement(itemTask);
        }
    }

    public void fireDevAdd(List<DeployNode> nodes) {
        Context.INS.getMain().refreshDevTable(nodes);
    }

    private void updateDeployUI(DeployTask deployTask) {
        TableRow row = this.findTableRow(deployTask.getNode());
        Status status = deployTask.getStatus();
        DeployNode node = deployTask.getNode();
        IsmTableCell.ProgressCell progressCell = (IsmTableCell.ProgressCell)row.getValueAt(3);
        int oldPor = progressCell.getProgress();
        IsmTableCell.IconCell cell = (IsmTableCell.IconCell)row.getValueAt(4);
        if (oldPor < deployTask.getProgress() || !status.getDesc().equals(cell.toString())) {
            SwingUtilities.invokeLater(() -> {
                this.updateDevProAndStatus(deployTask, progressCell, cell);
                this.updateDevOpCell(deployTask, row, node);
                Context.INS.getMain().getDeviceTable().repaint();
            });
        }
    }

    private void updateDevOpCell(DeployTask deployTask, TableRow row, DeployNode node) {
        if (deployTask.isAbnormal() && !deployTask.getSubTasks().get(0).isAbnormal()) {
            row.setValueAt(5, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"mainFrame.table.redeploy"), e -> this.retryDeploy(node)));
        } else {
            row.setValueAt(5, (Object)"--");
        }
    }

    private void updateDevProAndStatus(DeployTask deployTask, IsmTableCell.ProgressCell progressCell, IsmTableCell.IconCell cell) {
        progressCell.setProgress(deployTask.getProgress());
        String desc = deployTask.getStatus().getDesc();
        if (!desc.equals(cell.toString())) {
            cell.setDescription(desc);
            cell.setIcon((Icon)deployTask.getStatus().getIcon());
        }
    }

    private void retryDeploy(DeployNode node) {
        if (!node.canRedeploy()) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"deploy.retry.warning"));
            return;
        }
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"deploy.retry.confirmInfo"));
        if (0 != dialog.getValue()) {
            LOGGER.info("Cancel redeploy task for {}.", (Object)node.getIp());
            return;
        }
        StepTask pauseTask = node.getDeployTask().findPauseStepTask();
        this.devDetailMap.get(node).put(pauseTask, new DefaultListModel());
        if (Context.INS.getCurrentSelectNode().equals(node)) {
            this.updateDetailUI(pauseTask);
        }
        node.retryDeployInit();
        ArrayList<DeployNode> nodes = new ArrayList<DeployNode>();
        nodes.add(node);
        Context.INS.getMain().getDeployTaskManager().startDeployTask(nodes);
    }

    private TableRow findTableRow(DeployNode node) {
        return Context.INS.getMain().getDeviceTable().getAllRows().stream().filter(tableRow -> tableRow.getIdentifier().equals(node)).findFirst().orElse(Context.INS.getMain().getCurrentCard().createRow(node));
    }

    @Override
    public void finish(DeployNode node) {
        if (this.runningDevNum.decrementAndGet() == 0) {
            this.finishAll();
        }
    }

    @Override
    public void finishAll() {
        Context.INS.getMain().getMainLayout().getImportConfig().setEnabled(true);
    }

    @Override
    public void resetDevUIData(String taskId, ClusterNode clusterNode) {
        throw new AbstractMethodError("not support");
    }

    @Override
    public void addRunningDevNum() {
        this.runningDevNum.incrementAndGet();
    }

    @Override
    public boolean hasRunningDev() {
        return this.runningDevNum.get() != 0;
    }

    @Override
    public TaskRunningDetail getTaskRunningDetail(String taskId) {
        throw new AbstractMethodError("not support");
    }

    @Override
    public DeployRunningDetail getDeployNodeRunningDetail(String taskId, String clusterId, String devId) {
        throw new AbstractMethodError("not support");
    }

    @Override
    public void resetItemDetail(ItemParams params) {
        throw new AbstractMethodError("not support");
    }

    @Override
    public void resetStepDetail(String taskId, String clusterId, String devId, List<String> stepIdList) {
        throw new AbstractMethodError("not support");
    }

    public static enum UpdateUIStatus {
        ITEM_STATUS_CHANGE,
        DEFAULT;

    }
}

