/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.action;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.logic.ssdp.SnMappingIpTask;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.card.MatchCheckCard;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.MainFrame;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartDeployAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartDeployAction.class);
    private ExecutorService ssdpExecutor = Executors.newSingleThreadExecutor();

    @Override
    public void actionPerformed(ActionEvent e) {
        MainFrame mainFrame = Context.INS.getMain();
        List<DeployNode> selectNodes = mainFrame.getDeviceTable().getMarkedRows().stream().map(row -> (DeployNode)row.getIdentifier()).collect(Collectors.toList());
        if (!this.check(selectNodes)) {
            LOGGER.info("Refuse deploy task,check not pass.");
            return;
        }
        if (this.needSsdpSearch(selectNodes) && !SnMappingIpTask.getInstance().isSearching()) {
            this.ssdpExecutor.submit(() -> SnMappingIpTask.getInstance().mapping());
        }
        mainFrame.getDeployTaskManager().startDeployTask(selectNodes);
    }

    private boolean needSsdpSearch(List<DeployNode> selectNodes) {
        return selectNodes.stream().anyMatch(selectNode -> !StringUtils.isNULLStr((String)selectNode.getSn())) && Context.INS.getCurrentScene().equals((Object)Card.CardScene.MAIN);
    }

    private boolean check(List<DeployNode> selectNodes) {
        if (selectNodes.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"deploy.check.emptyTask"));
            return false;
        }
        if (selectNodes.stream().anyMatch(node -> !node.canDeploy())) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"deploy.check.running"));
            return false;
        }
        if (selectNodes.stream().anyMatch(node -> node.getDeployTask().isAbnormal())) {
            return DialogUtils.showYesNoDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"deploy.check.pause")).getValue() == 0;
        }
        if (Card.CardScene.MATCH_CHECK == Context.INS.getCurrentScene()) {
            WarningDialog dialog = DialogUtils.showWarnConfirmDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"matchCheck.start.waring"), (String)ResourceUtil.getString((String)"matchCheck.start.confirm"));
            if (dialog.getValue() == 0) {
                MatchCheckCard matchCheckCard = (MatchCheckCard)Context.INS.getMain().getCurrentCard();
                matchCheckCard.enableStrategy();
                return true;
            }
            return false;
        }
        return true;
    }
}

