/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.card;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.BmcIpDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.BmcIpConfigTask;
import com.huawei.ism.tool.distributeddeploy.service.report.BmcIpConfigResultBuilderExcel;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.DetailInfoDialog;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.LocationConfirmationDialog;
import com.huawei.ism.tool.distributeddeploy.ui.layout.BmcIpFrameLayout;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ExportTemplate;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ShowSupportListener;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmTextField;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcIpFrameCard
extends Card {
    private static final Logger log = LoggerFactory.getLogger(BmcIpFrameCard.class);
    private static final String EXECUTE_CONFIGURATION = ResourceUtil.getString((String)"bmcIpFrame.execute.configuration");
    private static final String LIGHTING = ResourceUtil.getString((String)"bmcIpFrame.lighting");
    private static final String DETAIL = ResourceUtil.getString((String)"bmcIpFrame.table.detail");
    private BmcIpFrameLayout bmcIpFrameLayout = new BmcIpFrameLayout();
    private IUIObserver obs = new UIObserver();
    private List<BmcIpConfigTask> taskList = new ArrayList<BmcIpConfigTask>();

    public BmcIpFrameCard() {
        this.bmcIpFrameLayout.getSupportList().addClickListener((ToolHyperLinkLabel.ClickListener)new ShowSupportListener());
        this.bmcIpFrameLayout.getDeployTemplate().addClickListener((ToolHyperLinkLabel.ClickListener)new ExportTemplate());
        this.bmcIpFrameLayout.getImportConfig().addActionListener(this::importConfigAction);
    }

    @Override
    public JPanel getLayout() {
        return this.bmcIpFrameLayout;
    }

    @Override
    public void clearDevTable() {
        this.bmcIpFrameLayout.getModel().removeAll();
        Context.INS.clearNodes();
        this.taskList = new ArrayList<BmcIpConfigTask>();
    }

    @Override
    public IUIObserver getObs() {
        return this.obs;
    }

    @Override
    public DeployNode getCurrentShowNode() {
        return null;
    }

    @Override
    public DeployTaskManager getTaskManager() {
        return null;
    }

    @Override
    public void refreshDevTable(List<DeployNode> nodes) {
        Collections.sort(nodes);
        Context.INS.addNodes(nodes);
        this.bmcIpFrameLayout.getModel().addRows(nodes.stream().map(this::createRow).collect(Collectors.toList()));
        this.obs.initDevUIData(nodes);
    }

    @Override
    public TableRow createRow(DeployNode node) {
        DefaultTableRow row = new DefaultTableRow(BmcIpFrameLayout.DEVICE_TABLE_HEAD.length, (Object)node, (Object)node);
        BmcIpConfigTask task = new BmcIpConfigTask(node);
        this.taskList.add(task);
        int index = 0;
        row.setValueAt(index++, (Object)node.getDevType());
        row.setValueAt(index++, (Object)node.getSlotId());
        IsmTableCell.MsgTextCell currentIpCell = new IsmTableCell.MsgTextCell((JTextField)UiMethod.createIpv4v6TextField(), "", "");
        currentIpCell.setText(task.getNowIp());
        row.setValueAt(index++, (Object)currentIpCell);
        IsmTextField textField = UiMethod.createIpv4v6TextField();
        IsmTableCell.MsgTextCell targetIpCell = new IsmTableCell.MsgTextCell((JTextField)textField, "", "");
        targetIpCell.setText(node.getIp());
        textField.setEditable(false);
        row.setValueAt(index++, (Object)targetIpCell);
        row.setValueAt(index++, (Object)node.getMask());
        row.setValueAt(index++, (Object)node.getGateway());
        row.setValueAt(index++, (Object)node.getNodeName());
        IsmTableCell.IconCell stateCell = new IsmTableCell.IconCell((Icon)task.getState().getIcon(), task.getState().getDesc());
        row.setValueAt(index++, (Object)stateCell);
        index = this.buildExecuteConfig((TableRow<DeployNode, DeployNode>)row, task, index, currentIpCell, stateCell);
        index = this.buildExecuteLitLED((TableRow<DeployNode, DeployNode>)row, task, index, currentIpCell, stateCell);
        this.buildExecuteOffLED((TableRow<DeployNode, DeployNode>)row, task, index);
        return row;
    }

    private void buildExecuteOffLED(TableRow<DeployNode, DeployNode> row, BmcIpConfigTask task, int index) {
        row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(DETAIL, actionEvent -> new DetailInfoDialog(task.getDetaiInfo(), Context.INS.getMain()).setVisible(true)));
    }

    private int buildExecuteLitLED(TableRow<DeployNode, DeployNode> row, BmcIpConfigTask task, int index, IsmTableCell.MsgTextCell nowIpCell, IsmTableCell.IconCell stateCell) {
        row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(LIGHTING, actionEvent -> {
            if (!this.checkNowIp(nowIpCell)) {
                return;
            }
            task.setNowIp(nowIpCell.getEditor().getCellEditorValue().toString());
            task.executeLitLndicatorLED();
            if (Status.LIGHTING_LIT_ERROR == task.getState()) {
                DialogUtils.showErrorDialog((Window)Context.INS.getMain(), (String)task.getIndicatorStateDetaiInfo());
            } else {
                new LocationConfirmationDialog(task, Context.INS.getMain()).setVisible(true);
                task.exceuteOffLndicatorLED();
                this.updateState(stateCell, task.getState());
            }
        }));
        return index + 1;
    }

    private int buildExecuteConfig(TableRow<DeployNode, DeployNode> row, BmcIpConfigTask task, int index, IsmTableCell.MsgTextCell nowIpCell, IsmTableCell.IconCell stateCell) {
        row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(EXECUTE_CONFIGURATION, actionEvent -> {
            if (!this.checkNowIp(nowIpCell)) {
                return;
            }
            task.setNowIp(nowIpCell.getEditor().getCellEditorValue().toString());
            task.executeBmcIpConfig(nowIpCell);
            this.updateState(stateCell, task.getState());
        }));
        return index + 1;
    }

    private boolean checkNowIp(IsmTableCell.MsgTextCell nowIpCell) {
        String ip = nowIpCell.getEditor().getCellEditorValue().toString();
        if (!StringUtils.isValidIPV4(ip) && !StringUtils.isIpv6Address(ip)) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"bmcIpFrame.bmc.now.ip.addresserror"));
            return false;
        }
        return true;
    }

    private void updateState(IsmTableCell.IconCell stateCell, Status state) {
        stateCell.setIcon((Icon)state.getIcon());
        stateCell.setDescription(state.getDesc());
    }

    @Override
    public boolean isNeedSelectVersion() {
        return false;
    }

    @Override
    public List<DeployNode> buildDevNode(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        return (List)new BmcIpDeploySceneDevsStrategyTask(fileDatas.get("storageNode"), fileDatas.get("storageNodeDS")).run();
    }

    @Override
    public void exportReport() {
        if (this.taskList.isEmpty()) {
            log.info("Export report but empty node.");
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"export.report.empty.node"));
            return;
        }
        this.buildCheck();
        BmcIpConfigResultBuilderExcel excel = new BmcIpConfigResultBuilderExcel();
        excel.injectData(this.taskList);
        boolean result = excel.saveExcel();
        String msgId = result ? "export.report.success" : "export.report.common.err";
        DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)msgId));
    }

    private void buildCheck() {
        File targetDirFile = new File(Context.INS.getReportDir());
        if (!targetDirFile.exists() && !targetDirFile.mkdirs()) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"export.report.makeDir.err"));
            return;
        }
        if (!targetDirFile.canWrite()) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"export.report.makeFile.err"));
        }
    }

    public List<BmcIpConfigTask> getTaskList() {
        return this.taskList;
    }
}

