/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.card;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.ImportFileDialog;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JPanel;

public abstract class Card {
    public void importConfigAction(ActionEvent event) {
        String updateToolTips = VersionMappingStrategy.INS.getUpdateToolTips();
        if (!StringUtils.isNULLStr(updateToolTips) && !ToolConfig.isDebugModel()) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)updateToolTips);
            return;
        }
        new ImportFileDialog(this).setVisible(true);
    }

    public abstract JPanel getLayout();

    public abstract void clearDevTable();

    public abstract IUIObserver getObs();

    public abstract DeployNode getCurrentShowNode();

    public abstract DeployTaskManager getTaskManager();

    public abstract TableRow createRow(DeployNode var1);

    public abstract void refreshDevTable(List<DeployNode> var1);

    public abstract boolean isNeedSelectVersion();

    public abstract List<DeployNode> buildDevNode(Map<String, List<Map<String, Attribute>>> var1) throws ImportFileException, ToolException;

    public abstract void exportReport();

    public static enum CardScene {
        MAIN("full"),
        BMC_IP_CONFIG("bmcIp"),
        MATCH_CHECK("check"),
        VERSION_MAPPING_CHECK("versionMappingCheck"),
        ADD_SERVER("addServer"),
        BMC_CONFIG("bmc_config"),
        HARDWARE_CONFIG("hardware_config"),
        SYSTEM_INSTALLATION("os_installation");

        String key;

        public static CardScene mappingEnum(String scene) {
            return Arrays.stream(CardScene.values()).filter(card -> card.key.equals(scene)).findFirst().orElse(MAIN);
        }

        public static Optional<CardScene> mappingEnumNoDefault(String scene) {
            return Arrays.stream(CardScene.values()).filter(card -> card.key.equals(scene)).findFirst();
        }

        private CardScene(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

