/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.ClusterInfo;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.ClusterInfoStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DirectPlaneNodesStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.FullDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.OsNetworkStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.PolicyRouteStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StaticRouteStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.service.report.ReportBuilder;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.action.StartDeployAction;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.layout.MainFrameLayout;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ExportTemplate;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ItemClickListener;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ShowSupportListener;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrameCard
extends Card {
    private static final Logger log = LoggerFactory.getLogger(MainFrameCard.class);
    protected Card.CardScene cardScene;
    protected MainFrameLayout layout;
    protected IUIObserver obs = new UIObserver();
    protected DeployTaskManager deployTaskManager = new DeployTaskManager(this.obs, true);
    protected volatile DeployNode currentShowNode;

    public MainFrameCard(Card.CardScene scene) {
        this.currentShowNode = Context.INS.defaultNode;
        this.cardScene = scene;
        this.init();
    }

    protected void init() {
        this.layout = new MainFrameLayout(this.cardScene);
        this.bindListener();
    }

    protected void bindListener() {
        this.layout.getStartDeploy().addActionListener(new StartDeployAction());
        this.layout.getImportConfig().addActionListener(this::importConfigAction);
        this.layout.getSupportList().addClickListener((ToolHyperLinkLabel.ClickListener)new ShowSupportListener());
        this.layout.getDeployTemplate().addClickListener((ToolHyperLinkLabel.ClickListener)new ExportTemplate());
        this.layout.getDeviceTable().addListSelectionListener(this::updateWhenDevChange);
        this.layout.getStepDetailComponent().getDetailList().addMouseListener(new ItemClickListener());
    }

    protected void updateWhenDevChange(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        List<DeployNode> selectNode = this.getSelectNode();
        this.currentShowNode = selectNode.size() != 1 ? Context.INS.defaultNode : this.getSelectNode().get(0);
        this.layout.getLabelComponent().updateComponentUI(this.currentShowNode.getDeployTask().getSubTasks().stream().map(StepTask::getStepInfo).collect(Collectors.toList()));
        this.obs.updateWhenDevChange();
    }

    protected List<DeployNode> getSelectNode() {
        return this.layout.getDeviceTable().getMarkedRows().stream().map(row -> (DeployNode)row.getIdentifier()).collect(Collectors.toList());
    }

    @Override
    public JPanel getLayout() {
        return this.layout;
    }

    @Override
    public void clearDevTable() {
        this.layout.getModel().removeAll();
        Context.INS.clearNodes();
    }

    @Override
    public IUIObserver getObs() {
        return this.obs;
    }

    @Override
    public DeployTaskManager getTaskManager() {
        return this.deployTaskManager;
    }

    @Override
    public void refreshDevTable(List<DeployNode> nodes) {
        Collections.sort(nodes);
        Context.INS.addNodes(nodes);
        this.layout.getModel().addRows(nodes.stream().map(this::createRow).collect(Collectors.toList()));
        this.obs.initDevUIData(nodes);
    }

    @Override
    public TableRow createRow(DeployNode node) {
        Status status = node.getDeployTask().getStatus();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeadLength(), (Object)node, (Object)node);
        int index = 0;
        row.setValueAt(index++, (Object)node.getDevType());
        row.setValueAt(index++, (Object)node.getSn());
        row.setValueAt(index++, (Object)node.getIp());
        row.setValueAt(index++, (Object)new IsmTableCell.ProgressCell(node.getDeployTask().getProgress()));
        row.setValueAt(index++, (Object)new IsmTableCell.IconCell((Icon)status.getIcon(), status.getDesc()));
        row.setValueAt(index, (Object)"--");
        return row;
    }

    @Override
    public boolean isNeedSelectVersion() {
        return true;
    }

    @Override
    public List<DeployNode> buildDevNode(Map<String, List<Map<String, Attribute>>> fileData) throws ImportFileException, ToolException {
        ClusterInfo clusterInfo = this.parsedClusterInfo(fileData);
        List devices = (List)new FullDeploySceneDevsStrategyTask(fileData.get("storageNode"), fileData.get("storageNodeDS")).run();
        this.parsedNetworkConfigStrategy(devices, fileData, clusterInfo);
        if (fileData.containsKey("directPlane")) {
            devices.addAll((Collection)new DirectPlaneNodesStrategyTask(fileData.get("directPlane"), fileData.getOrDefault("directPlaneDS", Collections.emptyList())).run());
        }
        return devices;
    }

    protected ClusterInfo parsedClusterInfo(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        Map<String, Attribute> clusterInfoData = fileDatas.get("clusterInfo").get(0);
        Map<String, Attribute> networkPlanData = fileDatas.get("networkPlan").get(0);
        List<Map<String, Attribute>> bondPlanData = fileDatas.get("bondPlan");
        List<Map<String, Attribute>> vlanPlanData = fileDatas.get("vlanPlan");
        return (ClusterInfo)new ClusterInfoStrategyTask(clusterInfoData, networkPlanData, bondPlanData, vlanPlanData).run();
    }

    protected void parsedNetworkConfigStrategy(List<DeployNode> devs, Map<String, List<Map<String, Attribute>>> fileDatas, ClusterInfo clusterInfo) throws ImportFileException, ToolException {
        Set<String> bmcIps = devs.stream().map(DeployNode::getIpAddress).map(IpAddress::getIp).collect(Collectors.toSet());
        Map ip2ConfigStrategies = (Map)new OsNetworkStrategyTask(fileDatas, clusterInfo, bmcIps).run();
        new StaticRouteStrategyTask(fileDatas.get("staticRoutePlan"), ip2ConfigStrategies).run();
        new PolicyRouteStrategyTask(fileDatas.get("strategyRoutePlan"), ip2ConfigStrategies).run();
        this.addStrategyToDev(devs, ip2ConfigStrategies);
    }

    protected void addStrategyToDev(List<DeployNode> devs, Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        log.info("ip2ConfigStrategies: {}", ip2ConfigStrategies);
        devs.forEach(dev -> dev.setOsNetworkStrategys((List)ip2ConfigStrategies.get(dev.getIpAddress().getIp())));
    }

    @Override
    public void exportReport() {
        List<DeployNode> nodes = Context.INS.getAllNodes();
        if (nodes.isEmpty()) {
            log.info("Export report but empty node.");
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"export.report.empty.node"));
            return;
        }
        if (this.obs.hasRunningDev() && 0 != DialogUtils.showYesNoDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"export.report.running.confirm.msg"), (boolean)true).getValue()) {
            log.info("Export report in running status but cancel.");
            return;
        }
        ReportBuilder builder = new ReportBuilder();
        ProgressDialog progressDialog = new ProgressDialog((Window)Context.INS.getMain(), ResourceUtil.getString((String)"export.report.box.msg"), 220);
        List ret = AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> builder.buildReport(nodes, Context.INS.getReportDir())});
        this.handelReportBuildRet(ret);
    }

    protected void handelReportBuildRet(List<Object> ret) {
        Object retObj = ret.get(0);
        if (retObj instanceof ToolException) {
            ToolException exp = (ToolException)retObj;
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)exp.getErrorLocaleDescription());
            return;
        }
        String msgId = Boolean.TRUE.equals(retObj) ? "export.report.success" : "export.report.common.err";
        DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)msgId));
    }

    @Override
    public DeployNode getCurrentShowNode() {
        return this.currentShowNode;
    }
}

