/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.card;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.MatchCheckDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.card.MainFrameCard;
import com.huawei.ism.tool.distributeddeploy.ui.layout.MatchCheckLayout;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class MatchCheckCard
extends MainFrameCard {
    private static final String CHECK_OS_KEY = "checkOS";
    private static final String CHECK_HARD_KEY = "checkHard";
    private MatchCheckLayout matchCheckLayout;

    public MatchCheckCard(Card.CardScene scene) {
        super(scene);
    }

    @Override
    protected void init() {
        this.matchCheckLayout = new MatchCheckLayout(this.cardScene);
        this.layout = this.matchCheckLayout;
        this.initStrategy();
        this.bindListener();
    }

    private void initStrategy() {
        Context.INS.getMatchCheckStrategy().add(CHECK_OS_KEY);
        Context.INS.getMatchCheckStrategy().add(CHECK_HARD_KEY);
    }

    @Override
    protected void bindListener() {
        super.bindListener();
        this.matchCheckLayout.getHard().addItemListener(event -> {
            this.checkStrategy(this.matchCheckLayout.getHard());
            Set<String> strategy = Context.INS.getMatchCheckStrategy();
            boolean select = this.matchCheckLayout.getHard().isSelected();
            if (select) {
                strategy.add(CHECK_HARD_KEY);
            } else {
                strategy.remove(CHECK_HARD_KEY);
            }
        });
        this.matchCheckLayout.getSoft().addItemListener(event -> {
            this.checkStrategy(this.matchCheckLayout.getSoft());
            boolean select = this.matchCheckLayout.getSoft().isSelected();
            Set<String> strategy = Context.INS.getMatchCheckStrategy();
            if (select) {
                strategy.add(CHECK_OS_KEY);
            } else {
                strategy.remove(CHECK_OS_KEY);
            }
        });
    }

    private void checkStrategy(JCheckBox currentStrategy) {
        if (this.matchCheckLayout.getStrategyCheckBox().stream().allMatch(strategy -> !strategy.isSelected())) {
            DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"matchCheck.strategy.check"));
            currentStrategy.setSelected(true);
            return;
        }
    }

    @Override
    public List<DeployNode> buildDevNode(Map<String, List<Map<String, Attribute>>> fileData) throws ImportFileException, ToolException {
        return (List)new MatchCheckDeploySceneDevsStrategyTask(fileData.get("storageNode")).run();
    }

    @Override
    public TableRow createRow(DeployNode node) {
        Status status = node.getDeployTask().getStatus();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeadLength(), (Object)node, (Object)node);
        int index = 0;
        row.setValueAt(index++, (Object)node.getDevType());
        row.setValueAt(index++, (Object)node.getNodeName());
        row.setValueAt(index++, (Object)node.getIp());
        row.setValueAt(index++, (Object)new IsmTableCell.ProgressCell(node.getDeployTask().getProgress()));
        row.setValueAt(index++, (Object)new IsmTableCell.IconCell((Icon)status.getIcon(), status.getDesc()));
        row.setValueAt(index, (Object)"--");
        return row;
    }

    @Override
    public void refreshDevTable(List<DeployNode> nodes) {
        Collections.sort(nodes);
        Context.INS.addNodes(nodes);
        this.layout.getModel().addRows(nodes.stream().map(this::createRow).collect(Collectors.toList()));
        this.obs.initDevUIData(nodes);
        this.matchCheckLayout.getStrategyCheckBox().stream().peek(strategy -> strategy.setEnabled(true)).forEach(strategy -> strategy.setSelected(true));
        this.initStrategy();
    }

    public void enableStrategy() {
        this.matchCheckLayout.getStrategyCheckBox().stream().forEach(strategy -> strategy.setEnabled(false));
    }
}

