/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.component;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.border.MatteBorder;

public class Label
extends JLabel {
    private static final Color SELECTED_COLOR = new Color(51, 153, 255);
    private static final Color MOUSE_ON_FONT_COLOR = new Color(16542473);
    private static final Color UNDER_LINE_BORDER = new Color(204, 204, 204);
    private static final int BORDER_SIZE = 5;
    private static final MatteBorder DEFAULT_MATTE_BORDER = new MatteBorder(0, 0, 1, 0, UNDER_LINE_BORDER);
    private static final MatteBorder SUSPENDED_MATTE_BORDER = new MatteBorder(0, 0, 5, 0, MOUSE_ON_FONT_COLOR);
    private static final MatteBorder SELECT_MATTE_BORDER = new MatteBorder(0, 0, 5, 0, SELECTED_COLOR);
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private Font font = new Font("Microsoft YaHei", 0, 15);
    private String labelName;
    private String labelId;
    private Dimension dimension = new Dimension(200, 30);
    private LabelObservable observable = new LabelObservable(this);
    private boolean selected = false;

    Label(StepInfo stepInfo, Observer obs) {
        super(stepInfo.getName(), Constants.WAIT_IMG, 0);
        this.labelId = stepInfo.getId();
        this.setIconTextGap(12);
        this.labelName = stepInfo.getName();
        this.initColor();
        this.observable.addObserver(obs);
        this.bindListener();
    }

    Label(String name, Observer obs, Color backColor, Color textColor) {
        super(name, 0);
        this.setForeground(textColor);
        this.setIconTextGap(12);
        this.labelName = name;
        this.labelId = name;
        this.initColor4TopLabel();
        this.observable.addObserver(obs);
        this.bindTopLabelListener();
        this.setBackground(backColor);
    }

    public LabelObservable getObservable() {
        return this.observable;
    }

    private void initColor4TopLabel() {
        this.setOpaque(false);
        this.setPreferredSize(this.dimension);
        this.setMinimumSize(this.dimension);
        this.setMaximumSize(this.dimension);
        this.setFont(this.font);
    }

    private void initColor() {
        this.setOpaque(false);
        this.setPreferredSize(this.dimension);
        this.setMinimumSize(this.dimension);
        this.setMaximumSize(this.dimension);
        this.setFont(this.font);
        this.setBorder(DEFAULT_MATTE_BORDER);
    }

    void defaultUI() {
        this.setCursor(DEFAULT_CURSOR);
        this.setBorder(DEFAULT_MATTE_BORDER);
        this.selected = false;
    }

    void defaultUI4TopLabel() {
        this.setCursor(DEFAULT_CURSOR);
        this.setBorder(null);
        this.selected = false;
    }

    private void suspendedUI() {
        this.setOpaque(true);
        this.setBorder(SUSPENDED_MATTE_BORDER);
        this.setCursor(HAND_CURSOR);
    }

    void selectedUI() {
        this.setOpaque(false);
        this.setBorder(SELECT_MATTE_BORDER);
        this.setCursor(HAND_CURSOR);
        this.selected = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    private void bindTopLabelListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                if (Context.INS.getUIObs().hasRunningDev()) {
                    DialogUtils.showInfoDialog((Frame)Context.INS.getMain(), (String)ResourceUtil.getString((String)"mainFrame.changeLabel.waring"));
                    return;
                }
                Label.this.observable.click();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                Label.this.suspendedUI();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                Label.this.defaultUI4TopLabel();
            }
        });
    }

    private void bindListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                Label.this.observable.click();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                Label.this.suspendedUI();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (Label.this.selected) {
                    return;
                }
                Label.this.defaultUI();
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label other = (Label)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$labelId = this.getLabelId();
        String other$labelId = other.getLabelId();
        return !(this$labelId == null ? other$labelId != null : !this$labelId.equals(other$labelId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Label;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $labelId = this.getLabelId();
        result = result * 59 + ($labelId == null ? 43 : $labelId.hashCode());
        return result;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public class LabelObservable
    extends Observable {
        private Label label;

        LabelObservable(Label label) {
            this.label = label;
        }

        public void click() {
            Label.this.selectedUI();
            this.setChanged();
            this.notifyObservers(this.label);
        }

        public Label getLabel() {
            return this.label;
        }
    }
}

