/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.component;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.component.Label;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class LabelComponent
extends JPanel
implements Observer {
    private List<Label> labels = new ArrayList<Label>();

    public LabelComponent(String sceneId) {
        this.updateComponentUI(ProductStrategy.INS.getStepInfoByScene(sceneId), sceneId);
    }

    public void updateComponentUI(List<StepInfo> stepInfos) {
        this.updateComponentUI(stepInfos, Context.INS.getCurrentScene().getKey());
    }

    private void updateComponentUI(List<StepInfo> stepInfos, String sceneId) {
        this.labels.clear();
        this.removeAll();
        this.init(stepInfos, sceneId);
        int compMargin = ApplicationContext.getInstance().isEnglishEnv() ? 5 : 0;
        this.setLayout(new BorderLayout());
        this.add(UCD.buildHorizotalBox(null, (int)compMargin, (Component[])this.labels.toArray(new Label[0])));
    }

    private void init(List<StepInfo> stepInfos, String sceneId) {
        stepInfos.forEach(stepInfo -> this.labels.add(new Label((StepInfo)stepInfo, this)));
        if (Card.CardScene.MATCH_CHECK.getKey().equals(sceneId)) {
            this.labels.forEach(label -> {
                String name = ResourceUtil.getString((String)"init_node");
                label.setLabelName(name);
                label.setText(name);
            });
        }
    }

    public Label findLabel(StepTask stepTask) {
        return this.labels.stream().filter(label -> label.getLabelId().equals(stepTask.getStepInfo().getId())).findFirst().get();
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.updateLabelWhenSelect(arg);
        this.updateDetailUI(observable);
    }

    private void updateDetailUI(Observable observable) {
        Context.INS.getUIObs().updateDetailWhenLabelChange(observable);
    }

    private void updateLabelWhenSelect(Object arg) {
        if (arg instanceof Label) {
            this.labels.forEach(label -> {
                if (!label.equals(arg)) {
                    label.defaultUI();
                }
            });
        }
    }
}

