/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.component;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.CardInfo;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.component.Label;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuComponent
extends JPanel
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(MenuComponent.class);
    private Map<Card.CardScene, Label> labels = new HashMap<Card.CardScene, Label>();
    private static final Color BACKGROUND_COLOR = new Color(75, 81, 107);
    private static final Color TEXT_COLOR = new Color(255, 255, 255);
    private JButton helpChm = this.buildHelpButton(Constants.HELP_IMG, "toolHelper");

    public MenuComponent() {
        this.init();
        this.setLayout(new BorderLayout());
        JComponent leftComponent = this.initLeftComponent();
        JComponent rightComponent = this.initRightComponent();
        this.add((Component)leftComponent, "West");
        this.add((Component)rightComponent, "East");
        this.setBackground(BACKGROUND_COLOR);
        this.bindListener();
    }

    private void bindListener() {
        this.helpChm.addActionListener(this::openHelpChm);
    }

    private JComponent initRightComponent() {
        Box functionComponent = UCD.buildHBoxRight((Component[])new Component[]{this.helpChm, Box.createHorizontalStrut(6)});
        return UCD.buildHBoxRight((Component[])new Component[]{functionComponent});
    }

    private JComponent initLeftComponent() {
        Box logo = UCD.buildHBoxLeft((Component[])new Component[]{new JLabel(Constants.TOP_ICON_IMG, 0)});
        JComponent sceneComponent = this.initSceneComponent();
        return UCD.buildHBoxLeft((int)8, (Component[])new Component[]{Box.createHorizontalStrut(0), logo, new JLabel(Constants.VERTICAL_LINE), sceneComponent, Box.createHorizontalGlue()});
    }

    private JComponent initSceneComponent() {
        List<JComponent> list = ProductStrategy.INS.getModeList().stream().map(CardInfo::getSceneId).map(Card.CardScene::mappingEnum).map(this.labels::get).collect(Collectors.toList());
        return UCD.buildHBoxLeft((int)0, (Component[])list.toArray(new JComponent[0]));
    }

    private void init() {
        Card.CardScene firstScene = Card.CardScene.mappingEnum(ProductStrategy.INS.getModeList().get(0).getSceneId());
        ProductStrategy.INS.getModeList().forEach(mode -> this.labels.put(Card.CardScene.mappingEnum(mode.getSceneId()), new Label(mode.getSceneDes(), this, BACKGROUND_COLOR, TEXT_COLOR)));
        this.labels.keySet().stream().filter(scene -> !scene.equals((Object)firstScene)).map(scene -> this.labels.get(scene)).forEach(Label::defaultUI4TopLabel);
        this.labels.get((Object)firstScene).selectedUI();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof JLabel) {
            this.updateLabelWhenSelect(arg);
            this.labels.entrySet().stream().filter(kv -> ((Label)kv.getValue()).equals(arg)).findFirst().ifPresent(kv -> Context.INS.getMain().switchoverCenter((Card.CardScene)((Object)((Object)kv.getKey()))));
        }
    }

    private void updateLabelWhenSelect(Object arg) {
        this.labels.entrySet().stream().filter(kv -> !((Label)kv.getValue()).equals(arg)).map(kv -> (Label)kv.getValue()).forEach(Label::defaultUI4TopLabel);
    }

    private JButton buildHelpButton(ImageIcon icon, String name) {
        JButton button = new JButton("", icon);
        button.setPreferredSize(new Dimension(16, 25));
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setAlignmentX(7.0f);
        button.setRolloverIcon(Constants.HELP_COVER_IMG);
        button.putClientProperty("AccessibleName", name);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setIconTextGap(20);
        button.setToolTipText(ResourceUtil.getString((String)"deploy.tool.help.tips"));
        button.setBackground(BACKGROUND_COLOR);
        return button;
    }

    private void openHelpChm(ActionEvent event) {
        log.info("Click open chm button.");
        FileUtils.openHelpFile((String)"DistributedDeployHelper", (Window)Context.INS.getMain(), (String)".chm");
    }
}

