/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.DeployFileParseService;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.ui.UIConstants;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.combo.IsmComboBox;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFileDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportFileDialog.class);
    private static final String MAPPING_BOX_DEFAULT_VALUE = ResourceUtil.getString((String)"importFile.mappingBox.defaultValue");
    private static final String DEPLOY_STRATEGY_FILE_PATH = "config/wizard/deployFileParseStrategy.xml";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("config.DistributeDeployHelper");
    private List<DeployNode> deployNodes = new ArrayList<DeployNode>();
    private Map<String, String> mappingVersionName2Key = new HashMap<String, String>();
    private JButton confirmButton = UiMethod.createButton((String)ResourceUtil.getString((String)"importFile.button.confirm"));
    private JButton cancelButton = UiMethod.createButton((String)ResourceUtil.getString((String)"importFile.button.cancel"));
    private JButton selectButton = UiMethod.createButton((String)ResourceUtil.getString((String)"importFile.button.select"));
    private JTextField importPathField = new IsmTextField(new PlainDocument(), "", 120);
    private JLabel importDesc = new JLabel(ResourceUtil.getString((String)"importFile.import.desc"));
    private IsmComboBox mappingVersionBox = new IsmComboBox();
    private File deployFile = null;
    private Card parentCard;

    public ImportFileDialog(Card card) {
        super((Frame)Context.INS.getMain(), true);
        this.parentCard = card;
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"importFile.dialog.title"));
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        JComponent view = this.initUI();
        this.initPreferredSize();
        this.add((Component)view, "North");
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putParentCenter((Window)this, (Window)Context.INS.getMain());
        this.bindListener();
    }

    private void initPreferredSize() {
        if (this.parentCard.isNeedSelectVersion()) {
            this.setPreferredSize(UIConstants.IMPORT_DIALOG_SIZE);
        } else {
            this.setPreferredSize(UIConstants.IMPORT_DIALOG_SIZE_NO_NEED_VERSION);
        }
    }

    private void bindListener() {
        this.selectButton.addActionListener(this::selectImportFile);
        this.confirmButton.addActionListener(this::confirmAction);
        this.cancelButton.addActionListener(e -> this.dispose());
    }

    private void confirmAction(ActionEvent e) {
        if (this.parentCard.isNeedSelectVersion() && MAPPING_BOX_DEFAULT_VALUE.equals(this.mappingVersionBox.getSelectedItem())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"importFile.mapping.empty"));
            LOGGER.info("No choose mapping version.");
            return;
        }
        if (this.deployFile == null) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"importFile.confirmCheck.emptyNode"));
            LOGGER.info("No select deploy file.");
            return;
        }
        if (!this.fileChecker(this.deployFile) || !this.parseFile(this.deployFile)) {
            return;
        }
        if (this.deployNodes.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"importFile.confirmCheck.emptyNode"));
            LOGGER.info("Deploy node is empty.");
            return;
        }
        if (!Context.INS.getMain().isEmptyDevTable() && 0 != DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"importFile.clearDev.description")).getValue()) {
            LOGGER.info("Cancel import node.");
            return;
        }
        if (this.deployNodes.size() > ToolConfig.getMaxNodeNum()) {
            LOGGER.warn("Import node num {} is more than limit {}", (Object)this.deployNodes.size(), (Object)ToolConfig.getMaxNodeNum());
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"importFile.node.num.waring", (Object[])new Object[]{ToolConfig.getMaxNodeNum(), this.deployNodes.size()}));
            return;
        }
        if (this.parentCard.isNeedSelectVersion()) {
            Context.INS.setCurrentMappingVersion(this.mappingVersionName2Key.get(Objects.requireNonNull(this.mappingVersionBox.getSelectedItem()).toString()));
        }
        Context.INS.getMain().clearDevTable();
        Context.INS.getMain().refreshDevTable(this.deployNodes);
        this.dispose();
    }

    private void selectImportFile(ActionEvent e) {
        File selectFile = this.showChooseDialogToGetFile();
        if (selectFile == null) {
            return;
        }
        try {
            this.deployFile = selectFile;
            this.updateUI(this.deployFile.getCanonicalPath());
        }
        catch (IOException ex) {
            LOGGER.info("get deploy file path.", (Throwable)ex);
        }
    }

    private boolean parseFile(File deployFile) {
        ProgressDialog progressDialog = new ProgressDialog((Window)this, ResourceUtil.getString((String)"importFile.busyBox.msg"), 220);
        List ret = AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> Context.INS.getMain().getCurrentCard().buildDevNode(DeployFileParseService.doParsing(deployFile, DEPLOY_STRATEGY_FILE_PATH))});
        Object resultObj = ret.get(0);
        return this.handleResult(resultObj);
    }

    private boolean handleResult(Object resultObj) {
        if (resultObj instanceof ImportFileException) {
            LOGGER.error("wrong data of deploy file.");
            ImportFileException exception = (ImportFileException)resultObj;
            this.showParseErrMsgDialog(exception.getErrDatas());
            return false;
        }
        if (resultObj instanceof ToolException) {
            ToolException exception = (ToolException)resultObj;
            DialogUtils.showErrorDialog((JDialog)this, (String)exception.getErrorId());
            return false;
        }
        if (resultObj instanceof List) {
            this.deployNodes = (List)resultObj;
            return true;
        }
        LOGGER.error("parse file exception", (Throwable)((Exception)resultObj));
        DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"importFile.data.readFileFailed"));
        return false;
    }

    private boolean fileChecker(File deployFile) {
        int limit = ToolConfig.getMaxDeployFileSize();
        if (!ToolConfig.isDebugModel() && deployFile.length() > (long)(limit * 1024 * 1024)) {
            LOGGER.warn("Deploy file size {} over limit {}M.", (Object)deployFile.length(), (Object)limit);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"importFile.fileSize.overLimit", (Object[])new Object[]{limit}));
            return false;
        }
        return true;
    }

    private void updateUI(String path) {
        this.importPathField.setText(path);
        this.importPathField.setToolTipText(path);
        this.importPathField.setCaretPosition(0);
    }

    private void showParseErrMsgDialog(List<ArrayList<Object>> errDatas) {
        String[] headers = new String[]{ResourceUtil.getString((String)"importFile.err.title.position"), ResourceUtil.getString((String)"importFile.err.title.description")};
        DialogUtils.showMultiErrorDialog((Window)this, (String)ResourceUtil.getString((String)"importFile.err.prompt"), (String[])headers, errDatas);
    }

    private File showChooseDialogToGetFile() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"mainFrame.button.importConfig"));
        extParams.put("PathId", "DistributedDeployHelper_deploy_file_path");
        extParams.put("description", ".xls; .xlsx;");
        return ToolFileChooser.selectFile((Window)this, (String[])new String[]{".xls", "xlsx"}, (int)0, (boolean)true, extParams);
    }

    private JComponent initUI() {
        JComponent view;
        JComponent importComponent = this.initImportUI();
        JComponent buttonComponent = this.initButtonUI();
        if (this.parentCard.isNeedSelectVersion()) {
            JComponent mappingComponent = this.initMappingUI();
            view = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{importComponent, mappingComponent, buttonComponent});
        } else {
            view = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{importComponent, buttonComponent});
        }
        return UiMethod.buildFrameSpace((JComponent)view, (int)12);
    }

    private JComponent initButtonUI() {
        return UCD.buildHBoxRight((Component[])new Component[]{this.confirmButton, this.cancelButton});
    }

    private JComponent initMappingUI() {
        this.supportDevice();
        this.mappingVersionName2Key.keySet().stream().sorted().forEach(arg_0 -> this.mappingVersionBox.addItem(arg_0));
        this.mappingVersionBox.setDefaultDisplayValue(MAPPING_BOX_DEFAULT_VALUE);
        JLabel desc = new JLabel(ResourceUtil.getString((String)"importFile.mapping.desc"));
        Box mappingComponent = UCD.buildHBoxLeft((Component[])new Component[]{desc, Box.createHorizontalStrut(0), this.mappingVersionBox});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{mappingComponent});
    }

    void supportDevice() {
        Set<String> keys = VersionMappingStrategy.INS.getStrategy().keySet();
        Set supportDevice = Arrays.stream(BUNDLE.getString("distributed.deploy.helper.support.device").split(",")).collect(Collectors.toSet());
        keys.stream().filter(key -> !key.contains("nfv.dedicated.3")).filter(key -> !VersionMappingStrategy.INS.getCubeVersion().contains(key)).filter(supportDevice::contains).forEach(key -> this.mappingVersionName2Key.put("--".equals(ResourceUtil.getString((String)key)) ? key : ResourceUtil.getString((String)key), (String)key));
    }

    private JComponent initImportUI() {
        this.importPathField.setEditable(false);
        this.importPathField.setHorizontalAlignment(2);
        this.importPathField.setCaretPosition(0);
        return UCD.buildHBoxLeft((Component[])new Component[]{this.importDesc, Box.createHorizontalStrut(0), this.importPathField, this.selectButton});
    }
}

