/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.dialog;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.service.ignore.IgnoreService;
import com.huawei.ism.tool.distributeddeploy.service.report.HtmlResUtils;
import com.huawei.ism.tool.distributeddeploy.ui.UIConstants;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ItemDetailDialog
extends JDialog {
    private ItemTask itemTask;
    private JButton retryButton = UiMethod.createButton((String)ResourceUtil.getString((String)"item.dialog.retry"));
    private JButton closeButton = UiMethod.createButton((String)ResourceUtil.getString((String)"item.dialog.close"));
    private JButton ignoredButton = UiMethod.createButton((String)ResourceUtil.getString((String)"item.dialog.ignored"));

    public ItemDetailDialog(ItemTask itemTask) {
        super((Frame)Context.INS.getMain(), true);
        this.itemTask = itemTask;
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"item.dialog.tittle"));
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setPreferredSize(UIConstants.ITEM_DETAIL_DIALOG_SIZE);
        JComponent view = this.initUI();
        this.setLayout(new BorderLayout());
        this.add((Component)view, "Center");
        this.pack();
        this.setResizable(true);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putParentCenter((Window)this, (Window)Context.INS.getMain());
        this.bindListener();
    }

    private void bindListener() {
        this.closeButton.addActionListener(e -> this.dispose());
        this.retryButton.addActionListener(e -> this.retryItem());
        this.ignoredButton.addActionListener(e -> this.ignoredItem());
    }

    private void ignoredItem() {
        this.itemTask.ignoredResult();
        this.dispose();
    }

    private void retryItem() {
        this.itemTask.retryDeploySingle();
        this.dispose();
    }

    private JComponent initUI() {
        JComponent originalInfoPane = this.initOriginalInfoPane();
        JComponent resultPane = this.initResultInfoPane();
        JComponent buttonComponent = this.initButton();
        return UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{originalInfoPane, resultPane, buttonComponent}), (int)12);
    }

    private JComponent initResultInfoPane() {
        JLabel label = new JLabel(ResourceUtil.getString((String)"item.dialog.result.desc"));
        JScrollPane scrollPane = this.createScrollPane(this.itemTask.getRetMsg(), UIConstants.ITEM_DETAIL_RESULT_PANE_SIZE);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{label}), scrollPane});
    }

    private JComponent initOriginalInfoPane() {
        JLabel label = new JLabel(ResourceUtil.getString((String)"item.dialog.original.desc"));
        JScrollPane scrollPane = this.createScrollPane(this.itemTask.getOriginalInfo(), UIConstants.ITEM_DETAIL_ORIGINAL_PANE_SIZE);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{label}), scrollPane});
    }

    private JScrollPane createScrollPane(String content, Dimension size) {
        JScrollPane scrollPane = new JScrollPane();
        JEditorPane infoArea = new JEditorPane();
        infoArea.setContentType("text/html;charset=utf-8");
        infoArea.setText(this.getHtml(content));
        infoArea.setEditable(false);
        infoArea.setCaretPosition(0);
        infoArea.getScrollableTracksViewportHeight();
        infoArea.setMargin(this.getTextInset());
        infoArea.setPreferredSize(size);
        scrollPane.setPreferredSize(size);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setViewportView(infoArea);
        return scrollPane;
    }

    private JComponent initButton() {
        boolean finish = this.itemTask.getNode().getDeployTask().isFinish();
        this.retryButton.setEnabled(finish);
        this.ignoredButton.setEnabled(finish);
        this.retryButton.setToolTipText(finish ? null : ResourceUtil.getString((String)"item.dialog.retry.tips"));
        if (ToolConfig.isDebugModel() || this.itemTask.isManualIgnored() || IgnoreService.canIgnoreItem(this.itemTask)) {
            return UiMethod.buildCompsRight((Component[])new Component[]{this.ignoredButton, this.retryButton, this.closeButton});
        }
        return UiMethod.buildCompsRight((Component[])new Component[]{this.retryButton, this.closeButton});
    }

    private String getHtml(String content) {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"" + HtmlEnums.XHTML_TRANSITIONAL.getResourceValue() + "\">" + System.lineSeparator() + "<html xmlns=\"" + HtmlEnums.XHTML.getResourceValue() + "\">" + System.lineSeparator() + "<head>" + System.lineSeparator() + "<style type= \"text/css\">body{ font-size:9px;color:#464646;}.exp{font-size:10px;color:#252525;font-weight:bold}.link{color:#4286d3;}selected::selection{color:#ffffff;background:#990000;}selected::-moz-selection{background:#990000;}</style>" + System.lineSeparator() + "</head>" + System.lineSeparator() + "<body>" + System.lineSeparator() + HtmlResUtils.handelHtmlContent(content) + "</body></html>";
    }

    private Insets getTextInset() {
        return new Insets(0, 5, 0, 0);
    }
}

