/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.dialog;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.UIConstants;
import com.huawei.ism.tool.distributeddeploy.ui.card.BmcIpFrameCard;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.card.MainFrameCard;
import com.huawei.ism.tool.distributeddeploy.ui.card.MatchCheckCard;
import com.huawei.ism.tool.distributeddeploy.ui.component.LabelComponent;
import com.huawei.ism.tool.distributeddeploy.ui.component.MenuComponent;
import com.huawei.ism.tool.distributeddeploy.ui.component.StepDetailComponent;
import com.huawei.ism.tool.distributeddeploy.ui.layout.BottomButtonLayout;
import com.huawei.ism.tool.distributeddeploy.ui.layout.MainFrameLayout;
import com.huawei.ism.tool.distributeddeploy.ui.listener.CloseObserver;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class MainFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainFrame.class);
    private BottomButtonLayout bottombuttonLayout = new BottomButtonLayout();
    private MenuComponent menuComponent = new MenuComponent();
    Map<Card.CardScene, Card> sceneCardMap = new HashMap<Card.CardScene, Card>();

    public MainFrame() {
        this.initUI();
        this.setLocationRelativeTo(null);
        this.bindListener();
        this.initGifObserver();
    }

    private void initGifObserver() {
        Constants.RUNNING_IMG.setImageObserver(this);
        Constants.ITEM_RUNNING_IMG.setImageObserver(this);
    }

    private void initUI() {
        this.buildLayout();
        this.setResizable(true);
        this.setIconImage(Constants.TOOL_ICON.getImage());
        this.setDefaultCloseOperation(0);
        this.pack();
        this.initFrameSize();
        SwingUtil.putScreenCenter((Window)this);
        this.initTittle();
    }

    private void buildLayout() {
        this.initHeadPanel();
        this.initCenterPanel();
        this.buildSouthPanel();
    }

    private void initHeadPanel() {
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new BorderLayout());
        headPanel.add(this.menuComponent);
        this.add((Component)headPanel, "North");
    }

    private void initCenterPanel() {
        this.sceneCardMap.put(Card.CardScene.MAIN, new MainFrameCard(Card.CardScene.MAIN));
        this.sceneCardMap.put(Card.CardScene.BMC_IP_CONFIG, new BmcIpFrameCard());
        this.sceneCardMap.put(Card.CardScene.MATCH_CHECK, new MatchCheckCard(Card.CardScene.MATCH_CHECK));
        Context.INS.setCurrentScene(Card.CardScene.mappingEnum(ProductStrategy.INS.getModeList().get(0).getSceneId()));
        this.add((Component)this.sceneCardMap.get((Object)Context.INS.getCurrentScene()).getLayout(), "Center");
    }

    private void buildSouthPanel() {
        this.add((Component)this.bottombuttonLayout, "South");
    }

    public void switchoverCenter(Card.CardScene scene) {
        this.sceneCardMap.values().forEach(panel -> this.remove(panel.getLayout()));
        this.add((Component)this.sceneCardMap.get((Object)scene).getLayout(), "Center");
        this.setResizable(true);
        Context.INS.setCurrentScene(scene);
    }

    private void bindListener() {
        this.addWindowListener(new CloseObserver());
        this.bindBottomButtonListener();
    }

    private void bindBottomButtonListener() {
        this.bottombuttonLayout.getExportReport().addActionListener(this::exportReport);
        this.bottombuttonLayout.getViewReport().addActionListener(this::viewReport);
        this.bottombuttonLayout.getModifyReport().addActionListener(this::modifyReportDir);
    }

    private void viewReport(ActionEvent event) {
        File reportDir = new File(Context.INS.getReportDir());
        if (!reportDir.exists()) {
            LOGGER.error("Open report dir error.");
            return;
        }
        LOGGER.info("open report dir {} result {}", (Object)reportDir, (Object)OSCmdUtils.explorerFile((String)Context.INS.getReportDir()));
    }

    private void modifyReportDir(ActionEvent event) {
        LOGGER.info("Click modify report button.");
        String reportDir = Context.INS.getReportDir();
        File target = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"mainFrame.top.export.tittle"), (String[])new String[0], (String)"export.report.path", (String)ResourceUtil.getString((String)"export.file.chooser.desc"), (int)1);
        try {
            if (this.chooseInvalid(target)) {
                Context.INS.setReportDir(reportDir);
                return;
            }
            Context.INS.setReportDir(target.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("Dump report dir error.");
        }
    }

    private boolean chooseInvalid(File target) throws IOException {
        if (target == null) {
            LOGGER.warn("Target dir is null");
            return true;
        }
        if (!target.canWrite()) {
            LOGGER.info("Target dir {} can not write.", (Object)target.getCanonicalPath());
            DialogUtils.showErrorDialog((Window)this, (String)ResourceUtil.getString((String)"mainFrame.top.export.canNotWrite"));
            return true;
        }
        if (!FilesUtil.checkNormalPath((String)target.getCanonicalPath())) {
            DialogUtils.showInfoDialog((Frame)this, (String)ResourceUtil.getString((String)"path.check"));
            return true;
        }
        return false;
    }

    private void exportReport(ActionEvent event) {
        this.getCurrentCard().exportReport();
    }

    private void initFrameSize() {
        this.setPreferredSize(UIConstants.DEFAULT_TOOL_WINDOW_SIZE);
        this.setMinimumSize(UIConstants.DEFAULT_TOOL_WINDOW_SIZE);
    }

    private void initTittle() {
        this.setTitle(ResourceUtil.getString((String)"tool.funcItem.name"));
    }

    public MainFrameLayout getMainLayout() {
        return (MainFrameLayout)this.getCurrentCard().getLayout();
    }

    public DeployTaskManager getDeployTaskManager() {
        return this.getCurrentCard().getTaskManager();
    }

    public Card getCurrentCard() {
        return this.sceneCardMap.get((Object)Context.INS.getCurrentScene());
    }

    public void refreshDevTable(List<DeployNode> nodes) {
        this.getCurrentCard().refreshDevTable(nodes);
    }

    public void clearDevTable() {
        this.getCurrentCard().clearDevTable();
    }

    public boolean isEmptyDevTable() {
        return Context.INS.getAllNodes().isEmpty();
    }

    public IUIObserver getObs() {
        return this.getCurrentCard().getObs();
    }

    public DeployNode getCurrentShowNode() {
        return this.sceneCardMap.get((Object)Context.INS.getCurrentScene()).getCurrentShowNode();
    }

    public LabelComponent getLabelComponent() {
        return this.getMainLayout().getLabelComponent();
    }

    public StepDetailComponent getStepTaskDetail() {
        return this.getMainLayout().getStepDetailComponent();
    }

    public IsmTable getDeviceTable() {
        return this.getMainLayout().getDeviceTable();
    }
}

