/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.layout;

import com.huawei.ism.tool.distributeddeploy.ui.UIConstants;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.component.LabelComponent;
import com.huawei.ism.tool.distributeddeploy.ui.component.StepDetailComponent;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class MainFrameLayout
extends JPanel {
    private static final String LAN = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
    private static final String ZH = "zh";
    protected String[] deviceTableHead;
    protected ToolHyperLinkLabel deployTemplate = new ToolHyperLinkLabel(ResourceUtil.getString((String)"mainFrame.top.deployTemplate"));
    protected ToolHyperLinkLabel supportList = new ToolHyperLinkLabel(ResourceUtil.getString((String)"mainFrame.top.supportList"));
    protected JButton startDeploy = UiMethod.createButton((String)ResourceUtil.getString((String)"mainFrame.button.startDeploy"));
    protected JButton importConfig = UiMethod.createButton((String)ResourceUtil.getString((String)"mainFrame.button.importConfig"));
    protected DefaultTableModel model;
    protected IsmTable deviceTable;
    protected LabelComponent labelComponent;
    protected StepDetailComponent stepDetailComponent;
    protected Card.CardScene scene;
    protected TableScrollPane deviceScrollPane;

    public MainFrameLayout(Card.CardScene scene) {
        this.scene = scene;
        this.setLayout(new BorderLayout());
        this.initUI();
        this.initComponentTips();
    }

    protected void initUI() {
        this.initDevicePanel();
        JComponent topTableComponent = this.initTopTableComponent();
        this.deviceScrollPane.addComponent2ButtonArea(new JComponent[]{topTableComponent});
        this.deviceScrollPane.setPreferredSize(UIConstants.DEVICE_TABLE_SIZE);
        JComponent topComponent = this.initTopComponent();
        this.labelComponent = new LabelComponent(this.scene.getKey());
        this.stepDetailComponent = new StepDetailComponent();
        Box bottomComponent = this.buildBottomFrameSpace(12, Arrays.asList(this.labelComponent, this.stepDetailComponent));
        this.add((Component)topComponent, "Center");
        this.add((Component)bottomComponent, "South");
    }

    protected void initDevicePanel() {
        this.deviceTableHead = new String[]{ResourceUtil.getString((String)"supportDialog.tittle.model"), ResourceUtil.getString((String)"mainFrame.table.sn"), ResourceUtil.getString((String)"mainFrame.table.bmcIp"), ResourceUtil.getString((String)"mainFrame.table.progress"), ResourceUtil.getString((String)"mainFrame.table.status"), ResourceUtil.getString((String)"mainFrame.table.op")};
        this.model = new DefaultTableModel(this.deviceTableHead, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.model);
        this.deviceScrollPane = TableScrollPane.createTablePane((IsmTable)this.deviceTable, (boolean)true, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.TABLE_LEFT_UP);
    }

    protected JComponent initTopTableComponent() {
        return UiMethod.buildCompsLeft((int)12, (Component[])new Component[]{this.startDeploy, this.importConfig});
    }

    protected JComponent initTopComponent() {
        return UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{this.initTopLabel(), this.deviceScrollPane}), (int)12);
    }

    protected void initComponentTips() {
        if (!ApplicationContext.getInstance().isEnglishEnv()) {
            return;
        }
        this.importConfig.setToolTipText(this.importConfig.getText());
    }

    protected JComponent initTopLabel() {
        return MainFrameLayout.getComponentByLanguage(this.deployTemplate, this.supportList);
    }

    public static JComponent getComponentByLanguage(ToolHyperLinkLabel deployTemplate, ToolHyperLinkLabel supportList) {
        if (ZH.equals(LAN)) {
            return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc1")), deployTemplate, new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc2")), new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc3")), supportList, new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc4"))});
        }
        JPanel jComponent = UCD.createBoxLayoutPane((int)1);
        JComponent upJPanel = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc1")), deployTemplate, new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc2"))});
        JComponent downJPanel = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc3")), supportList, new JLabel(ResourceUtil.getString((String)"mainFrame.top.desc4"))});
        jComponent.add(upJPanel);
        jComponent.add(downJPanel);
        return jComponent;
    }

    protected Box buildBottomFrameSpace(int margin, List<JComponent> componentList) {
        Box vBox = Box.createVerticalBox();
        componentList.stream().map(component -> this.buildHorizontalBox((JComponent)component, margin)).forEach(hBox -> {
            vBox.add((Component)hBox);
            vBox.add(Box.createVerticalStrut(margin));
        });
        return vBox;
    }

    protected Box buildHorizontalBox(JComponent component, int hMargin) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(hMargin));
        hBox.add(component);
        hBox.add(Box.createHorizontalStrut(hMargin));
        return hBox;
    }

    public int getTableHeadLength() {
        return this.deviceTableHead.length;
    }

    public ToolHyperLinkLabel getDeployTemplate() {
        return this.deployTemplate;
    }

    public ToolHyperLinkLabel getSupportList() {
        return this.supportList;
    }

    public JButton getStartDeploy() {
        return this.startDeploy;
    }

    public JButton getImportConfig() {
        return this.importConfig;
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public LabelComponent getLabelComponent() {
        return this.labelComponent;
    }

    public StepDetailComponent getStepDetailComponent() {
        return this.stepDetailComponent;
    }
}

