/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.listener;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.service.report.ReportBuilder;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.MainFrame;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseObserver
extends WindowAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseObserver.class);

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    private void close() {
        LOGGER.info("Click close button.");
        if (!this.closeCheck()) {
            return;
        }
        try {
            this.clearEnv();
            Context.INS.getMain().dispose();
            this.callBackSceneInfo();
        }
        catch (Throwable e) {
            LOGGER.error("Close window error.", e);
        }
        finally {
            LOGGER.info("Close tool -> exit");
            Runtime.getRuntime().exit(0);
        }
    }

    private void callBackSceneInfo() throws ToolException {
        List nodeList = Context.INS.getAllNodes().stream().filter(node -> node.getDeployTask().isAbnormal() || node.getDeployTask().isNormal()).collect(Collectors.toList());
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (nodeList.isEmpty()) {
            return;
        }
        nodeList.stream().forEach(node -> {
            HashMap<String, String> data = new HashMap<String, String>();
            String sn = node.getSn();
            if (StringUtils.isNULLStr((String)sn)) {
                sn = "constructedSn" + node.getIp();
            }
            data.put("SN", sn);
            data.put("IP", node.getIp());
            data.put("status", this.judeStatus((DeployNode)node));
            data.put("toolId", "DistributeDeployHelper");
            resultList.add(data);
        });
        TaskResult result = SceneEnvironmentImpl.getInstance().finishedSceneTask(resultList);
        LOGGER.info("Call back scene info result {}.", (Object)result.isTaskSuccess());
    }

    private String judeStatus(DeployNode node) {
        if (node.getDeployTask().isNormal()) {
            return TaskResult.Result.SUCCESS.toString();
        }
        return TaskResult.Result.FAILED.toString();
    }

    private void clearEnv() {
        FileUtils.clearDir((String)ReportBuilder.REPORT_TEMP);
    }

    private boolean closeCheck() {
        WarningDialog dialog;
        MainFrame mainFrame = Context.INS.getMain();
        String msg = ResourceUtil.getString((String)"mainFrame.exit.waring.default");
        if (Context.INS.getUIObs().hasRunningDev()) {
            msg = ResourceUtil.getString((String)"mainFrame.exit.waring");
        }
        return 0 == (dialog = DialogUtils.showWarnConfirmDialog((Window)mainFrame, (String)msg, (String)ResourceUtil.getString((String)"mainFrame.exit.confirm"))).getValue();
    }
}

