/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.listener;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTemplate
implements ToolHyperLinkLabel.ClickListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportTemplate.class);
    private static final String EATS = "xlsx";
    private static final String DEPLOY_TEMPLATE = "DeployTemplate";
    private static final String TEMPLATE_PATH = ApplicationContext.getInstance().isEnglishEnv() ? String.format("/config/template/DeployTemplate_%s.xlsx", "en") : String.format("/config/template/DeployTemplate_%s.xlsx", "zh");

    public void clickLink(MouseEvent me) {
        File targetFile = this.getExportDialogFile();
        if (!this.checkExportDir(targetFile)) {
            return;
        }
        if (!this.outputTemPlate(targetFile)) {
            DialogUtils.showErrorDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"mainFrame.top.export.failed"));
            return;
        }
        OSCmdUtils.explorerFile((File)targetFile.getParentFile());
    }

    public boolean outputTemPlate(File targetFile) {
        return this.outputTemPlate(TEMPLATE_PATH, targetFile);
    }

    public boolean outputTemPlate(String srcPath, File targetFile) {
        try (BufferedInputStream bis = new BufferedInputStream(Objects.requireNonNull(this.getClass().getResourceAsStream(srcPath)));
             BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetFile.toPath(), new OpenOption[0]));){
            int len;
            byte[] buffer = new byte[5120];
            while ((len = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Export file error.", e);
            return false;
        }
        return true;
    }

    private boolean checkExportDir(File selectFile) {
        if (selectFile == null) {
            return false;
        }
        if (!selectFile.getParentFile().canWrite()) {
            DialogUtils.showErrorDialog((Window)Context.INS.getMain(), (String)ResourceUtil.getString((String)"mainFrame.top.export.canNotWrite"));
            return false;
        }
        return true;
    }

    private File getExportDialogFile() {
        String filePath = ToolFileChooser.getSaveFilePath((String)ResourceUtil.getString((String)"mainFrame.top.export.tittle"), (String)EATS, (Window)Context.INS.getMain(), (String)DEPLOY_TEMPLATE, (String)"export.template.path");
        if (StringUtils.isNULLStr((String)filePath)) {
            return null;
        }
        return new File(filePath);
    }
}

