/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.listener;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.ItemInfo;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.ItemDetailDialog;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.MainFrame;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemClickListener
extends MouseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemClickListener.class);

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() > 1) {
            return;
        }
        MainFrame mainFrame = Context.INS.getMain();
        int rowIndex = this.getListIndex(event.getPoint(), mainFrame.getStepTaskDetail().getDetailList());
        if (-1 == rowIndex) {
            return;
        }
        DefaultListModel model = (DefaultListModel)mainFrame.getStepTaskDetail().getDetailList().getModel();
        Object obj = model.getElementAt(rowIndex);
        if (obj instanceof ItemTask) {
            ItemTask itemTask = (ItemTask)obj;
            if (ItemInfo.Type.SINGLE.equals((Object)itemTask.getType())) {
                return;
            }
            if (itemTask.getStatus() == Status.ITEM_RUNNING || itemTask.getStatus() == Status.WAITING_EXEC) {
                LOGGER.info("Click running or waiting item,don't show detail.");
                return;
            }
            new ItemDetailDialog(itemTask).setVisible(true);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

