/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.listener;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.Product;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.SupportDialog;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowSupportListener
implements ToolHyperLinkLabel.ClickListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowSupportListener.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("config.DistributeDeployHelper");

    public void clickLink(MouseEvent me) {
        LOGGER.info("Click show support list.");
        SupportDialog dialog = new SupportDialog(Context.INS.getMain());
        Set supportDevice = Arrays.stream(BUNDLE.getString("distributed.deploy.helper.support.device").split(",")).collect(Collectors.toSet());
        dialog.initData(ProductStrategy.INS.getProducts().entrySet().stream().filter(entry -> !VersionMappingStrategy.INS.getCubeVersion().contains(entry.getKey())).filter(entry -> supportDevice.contains(entry.getKey())).map(entry -> Arrays.asList(ResourceUtil.getString((String)((String)entry.getKey())), this.joinVersionProductNames(((Map)entry.getValue()).values()))).sorted(Comparator.comparing(data -> (String)data.get(0))).collect(Collectors.toList()));
        dialog.setVisible(true);
    }

    private String joinVersionProductNames(Collection<Product> products) {
        return products.stream().map(product -> product.getName().split(",")).flatMap(Arrays::stream).map(String::trim).filter(this::isFullOrNotOcean).distinct().collect(Collectors.joining(","));
    }

    private boolean isFullOrNotOcean(String name) {
        if (Context.INS.getCurrentScene() == Card.CardScene.MAIN) {
            return true;
        }
        return ToolConfig.getDefaultIpMap().keySet().stream().noneMatch(name::contains);
    }
}

