/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.ui.renderer;

import com.huawei.ism.tool.distributeddeploy.entity.ItemInfo;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.ui.UIConstants;
import com.huawei.ism.tool.distributeddeploy.ui.component.ProgressBox;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmTextPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StepTaskDetailRenderer
extends DefaultListCellRenderer {
    private static final int DETAIL_LABEL_WIDTH = ApplicationContext.getInstance().isEnglishEnv() ? 50 : 30;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel viewPan = this.buildViewPan(list, value);
        this.initComponentColor(list, (ItemTask)value, isSelected, viewPan);
        return viewPan;
    }

    private void initComponentColor(JList list, ItemTask itemTask, boolean isSelected, JPanel viewPan) {
        if (isSelected && ItemInfo.Type.SINGLE != itemTask.getType()) {
            viewPan.setBackground(list.getSelectionBackground());
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
    }

    private JPanel buildViewPan(JList list, Object value) {
        JPanel viewPan = new JPanel();
        viewPan.setLayout(new BorderLayout());
        if (value instanceof ItemTask) {
            this.initItemTaskView((ItemTask)value, viewPan);
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        return viewPan;
    }

    private void initItemTaskView(ItemTask itemTask, JPanel viewPan) {
        if (ItemInfo.Type.MULTI == itemTask.getType()) {
            viewPan.add((Component)this.createItemDesc(itemTask), "North");
        }
        if (ItemInfo.Type.SINGLE == itemTask.getType()) {
            viewPan.add((Component)this.createSingleItemDesc(itemTask), "North");
        }
    }

    private JComponent createItemDesc(ItemTask itemTask) {
        JLabel startTime = new JLabel(itemTask.getStartDate());
        JLabel msg = new JLabel(itemTask.getName());
        JLabel status = new JLabel(itemTask.getStatus().getDesc(), itemTask.getStatus().getIcon(), 0);
        ToolHyperLinkLabel detail = new ToolHyperLinkLabel("  ");
        UCD.setSameWidth((int)DETAIL_LABEL_WIDTH, (JComponent[])new JComponent[]{detail});
        if (itemTask.getStatus().equals((Object)Status.ITEM_RUNNING)) {
            return new ProgressBox(null, itemTask.getProgress(), new Component[]{startTime, msg, Box.createGlue(), status, detail, Box.createHorizontalStrut(8)});
        }
        if (itemTask.isFinish() && !itemTask.isNormal()) {
            detail.setText(ResourceUtil.getString((String)"deploy.status.detail"));
        }
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{startTime, msg, Box.createGlue(), status, detail, Box.createHorizontalStrut(8)});
    }

    private JComponent createSingleItemDesc(ItemTask itemTask) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JLabel startTime = new JLabel(itemTask.getStartDate());
        JComponent proComponent = this.createProgressComponent(itemTask);
        IsmTextPane area = new IsmTextPane(itemTask.getSingleOriginalInfo());
        JComponent component = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{startTime}), proComponent, UCD.buildHBoxLeft((Component[])new Component[]{area}), Box.createVerticalStrut(15)});
        container.setBackground(Color.WHITE);
        container.add((Component)component, "West");
        return UiMethod.buildFrameSpace((JComponent)container, (int)12);
    }

    private JComponent createProgressComponent(ItemTask itemTask) {
        JProgressBar progress = new JProgressBar();
        progress.setValue(itemTask.getProgress());
        UiMethod.setComponentSize((Dimension)UIConstants.SINGLE_ITEM_PROGRESS_BAR_SIZE, (Component[])new Component[]{progress});
        JLabel progressLabel = new JLabel(itemTask.getProgress() + "%");
        return UCD.buildHBoxLeft((Component[])new Component[]{progress, progressLabel});
    }
}

