/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.service;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicegraph.ui.DeviceGraphPanel;
import com.huawei.ism.tool.devicegraph.ui.components.RackPanel;
import com.huawei.ism.tool.devicegraph.util.BayComparator;
import com.huawei.ism.tool.devicegraph.util.DeviceGraphContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubui.common.IDeviceGraphUI;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;

public class DeviceGraphUiImpl
implements IDeviceGraphUI {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceGraphUiImpl.class);
    private static final String SMB0 = "SMB0";

    @Override
    public AbstractDeviceGraph buildDeviceGraph(String deviceType, List<IHardwareInfo> hardwareList, boolean isBack, boolean isSupportLight) {
        List<IEnclosureInfo> enclosures = this.getEnclosures(hardwareList);
        Map<String, List<IEnclosureInfo>> bayEnclosuresMap = this.classifyEnclosureByBay(enclosures);
        List<IHardwareInfo> hardwaresExceptEn = this.getHardwaresExceptEn(hardwareList);
        List<String> sortedKeys = this.baySort(bayEnclosuresMap.keySet());
        int rackIndex = 0;
        ArrayList<RackPanel> racks = new ArrayList<RackPanel>();
        for (String key : sortedKeys) {
            RackPanel rp = new RackPanel(bayEnclosuresMap.get(key), hardwaresExceptEn, rackIndex++, key, isBack);
            boolean smb0 = SMB0.equals(key);
            rp.setSMB0(smb0);
            racks.add(rp);
        }
        DeviceGraphPanel graph = new DeviceGraphPanel(racks, isSupportLight, isBack);
        DeviceGraphContext.getInstance().saveSingleObject("DEVICE_GRAPH", graph);
        return graph;
    }

    private List<IEnclosureInfo> getEnclosures(List<IHardwareInfo> hradwares) {
        ArrayList<IEnclosureInfo> enList = new ArrayList<IEnclosureInfo>();
        List<IHardwareInfo> enclosures = this.getHardwares(MOType.ENCLOSURE, hradwares);
        for (IHardwareInfo enclosure : enclosures) {
            enList.add((IEnclosureInfo)enclosure);
        }
        return enList;
    }

    private List<IHardwareInfo> getHardwaresExceptEn(List<IHardwareInfo> hradwares) {
        ArrayList<IHardwareInfo> hardwaresExceptEn = new ArrayList<IHardwareInfo>();
        for (IHardwareInfo hardware : hradwares) {
            if (MOType.ENCLOSURE.name().equals(hardware.getTypeName())) continue;
            hardwaresExceptEn.add(hardware);
        }
        return hardwaresExceptEn;
    }

    private List<IHardwareInfo> getHardwares(MOType moType, List<IHardwareInfo> hradwares) {
        ArrayList<IHardwareInfo> list = new ArrayList<IHardwareInfo>();
        for (IHardwareInfo hardware : hradwares) {
            if (!moType.name().equals(hardware.getTypeName())) continue;
            list.add(hardware);
        }
        return list;
    }

    private Map<String, List<IEnclosureInfo>> classifyEnclosureByBay(List<IEnclosureInfo> enclosureList) {
        TreeMap<String, List<IEnclosureInfo>> map = new TreeMap<String, List<IEnclosureInfo>>();
        String location = null;
        for (IEnclosureInfo enclosure : enclosureList) {
            location = enclosure.getLocation();
            if (!this.validateLocaion(location)) continue;
            String bayName = location.split("\\.")[0];
            ArrayList<IEnclosureInfo> list = (ArrayList<IEnclosureInfo>)map.get(bayName);
            if (null == list) {
                list = new ArrayList<IEnclosureInfo>();
                list.add(enclosure);
                map.put(bayName, list);
                continue;
            }
            list.add(enclosure);
        }
        return map;
    }

    private boolean validateLocaion(String location) {
        if (StringUtils.isNULLStr(location) || !location.contains(".")) {
            LOGGER.error("loctaion field is not right, location: " + location);
            return false;
        }
        return true;
    }

    private List<String> baySort(Set<String> unSortKeys) {
        ArrayList<String> sortKeys = new ArrayList<String>();
        for (String key : unSortKeys) {
            sortKeys.add(key);
        }
        Collections.sort(sortKeys, new BayComparator());
        return sortKeys;
    }
}

