/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.a800switch;

import com.huawei.ism.tool.a800switch.SwitchSTelnetMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum A800SwitchType {
    NOT_SUPPORT("", "", "", EnumSet.noneOf(SwitchSTelnetMode.class), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()),
    CE5855_48T4XS("HUAWEI CE5855-48T4XS", "/switch_config/switch_snmp_info.cfg", "/switch_config/switch_netconf_info.cfg", EnumSet.allOf(SwitchSTelnetMode.class), Collections.singletonList("/switch_config/mgmt_switch_global_vlan.cfg"), Collections.emptyList(), Collections.emptyList()),
    CE9855_32DQ("HUAWEI CE9855-32DQ", "/switch_config/switch_snmp_info.cfg", "/switch_config/switch_netconf_info.cfg", EnumSet.allOf(SwitchSTelnetMode.class), Collections.emptyList(), Arrays.asList("/switch_config/scale-out_L1_switch_split.cfg", "/switch_config/scale-out_L1_switch_trunk.cfg", "/switch_config/scale-out_L1_switch_region.cfg", "/switch_config/scale-out_L1_switch_region_port.cfg", "/switch_config/scale-out_L1_switch_lldp.cfg", "/switch_config/scale-out_L1_switch_lldp_port.cfg", "/switch_config/scale-out_L1_switch_rdma.cfg", "/switch_config/scale-out_L1_switch_rdma_port.cfg", "/switch_config/scale-out_L1_switch_vlan.cfg", "/switch_config/scale-out_L1_switch_vlan_port.cfg", "/switch_config/scale-out_L1_switch_save_configuration.cfg"), Arrays.asList("/switch_config/scale-out_L2_switch_trunk.cfg", "/switch_config/scale-out_L2_switch_region.cfg", "/switch_config/scale-out_L2_switch_lldp.cfg", "/switch_config/scale-out_L2_switch_lldp_port.cfg", "/switch_config/scale-out_L2_switch_rdma.cfg", "/switch_config/scale-out_L2_switch_rdma_port.cfg", "/switch_config/scale-out_L2_switch_vlan.cfg", "/switch_config/scale-out_L2_switch_vlan_port.cfg", "/switch_config/scale-out_L2_switch_save_configuration.cfg"));

    private final String switchUniqueName;
    private final String snmpConfigFile;
    private final String netconfConfigFile;
    private final EnumSet<SwitchSTelnetMode> sTelnetModes;
    private final List<String> mgmtConfigFiles;
    private final List<String> scaleOutL1ConfigFiles;
    private final List<String> scaleOutL2ConfigFiles;

    public static A800SwitchType of(String displayVersion) {
        return EnumSet.allOf(A800SwitchType.class).stream().filter(switchType -> StringUtils.isNotEmpty((CharSequence)switchType.getSwitchUniqueName()) && displayVersion.contains(switchType.getSwitchUniqueName())).findFirst().orElse(NOT_SUPPORT);
    }

    public String getSwitchUniqueName() {
        return this.switchUniqueName;
    }

    public String getSnmpConfigFile() {
        return this.snmpConfigFile;
    }

    public String getNetconfConfigFile() {
        return this.netconfConfigFile;
    }

    public EnumSet<SwitchSTelnetMode> getSTelnetModes() {
        return this.sTelnetModes;
    }

    public List<String> getMgmtConfigFiles() {
        return this.mgmtConfigFiles;
    }

    public List<String> getScaleOutL1ConfigFiles() {
        return this.scaleOutL1ConfigFiles;
    }

    public List<String> getScaleOutL2ConfigFiles() {
        return this.scaleOutL2ConfigFiles;
    }

    private A800SwitchType(String switchUniqueName, String snmpConfigFile, String netconfConfigFile, EnumSet<SwitchSTelnetMode> sTelnetModes, List<String> mgmtConfigFiles, List<String> scaleOutL1ConfigFiles, List<String> scaleOutL2ConfigFiles) {
        this.switchUniqueName = switchUniqueName;
        this.snmpConfigFile = snmpConfigFile;
        this.netconfConfigFile = netconfConfigFile;
        this.sTelnetModes = sTelnetModes;
        this.mgmtConfigFiles = mgmtConfigFiles;
        this.scaleOutL1ConfigFiles = scaleOutL1ConfigFiles;
        this.scaleOutL2ConfigFiles = scaleOutL2ConfigFiles;
    }
}

