/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.a800switch;

import com.huawei.ism.tool.a800switch.SwitchParamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwitchNetConfParam
implements SwitchParamHandler {
    private String username;
    private String password;
    private int port;

    @Override
    public Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("{username}", this.username);
        params.put("{password}", this.password);
        params.put("{port}", String.valueOf(this.port));
        return params;
    }

    @Override
    public List<String> getSensitiveKeys() {
        return Collections.singletonList(this.password);
    }

    @Override
    public boolean isNeedExecute(String command) {
        if (command.contains("protocol inbound ssh port")) {
            return this.port == 830;
        }
        return SwitchParamHandler.super.isNeedExecute(command);
    }

    SwitchNetConfParam(String username, String password, int port) {
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public static SwitchNetConfParamBuilder builder() {
        return new SwitchNetConfParamBuilder();
    }

    public static class SwitchNetConfParamBuilder {
        private String username;
        private String password;
        private int port;

        SwitchNetConfParamBuilder() {
        }

        public SwitchNetConfParamBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SwitchNetConfParamBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SwitchNetConfParamBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SwitchNetConfParam build() {
            return new SwitchNetConfParam(this.username, this.password, this.port);
        }

        public String toString() {
            return "SwitchNetConfParam.SwitchNetConfParamBuilder(username=" + this.username + ", password=" + this.password + ", port=" + this.port + ")";
        }
    }
}

