/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.cert.auth;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.cert.auth.AbstractAuthStep;
import com.huawei.ism.tool.cert.auth.AuthResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class RestAuthStep
extends AbstractAuthStep {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RestAuthStep.class);

    public RestAuthStep(DevNode devNode, int port) {
        super(devNode, port);
        this.addCertList("/config/devicecerts/pki_ca.crt");
    }

    @Override
    public String getAlarmId() {
        return AuthResult.ALARMID_DEVICE_CRT_FAILED_TV3;
    }

    @Override
    public String getCrtFileName() {
        return "devicemanager_ca.crt";
    }

    @Override
    public boolean checkCrl() {
        return false;
    }

    @Override
    public String getCrtPath() {
        String certPath = "";
        String ipForPath = this.getIpFixedPath();
        certPath = System.getProperty("user.dir") + CERTBASE + ipForPath + File.separator + "ca.crt";
        File certFile = FileUtils.getFile((String[])new String[]{certPath});
        if (!certFile.exists()) {
            LOGGER.info("Use the default.Not find cert for {} on {}", (Object)ipForPath, (Object)certPath);
            certPath = "/config/devicecerts/" + this.getCrtFileName();
        }
        return certPath;
    }

    @Override
    public int process() {
        int result = -1;
        try {
            result = super.process();
            LOGGER.info("support rest.{} and result:{}", (Object)this.getIp(), (Object)result);
        }
        catch (IsmException e) {
            LOGGER.error("error when check support rest, maybe not support.{}  {} {}", new Object[]{this.getIp(), this.getPort(), e});
        }
        catch (Exception e) {
            LOGGER.error("error when check support rest{} {} {}", this.getIp(), this.getPort(), e);
        }
        return result;
    }

    @Override
    public String[] getSSLType() {
        return new String[]{"TLSv1.2"};
    }
}

