/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class DefaultSshJudge
implements ISshJudge {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DefaultSshJudge.class);
    private static final List<String> SPECIAL_END_STR = Arrays.asList("]");
    private static final Set<String> EXCLUDED_END_JUDGE_STATIC = Collections.synchronizedSet(new HashSet());
    private final List<String> diyEndStr = new ArrayList<String>();
    private Set<String> excludeEndJudge = new HashSet<String>();

    public static void addExcludeEndJudgeStatic(String endJudge) {
        LOGGER.info("endjudgeStatic added:{}", (Object)endJudge);
        EXCLUDED_END_JUDGE_STATIC.add(endJudge);
    }

    public void addExcludeEndJudge(String endJudge) {
        LOGGER.info("endjudge added:{}", (Object)endJudge);
        this.excludeEndJudge.add(endJudge);
    }

    @Override
    public boolean isSshFinish(String cmdResult, String userName) {
        if (null == cmdResult) {
            return false;
        }
        boolean resPart1 = (cmdResult = cmdResult.trim()).endsWith("Enter Password:") || cmdResult.endsWith("debug>") || cmdResult.endsWith("logout") || cmdResult.endsWith("Are you sure to exit?(y/n):");
        boolean resPart2 = cmdResult.endsWith("Are you sure you want to enter this mode? (y/n)") || cmdResult.endsWith(":~ #") || cmdResult.endsWith(":/>") || cmdResult.endsWith("OceanStor: a>");
        boolean resPart3 = cmdResult.endsWith("AK-I:~ #") || cmdResult.endsWith("osp:") || cmdResult.endsWith("spu ui>") || cmdResult.endsWith("Password:");
        boolean resPart4 = cmdResult.endsWith("#") || cmdResult.endsWith(":/") || cmdResult.endsWith("$") || cmdResult.endsWith("MML>");
        boolean resPart5 = cmdResult.endsWith("Password:") || cmdResult.endsWith(userName + ">") || cmdResult.endsWith("OSM>") || cmdResult.endsWith("already logged in.");
        boolean resPart6 = cmdResult.endsWith("LegoRuntime>") || cmdResult.endsWith("ism_host_agent>") || cmdResult.endsWith("DataCollect>") || cmdResult.endsWith("~>");
        boolean resPart7 = cmdResult.endsWith("continue?(y/n)") || cmdResult.endsWith("mode?(y/n):") || cmdResult.endsWith("password:") || cmdResult.endsWith("\u53e3\u4ee4\uff1a") || cmdResult.endsWith("minisystem>");
        boolean resPart8 = cmdResult.endsWith("diagnose>") || cmdResult.endsWith("carefully?(y/n)") || cmdResult.endsWith("operation?(y/n)") || cmdResult.endsWith("Input package name:") || cmdResult.endsWith("by comma:") || cmdResult.endsWith("port type:");
        boolean resPart9 = cmdResult.endsWith("Please select y or n:[n]") || cmdResult.endsWith("Are you sure to restart?(y/n)") || cmdResult.endsWith("/diagnose>") || cmdResult.endsWith("(y/n)");
        boolean resPart10 = cmdResult.endsWith("Upgrade success") || cmdResult.endsWith("/home/permitdir>") || cmdResult.endsWith("(yes/no)?");
        boolean resPart14 = cmdResult.endsWith("to quit]");
        boolean resPart11 = resPart1 || resPart2 || resPart3 || resPart4;
        boolean resPart12 = resPart5 || resPart6 || resPart7 || resPart8;
        boolean resPart13 = resPart9 || resPart10;
        boolean rePart16 = cmdResult.endsWith("cli%");
        return resPart11 || resPart12 || resPart13 || resPart14 || this.canJudgeEndBySpecialStr(cmdResult) || rePart16;
    }

    private boolean canJudgeEndBySpecialStr(String cmdResult) {
        return SPECIAL_END_STR.stream().anyMatch(endStr -> cmdResult.endsWith((String)endStr) && !this.isExcludeEndStr((String)endStr)) || this.diyEndStr.stream().anyMatch(endStr -> cmdResult.contains((CharSequence)endStr));
    }

    private boolean isExcludeEndStr(String endStr) {
        return this.excludeEndJudge.contains(endStr) || EXCLUDED_END_JUDGE_STATIC.contains(endStr);
    }

    public void appendSpecialEndStr(String str) {
        this.diyEndStr.add(str);
    }
}

