/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.connection.AbstractGrabConn;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class FileConnection
extends AbstractGrabConn {
    private static final String END_CMD = "EndCmd:";
    private static final String START_CMD = "StartCmd:";
    private Map<String, String> echoValueMap = new HashMap<String, String>();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileConnection.class);
    private DevNode devNode;

    public FileConnection(DevNode devNode) {
        this.devNode = devNode;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    @Override
    public String execCmd(String command) throws ToolException {
        return this.execCmdWithTimout(command, 0);
    }

    public String executeCmdTimeoutLcalWmic(String command, int timeout) throws ToolException {
        return this.execCmdWithTimout(command, 0);
    }

    @Override
    public String execCmdNoLog(String command) throws ToolException {
        return this.execCmdWithTimout(command, 10);
    }

    @Override
    public String execCmdHasLog(String command) throws ToolException {
        return this.execCmdWithTimout(command, 10);
    }

    @Override
    public String execCmdNoLog(String command, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(command, 10);
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    @Override
    public void execCmdWithOutReturn(String command) throws ToolException {
        LOGGER.info("method execCmdWithOutReturn invked...");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execCmdWithTimout(String command, int timeout) throws ToolException {
        int idxOfAnd = command.indexOf(38);
        command = idxOfAnd < 0 ? command : command.substring(idxOfAnd + 1);
        String charSet = this.getCharset();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.devNode.getDevInfoPkgPath()), charSet));){
            String line;
            boolean isStartMatch = false;
            String key = null;
            StringBuilder data = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.startsWith(START_CMD)) {
                    data = new StringBuilder();
                    key = line.substring(line.indexOf(58) + 1);
                    if (!command.trim().equalsIgnoreCase(key.trim())) continue;
                    isStartMatch = true;
                    LOGGER.info("isStartMatch matched.");
                    continue;
                }
                if (isStartMatch && line.trim().equals(END_CMD + key)) {
                    String string = "~>" + command + System.lineSeparator() + data.toString();
                    return string;
                }
                if (!isStartMatch || StringUtils.isNULLStr((String)line.trim())) continue;
                data.append(line);
                data.append(System.lineSeparator());
            }
            return command + ToolConstants.ENTER + "TOOLKIT_EXE_CMD_FAILED";
        }
        catch (Exception e) {
            LOGGER.error("execute cmd error", e);
        }
        return command + ToolConstants.ENTER + "TOOLKIT_EXE_CMD_FAILED";
    }

    public String getCharset() {
        String charSet;
        try {
            charSet = CommonEncodeDetectUtils.endcodeDetect(this.devNode.getDevInfoPkgPath());
        }
        catch (Exception e1) {
            charSet = "UTF-8";
            LOGGER.error("eochde error..");
        }
        return charSet;
    }

    @Override
    public void setCLIMode(CliCmdModel mode) {
        LOGGER.info("setCLIMode invoked...{}", (Object)this.devNode.getIp());
    }

    @Override
    public void close() {
    }

    @Override
    public void connect() throws ToolException {
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine, int timeout) throws ToolException {
        LOGGER.info("asyncExecReturnEntity invked...");
        return null;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, int keepInterval, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmdWithKeepAlive(String cmd, ICliConnection.SSHCmdParamEntity paramEntity) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    @Override
    public String execCmdWithTimout(String commandLine, int timeout, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmd(String commandLine, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmdWithNoCheckResult(String commandLine, int timeOut) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String executeCmdTimeout(String commandLine, int timeOut) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public void execSwitchRootCmd(DevNode device) throws ToolException {
    }

    @Override
    public Object execSql(String sql) throws ToolException {
        return new DBCmdResultSet(sql, this.execCmdWithTimout(sql, 10));
    }

    @Override
    public Map<String, String> getEchoValue() {
        return this.echoValueMap;
    }

    public String getIp() {
        return this.getDevNode().getIp();
    }

    public class DBCmdResultSet {
        private String sqlName;
        private Object sqlResult;

        public DBCmdResultSet(String sqlName, Object sqlResult) {
            this.sqlName = sqlName;
            this.sqlResult = sqlResult;
        }

        public String getSqlName() {
            return this.sqlName;
        }

        public void setSqlName(String sqlName) {
            this.sqlName = sqlName;
        }

        public Object getSqlResult() {
            return this.sqlResult;
        }

        public void setSqlResult(ResultSet sqlResult) {
            this.sqlResult = sqlResult;
        }
    }
}

