/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SftpProgressListener;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.support.SftpPermWrapper;
import com.huawei.ism.tool.obase.connection.support.SftpProgressMonitor;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.SftpUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.sftp.SftpTransfer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SftpTransporter {
    private static final Logger log = LoggerFactory.getLogger(SftpTransporter.class);
    private static final int MAX_PROGRESS = 100;
    private static final int DEFAULT_PORT = 22;
    private static final int VERIFY_TIME_MIN = 3;
    private SftpClient sftpClient;
    private SshConnection needCloseConnection = null;
    private SshConnection originalConnection = null;
    private int retryTimes = 0;
    private int retryInterval = 0;
    private long extraSpace = 0L;
    private boolean sizeCheckEnable = true;
    private static int globalRetryTimes = 0;
    private static int globalRetryInterval = 10000;

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public static void setGlobalRetryTimes(int globalRetryTimes) {
        SftpTransporter.globalRetryTimes = globalRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval != 0 ? this.retryInterval : globalRetryInterval;
    }

    public static int getGlobalRetryInterval() {
        return globalRetryInterval;
    }

    public static void setGlobalRetryInterval(int globalRetryInterval) {
        SftpTransporter.globalRetryInterval = globalRetryInterval;
        log.info("Thread name :{} id : {}set global Sftp times to:{}", Thread.currentThread().getName(), Thread.currentThread().getId(), globalRetryInterval);
    }

    public int getRetryTimes() {
        return this.retryTimes == 0 ? globalRetryTimes : this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        log.info("Thread name :{} id : {}set Sftp times to:{} originalConnection:{}", Thread.currentThread().getName(), Thread.currentThread().getId(), retryTimes, this.originalConnection);
    }

    public static int getGlobalRetryTimes() {
        return globalRetryTimes;
    }

    public SftpTransporter(ICliConnection cliConnection) throws ToolException {
        log.info("init sftpTransporter with cliConnection {}", (Object)cliConnection);
        if (!(cliConnection instanceof SshConnection)) {
            throw new ToolException("cliConnection must be SshConnection", false);
        }
        this.originalConnection = (SshConnection)cliConnection;
        if (!this.originalConnection.isConnected()) {
            throw new ToolException("connection losted by" + this.originalConnection, false);
        }
        try {
            this.sftpClient = SftpClientFactory.instance().createSftpClient(this.originalConnection.getSession());
            this.originalConnection.getSession().setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.RESERVED, TimeUnit.MINUTES, 3L);
        }
        catch (Exception e) {
            log.error("build conn error!", e);
            try {
                this.reConnect();
            }
            catch (Exception e1) {
                log.error("rebuild conn error!", e1);
                throw new ToolException("create SFTPv3Client error." + this.originalConnection, false, (Throwable)e);
            }
        }
    }

    public SftpTransporter(ICliConnection cliConnection, User user) throws ToolException {
        log.info("init sftpTransporter with cliConnection: {} and user: {}", (Object)cliConnection, (Object)user);
        if (!(cliConnection instanceof SshConnection)) {
            throw new ToolException("cliConnection must be SshConnection", false);
        }
        this.originalConnection = (SshConnection)cliConnection;
        this.needCloseConnection = this.createNewConnection(this.originalConnection, user);
        this.init(this.needCloseConnection);
    }

    public SftpTransporter(String ip, String uname, String passwd) throws ToolException {
        SshConnection connection = new SshConnection(ip, uname, passwd, 22);
        this.sftpClient = this.createSftpChannel(connection);
    }

    public SftpTransporter(String ip, User user) throws ToolException {
        this(ip, user.getUserName(), user.getPassword());
    }

    private SftpClient createSftpChannel(SshConnection sshConnection) {
        try {
            sshConnection.initSession();
            return SftpClientFactory.instance().createSftpClient(sshConnection.getSession());
        }
        catch (Exception e) {
            log.error("sftp init session err", e);
            return null;
        }
    }

    private SshConnection createNewConnection(SshConnection sshConnection, User user) {
        DevNode devNode = sshConnection.getdNode();
        if (devNode != null) {
            try {
                log.info("try to create new temp connection for {}", (Object)devNode.getIp());
                return (SshConnection)SshConnectionManager.getSshConnectionWithoutCache(devNode, sshConnection.getSshEndJudgeIntf(), sshConnection.isPwdWillExpireBreak(), sshConnection.isDeviceMgr());
            }
            catch (ToolException exception) {
                log.error("try to create new temp connection for {} error", (Object)devNode.getIp(), (Object)exception);
            }
        }
        String host = sshConnection.getHost();
        int port = sshConnection.getPort();
        String pwd = user.getPassword();
        SshConnection newConnection = new SshConnection(host, user.getUserName(), pwd, port);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
        newConnection.setProxyData(sshConnection.getProxyData());
        return newConnection;
    }

    public void reConnect() throws ToolException {
        try {
            if (this.needCloseConnection != null) {
                log.info("needCloseConnection!=null...,reconnect..");
                if (this.sftpClient != null) {
                    this.sftpClient.close();
                    this.sftpClient = null;
                }
                this.init(this.originalConnection);
            } else if (this.originalConnection != null) {
                log.info("originalConnection!=null...,reconnect..");
                User user = this.originalConnection.getUser();
                this.needCloseConnection = this.createNewConnection(this.originalConnection, user);
                this.init(this.needCloseConnection);
            }
        }
        catch (IOException e) {
            log.info("sftpClient close failed.");
        }
    }

    private void init(SshConnection sshConnection) throws ToolException {
        try {
            this.sftpClient = this.createSftpChannel(sshConnection);
            log.info("sftp init success....");
        }
        catch (Exception e) {
            throw new ToolException("create SFTPv3Client error." + sshConnection, false, (Throwable)e);
        }
    }

    public synchronized boolean deleteFile(String fileName) throws ToolException {
        try {
            this.sftpClient.remove(fileName);
        }
        catch (IOException e) {
            log.error("Delete file from remote error.", e);
            throw new ToolException("Delete file from remote error.", false, (Throwable)e);
        }
        return true;
    }

    public synchronized boolean deleteDir(String dirName) throws ToolException {
        try {
            this.sftpClient.rmdir(dirName);
        }
        catch (IOException e) {
            log.error("delete remote directory exception.", e);
            throw new ToolException("delete remote directory exception", false, (Throwable)e);
        }
        return true;
    }

    public synchronized boolean isFileExist(String remotePath, String fileName) {
        Iterable entrys = null;
        try {
            entrys = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(remotePath));
        }
        catch (IOException e) {
            log.error("Can not list file {} in remote path:****", (Object)fileName);
            return false;
        }
        for (SftpClient.DirEntry entry : entrys) {
            if (entry.getAttributes().isDirectory() || entry.getFilename().startsWith(".") || !fileName.equals(entry.getFilename())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isDirExist(String remotePath) {
        try {
            this.sftpClient.lstat(remotePath);
        }
        catch (IOException e) {
            log.error("Can not list directory {} in remote****", (Object)remotePath);
            return false;
        }
        return true;
    }

    public List<String> listFiles(String remotePath) {
        ArrayList<String> fileList = new ArrayList<String>();
        Iterable entrys = null;
        try {
            entrys = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(remotePath));
        }
        catch (IOException e) {
            log.error("Can not list file in remote path:****");
            return fileList;
        }
        for (SftpClient.DirEntry entry : entrys) {
            if (entry.getAttributes().isDirectory() || entry.getFilename().startsWith(".")) continue;
            fileList.add(entry.getFilename());
        }
        return fileList;
    }

    public Map<String, String> listFileDate(String remotePath) {
        Iterable entryList = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            entryList = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(remotePath));
        }
        catch (IOException e) {
            log.error("Can not list file in remote path:****");
            return map;
        }
        for (SftpClient.DirEntry entry : entryList) {
            if (entry.getAttributes().isDirectory() || entry.getFilename().startsWith(".")) continue;
            map.put(entry.getFilename(), new Date(entry.getAttributes().getModifyTime().toMillis()).toString());
        }
        return map;
    }

    public synchronized void getDir(String devPath, File localDir) throws ToolException {
        try {
            Iterable entrys = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(devPath));
            for (SftpClient.DirEntry entry : entrys) {
                if (entry.getAttributes().isDirectory() || entry.getFilename().startsWith(".")) continue;
                File localFile = new File(localDir, entry.getFilename());
                String devFilePath = devPath.endsWith("/") ? devPath + entry.getFilename() : devPath + "/" + entry.getFilename();
                this.getFile(devFilePath, localFile, null);
            }
        }
        catch (Exception e) {
            throw new ToolException("getDir error. ", false, (Throwable)e);
        }
    }

    public synchronized void getDirRecurse(String devPath, File localDir) throws ToolException {
        try {
            Iterable entrys = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(devPath));
            for (SftpClient.DirEntry entry : entrys) {
                if (entry.getAttributes().isDirectory() && !entry.getFilename().startsWith(".")) {
                    String thisDirName = devPath + "/" + entry.getFilename();
                    File thisLocalDir = new File(localDir, entry.getFilename());
                    log.info("mkdir result:{}", (Object)thisLocalDir.mkdirs());
                    this.getDirRecurse(thisDirName, thisLocalDir);
                    continue;
                }
                if (entry.getFilename().startsWith(".")) continue;
                File localFile = new File(localDir, entry.getFilename());
                log.info("mkdir result:{}", (Object)localDir.mkdirs());
                String devFilePath = devPath.endsWith("/") ? devPath + entry.getFilename() : devPath + "/" + entry.getFilename();
                this.getFile(devFilePath, localFile, null);
            }
        }
        catch (Throwable e) {
            throw new ToolException("getDir error. ", false, e);
        }
    }

    public long getRemoteFileSize(String filePath) {
        SftpClient.DirEntry entry = this.getFileAtt(filePath);
        if (null == entry) {
            return -1L;
        }
        SftpClient.Attributes attrs = entry.getAttributes();
        return attrs == null ? -1L : attrs.getSize();
    }

    public SftpClient.DirEntry getFileAtt(String filePath) {
        if (null == this.sftpClient) {
            log.error("sftp channel is null.");
            return null;
        }
        if (StringUtils.isNULLStr(filePath)) {
            log.error("path is null or empty");
            return null;
        }
        File file = new File(filePath);
        String name = file.getName();
        String serverPath = filePath;
        log.info("getting file att, path: {}, name: {}", (Object)filePath, (Object)name);
        try {
            if (!this.sftpClient.lstat(filePath).isDirectory()) {
                serverPath = filePath.replace(name, "");
            }
            Iterable lss = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(serverPath));
            for (SftpClient.DirEntry entry : lss) {
                if (!entry.getFilename().contains(name)) continue;
                return entry;
            }
        }
        catch (Exception e) {
            log.error("get file att error, path: {}, name: {}", filePath, name, e);
        }
        log.error("no LsEntry match the file name.");
        return null;
    }

    public void getFile(String devPath, String localFile, SftpProgressListener progressListener) throws ToolException {
        this.getFile(devPath, new File(localFile), progressListener);
    }

    public synchronized void getFile(String devPath, File localFile, SftpProgressListener progressListener) throws ToolException {
        log.info("Start download file from IP:{} Path : {}", (Object)this.getHost(), (Object)devPath);
        int retryTime = this.getRetryTimes();
        if (retryTime > 0) {
            log.info("download with retry:{}", (Object)retryTime);
            this.getFile(devPath, localFile, progressListener, retryTime);
            return;
        }
        log.info("download with no retry:{}", (Object)retryTime);
        String localFilePath = "";
        try {
            localFilePath = localFile.getCanonicalPath();
        }
        catch (IOException e1) {
            throw new ToolException("get file Canonical Path error!");
        }
        this.checkSize(devPath, localFilePath);
        try {
            SftpTransfer.downloadFile((String)localFilePath, (String)devPath, (SftpClient)this.sftpClient);
        }
        catch (IOException e) {
            log.error("download file error", e);
            throw new ToolException("getFile file error.", false, (Throwable)e);
        }
    }

    private synchronized void checkSize(String remotePath, String localPath) throws ToolException {
        boolean checkResult;
        if (!this.sizeCheckEnable) {
            return;
        }
        long remoteSize = -1L;
        long localSize = -1L;
        try {
            remoteSize = this.getRemoteFileSize(remotePath);
            localSize = SftpTransporter.getLocalFreeSpace(localPath);
        }
        catch (Exception e) {
            log.error("get remote file size or local free space error.", e);
        }
        log.info("get size info: remote file: {}, size: {}, local path: {}, free space: {}, extraSpace: {}", remotePath, remoteSize, localPath, localSize, this.extraSpace);
        boolean checkValue = remoteSize != -1L && localSize != -1L;
        boolean bl = checkResult = remoteSize >= localSize - this.extraSpace;
        if (checkValue && checkResult) {
            throw new ToolException("local free space is not enough, require: " + remoteSize + "(extraSpace: " + this.extraSpace + "), got: " + localSize, false);
        }
    }

    public static long getLocalFreeSpace(String path) {
        if (StringUtils.isNULLStr(path)) {
            log.error("get local free space error, path is null or empty");
            return -1L;
        }
        long size = 0L;
        size = ApplicationContext.getInstance().isWindowsOS() ? new File(path.substring(0, path.indexOf(":") + 1)).getFreeSpace() : SftpTransporter.getSizeOnLinux(path);
        log.info("local free space for path: {}, is: {}", (Object)path, (Object)size);
        return size;
    }

    private static long getSizeOnLinux(String path) {
        File file = new File(path);
        while (!file.exists()) {
            file = file.getParentFile();
        }
        long size = file.getFreeSpace();
        return size;
    }

    private String getHost() {
        return this.originalConnection == null ? "" : this.originalConnection.getHost() + ":" + this.originalConnection.getPort();
    }

    public synchronized void getFile(String devPath, File localFile, SftpProgressListener progressListener, int retryTime) throws ToolException {
        log.info("Start download file from IP with Retry:{} Path : {} retryTimes: {}", this.getHost(), devPath, retryTime);
        if (retryTime <= 0) {
            this.getFile(devPath, localFile, progressListener);
            return;
        }
        int tryTime = 0;
        IOException re = null;
        try {
            this.checkSize(devPath, localFile.getCanonicalPath());
        }
        catch (IOException e1) {
            log.error("getCanonicalPath error", e1);
        }
        while (true) {
            try {
                ++tryTime;
                SftpTransfer.downloadFile((String)localFile.getCanonicalPath(), (String)devPath, (SftpClient)this.sftpClient);
                return;
            }
            catch (IOException e) {
                re = e;
                this.rebuildConnChannel();
                log.error("the tryTime: {} try error", (Object)tryTime, (Object)e);
                this.sleepSomeTime(this.getRetryInterval());
                ++tryTime;
                if (--retryTime >= 0) continue;
                throw new ToolException("getFile file error.", false, (Throwable)re);
            }
            break;
        }
    }

    public synchronized boolean mkdir(String dirName) {
        try {
            this.sftpClient.mkdir(dirName);
            return true;
        }
        catch (IOException e) {
            log.error("Make dir: {} in remote device exception:", (Object)dirName, (Object)e);
            return false;
        }
    }

    public boolean chmod(int permissions, String rmtFileName) {
        try {
            SftpClient.Attributes attributes = this.sftpClient.lstat(rmtFileName);
            attributes.setPermissions(permissions);
            return true;
        }
        catch (IOException e) {
            log.error("Chmod file: {} in remote device exception:", (Object)rmtFileName, (Object)e);
            return false;
        }
    }

    private void sleepSomeTime(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            log.error("error!", e);
        }
    }

    private void rebuildConnChannel() {
        try {
            this.reConnect();
        }
        catch (Exception e1) {
            log.error("error build conn.", e1);
        }
    }

    public void putFullPathFile(File localFile, String devPath, SftpProgressListener progressListener) throws ToolException {
        try {
            log.info("put file to device; local path:{} ,remote path:****", (Object)localFile);
            this.doUpload(localFile, devPath, progressListener);
            log.info("put file to device finished; local path: {} ,remote path:****", (Object)localFile);
        }
        catch (Exception e) {
            throw new ToolException("putFile file error.", false, (Throwable)e);
        }
    }

    public void putFullPathFileOfSignVerfy(File localFile, String devPath, SftpProgressListener progressListener) throws ToolException {
        try {
            if (!SHAAndRSAVerifyUtils.getInstance().verify(localFile)) {
                throw new ToolException("sign exception" + devPath);
            }
            this.putFullPathFile(localFile, devPath, progressListener);
        }
        catch (Exception e) {
            throw new ToolException("putFile file error.", false, (Throwable)e);
        }
    }

    public List<String> findFileNameFromDir(String devDir, String fileNamePragrah) throws ToolException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            Iterable entrys = this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(devDir));
            for (SftpClient.DirEntry entry : entrys) {
                String fileName = entry.getFilename();
                if (entry.getAttributes().isDirectory() || fileName.startsWith(".") || !fileName.contains(fileNamePragrah)) continue;
                String filePath = devDir.endsWith("/") ? devDir + fileName : devDir + "/" + fileName;
                fileNames.add(filePath);
            }
        }
        catch (Exception e) {
            throw new ToolException("findFileNameFromDir error. ", false, (Throwable)e);
        }
        return fileNames;
    }

    public void putFile(File localFile, String devPath, SftpProgressListener progressListener) throws ToolException {
        log.info("Start upload file from IP {} Path : {}", (Object)this.getHost(), (Object)devPath);
        try {
            log.info("put file to device; local path:{} ,remote path:*****", (Object)localFile);
            devPath = localFile.getName().endsWith("bat") ? devPath + localFile.getName() : devPath + "/" + localFile.getName();
            int retryTime = this.getRetryTimes();
            if (retryTime <= 0) {
                log.info("upload with no retry:{}", (Object)retryTime);
                this.uploadWithPermHandleCallBack(devPath, localFile, this.sftpClient);
                return;
            }
            this.doUpload(localFile, devPath, progressListener, retryTime);
            log.info("put file to device finished; local path:{} ,remote path:****", (Object)localFile);
        }
        catch (Exception e) {
            log.error("update file error", e);
            throw new ToolException("putFile file error.", false, (Throwable)e);
        }
    }

    private void doUpload(File localFile, String devPath, SftpProgressListener progressListener, int retryTime) throws IOException {
        while (retryTime >= 0) {
            this.uploadWithPermHandleCallBack(devPath, localFile, this.sftpClient);
            this.sleepSomeTime(this.getRetryInterval());
            --retryTime;
        }
    }

    private void doUpload(File localFile, String devPath, SftpProgressListener progressListener) throws IOException {
        this.uploadWithPermHandleCallBack(devPath, localFile, this.sftpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadWithPermHandleCallBack(String devFilePath, File localFile, SftpClient sftpClient) {
        try {
            String[] fileUpdInfo = SftpUtils.getUploadAuthPath(this.originalConnection, devFilePath);
            boolean needRetry = fileUpdInfo.length == 2;
            log.error("upload to sftp needRetry: {} ", (Object)needRetry);
            if (!needRetry) {
                SftpTransfer.uploadFile((String)devFilePath, (String)localFile.getCanonicalPath(), (SftpClient)sftpClient);
                return;
            }
            String[] serverPathRight = SftpUtils.getFilePermDetail(fileUpdInfo[1]);
            int tryTimes = 0;
            int originRight = SftpUtils.convertRightToInt(serverPathRight);
            log.error("upload to sftp needRetry originRight:{}", (Object)originRight);
            try {
                boolean isScuccess = false;
                while (tryTimes < 3) {
                    String[] serverPathInfoClone = (String[])serverPathRight.clone();
                    log.error("upload to sftp needRetry serverPathInfoClone.");
                    try {
                        log.error("upload to sftp needRetry tryTimes:{}", (Object)(++tryTimes));
                        SftpTransfer.uploadFile((String)devFilePath, (String)localFile.getCanonicalPath(), (SftpClient)sftpClient);
                        log.error("upload to sftp needRetry tryTimes end");
                        isScuccess = true;
                        break;
                    }
                    catch (Exception e) {
                        log.error("upload to sftp error.", e);
                        serverPathInfoClone[3 - tryTimes] = "111";
                        int rightToChmod = SftpUtils.convertRightToInt(serverPathInfoClone);
                        if (rightToChmod == -1) continue;
                        this.originalConnection.execCmd("chmod " + rightToChmod + " " + fileUpdInfo[0]);
                    }
                }
                if (!isScuccess) {
                    throw new EncapsulatedRuntimeException("exec upload file error");
                }
            }
            finally {
                log.error("upload to sftp recover right start.");
                if (originRight != -1) {
                    log.error("upload to sftp recover right execute.");
                    this.originalConnection.execCmd("chmod " + originRight + " " + fileUpdInfo[0]);
                    log.error("upload to sftp recover right execute success.");
                }
                log.error("upload to sftp recover right end.");
            }
        }
        catch (Exception e) {
            log.error("exception while uploading with perm handle callback from local file {}", (Object)localFile, (Object)e);
            throw new EncapsulatedRuntimeException("put stream error.");
        }
    }

    public void putStream(InputStream inputStream, String devFilePath, SftpProgressListener progressListener) throws IOException {
        long totalSize = inputStream.available();
        ProgressMonitorAdaptor monitor = new ProgressMonitorAdaptor(progressListener, true);
        monitor.setMax(totalSize);
        SftpPermWrapper wrapper = new SftpPermWrapper(this.originalConnection, (SftpProgressMonitor)monitor, this.sftpClient, inputStream);
        wrapper.uploadWithPermHandle(devFilePath);
    }

    public void close() {
        if (null != this.sftpClient) {
            try {
                this.sftpClient.close();
                this.sftpClient = null;
            }
            catch (Exception e) {
                log.error("close sftp client error", e);
            }
        }
        if (null != this.needCloseConnection) {
            try {
                this.needCloseConnection.close();
                this.needCloseConnection = null;
            }
            catch (Exception e) {
                log.error("close new created temp connection error", e);
            }
        }
    }

    public synchronized boolean isSizeCheckEnable() {
        return this.sizeCheckEnable;
    }

    public synchronized void enableSizeCheck() {
        this.sizeCheckEnable = true;
    }

    public synchronized void disableSizeCheck() {
        this.sizeCheckEnable = false;
    }

    public synchronized long getExtraSpace() {
        return this.extraSpace;
    }

    public synchronized void setExtraSpace(long extraSpace) {
        this.extraSpace = extraSpace < 0L ? -extraSpace : extraSpace;
    }

    private static class ProgressMonitorAdaptor
    implements SftpProgressMonitor {
        private SftpProgressListener sftpListener;
        private long countPro = 0L;
        private long max = 0L;
        private boolean inputStreamMode = false;
        private long percent = 0L;

        public ProgressMonitorAdaptor(SftpProgressListener sftpListener, boolean inputStreamMode) {
            this.sftpListener = sftpListener;
            this.inputStreamMode = inputStreamMode;
        }

        @Override
        public void init(int op, String src, String dest, long initMax) {
            if (!this.inputStreamMode) {
                this.max = initMax;
            }
            this.countPro = 0L;
            this.percent = 0L;
        }

        @Override
        public boolean count(long countProgress) {
            this.countPro += countProgress;
            if (this.percent >= this.countPro * 100L / this.max) {
                return true;
            }
            this.percent = this.countPro * 100L / this.max;
            if (null != this.sftpListener) {
                this.sftpListener.progressUpdate((int)this.percent);
            }
            return true;
        }

        @Override
        public void end() {
        }

        public void setMax(long max) {
            this.max = max;
        }
    }
}

