/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.win;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.executor.CmdExecutor;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.ToolUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaexecConnection {
    private static String defaultPath = "C:";
    private static final String CD = "cd ";
    private static final String ENPTY = "";
    public static final String CONNECT_TEST_COMMAND = "echo TRY_TOCONN_PA_AA";
    public static final String GRAB_FILE_PREFIX = "grabCopyScript";
    private static final String REMOTE_PATH_PLACEHOLDER = "${remotePath}";
    private static final int WMIC_PORT = 445;
    private static final int TIME_OUT = 60;
    private static final String MINOTOR_CMD_PREFIX = "wmic ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PaexecConnection.class);
    private static final Map<String, String> LOCAL_EXEC_DIR = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> REMOTE_EXEC_IN_DIR = new ConcurrentHashMap<String, String>();
    private static final String OUTPUT_TO_FILE = " 2>&1";
    private static final char GRAB_FILE_SEPRATOR = '!';
    private static final String COLLECT_RESULT_FILE = "collect.result";
    private static final String DEFAULT_RIVERPATH = "C:";
    private static final String PD_PLACEHOLDER = "${pd}";
    private static final String USER_NAME_PLACEHOLDER = "${userName}";
    private static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED\r\nunknown";
    private static final String CONN_EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED\r\nconnot connect";
    private static final String LINE_SEPARATOR;
    private static final String[] SHARE_PATHS;
    private static final String NET_USE_CMD_TEMP = "net use ${remotePath} \"${pd}\" /user:${userName}";
    private static final int DEFAULT_TMOUT_VAL = -1;
    private static final int DEFAULT_TIMEOUT = -1;
    private String ip;
    private String userName;
    private String passWord;
    private boolean isSimulator;
    private Future<Boolean> connectResult;
    private String remoteCmdResultPath;
    private boolean connected = false;
    private boolean isLocalHost = false;
    private WmicConnection mappedWwmicConn;

    public static void calcUtrlPathLoc() {
        ArrayList<String> upadmPath = new ArrayList<String>();
        upadmPath.add("C:\\Program Files (x86)\\UltraPath\\bin");
        upadmPath.add("C:\\Program Files\\UltraPath\\bin");
        upadmPath.add("C:\\Program Files\\Huawei\\OceanStor UltraPath\\bin");
        upadmPath.add("C:\\Program Files (x86)\\Huawei\\OceanStor UltraPath\\bin");
        for (String path : upadmPath) {
            if (!new File(path).exists()) continue;
            LOCAL_EXEC_DIR.put("upadm", path);
            LOCAL_EXEC_DIR.put("upadmin", path);
        }
        LOCAL_EXEC_DIR.put("hbacmd", "C:\\Program Files\\Emulex\\Util\\OCManager");
        REMOTE_EXEC_IN_DIR.put("hbacmd", "C:\\Program Files\\Emulex\\Util\\OCManager");
    }

    public synchronized String getRemoteCmdResultPath() {
        return this.remoteCmdResultPath;
    }

    public PaexecConnection(String ip, User loginUser, WmicConnection wmicConnection) {
        try {
            this.mappedWwmicConn = wmicConnection;
            this.initConn(ip, loginUser);
        }
        catch (Exception e) {
            LOGGER.error("conn to server error.", e);
        }
    }

    public WmicConnection getMappedWwmicConn() {
        return this.mappedWwmicConn;
    }

    public synchronized String getIp() {
        return this.ip;
    }

    public void setMappedWwmicConn(WmicConnection mappedWwmicConn) {
        this.mappedWwmicConn = mappedWwmicConn;
    }

    private synchronized void initConn(String ipStr, User loginUser) throws ToolException {
        LOGGER.info("init PaexecConnection");
        this.ip = ipStr;
        this.userName = loginUser.getUserName();
        this.setPassword(loginUser.getPassword());
        this.asyncConnect();
    }

    public synchronized Future<Boolean> getConnectResult() {
        return this.connectResult;
    }

    private synchronized void setRemotePath() throws ToolException {
        String ipStr = this.getIp();
        this.checkIsHostCanConnect();
        for (String path : SHARE_PATHS) {
            int validLineNum;
            String shareMgrPath = "\\\\" + ipStr + File.separator + path + '$';
            if (new File(shareMgrPath).exists() && ToolUtils.isPathWriteAble(shareMgrPath)) {
                this.remoteCmdResultPath = shareMgrPath;
                this.getMappedWwmicConn().setIsCanRemoteExecCmd(true);
                return;
            }
            LOGGER.info("start to net use map:{}", (Object)shareMgrPath);
            if (new File(shareMgrPath).exists() || (validLineNum = this.mappRemotePath(shareMgrPath)) != 1) continue;
            WmicConnectionManager.getNeedToReleasePath().add("net use " + shareMgrPath + " /del");
            if (!ToolUtils.isPathWriteAble(shareMgrPath)) continue;
            this.remoteCmdResultPath = shareMgrPath;
            this.getMappedWwmicConn().setIsCanRemoteExecCmd(true);
            return;
        }
        LOGGER.error("remote host no paths to share:{}", (Object)this.getIp());
        throw new ToolException("remote host no path to share");
    }

    private void checkIsHostCanConnect() throws ToolException {
        boolean hostCanConn = NetUtil.isHostCanConnect(this.getIp(), 445, 5);
        if (!hostCanConn) {
            LOGGER.error("remote host cannot be connected");
            throw new ToolException("remote host cannot reach");
        }
    }

    private int mappRemotePath(String shareMgrPath) {
        String[] lines;
        String netUseCmd = NET_USE_CMD_TEMP.replace(REMOTE_PATH_PLACEHOLDER, shareMgrPath);
        int validLineNum = 0;
        netUseCmd = netUseCmd.replace(USER_NAME_PLACEHOLDER, this.getUserName());
        netUseCmd = netUseCmd.replace(PD_PLACEHOLDER, this.getPassword());
        String usePath = OSCmdUtils.executeCmd(netUseCmd, 32);
        LOGGER.info("net use map result:{}", (Object)usePath);
        for (String line : lines = usePath.split(System.lineSeparator())) {
            if (StringUtils.isEmpty((CharSequence)line)) continue;
            ++validLineNum;
        }
        return validLineNum;
    }

    public synchronized Future<Boolean> asyncConnect() {
        ConnectTryTask connTask = new ConnectTryTask(this);
        this.connectResult = ThreadPoolManager.getInstance().submit((Callable)connTask);
        return this.connectResult;
    }

    public synchronized boolean connect(int timeout) {
        LOGGER.info("***[paexec process start]***");
        try {
            if (this.connected) {
                return this.connected;
            }
            String connectResultLocal = this.sendCmdAndGetResult(CONNECT_TEST_COMMAND);
            LOGGER.info("login result:{}", (Object)connectResultLocal);
            if (connectResultLocal.contains(EXE_FAILED)) {
                LOGGER.warn(this.ip + " connect to server by paexec error login result:" + this.connectResult);
                return false;
            }
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            LOGGER.error("***[start paexec fail]***", e);
        }
        return this.connected;
    }

    private synchronized boolean checkIslocalHost() {
        String result = CmdExecutor.executeCmd((String)"ipconfig", (int)32);
        this.setLocalHost(result.contains(this.getIp()));
        LOGGER.info("Grab Local Host :{}", (Object)this.isGrabLocalHost());
        this.setConnected(this.isGrabLocalHost());
        return this.isGrabLocalHost();
    }

    public boolean isGrabLocalHost() {
        return this.isLocalHost;
    }

    public void setLocalHost(boolean isLocalHostParam) {
        this.isLocalHost = isLocalHostParam;
    }

    private String findSystemDriverPath() {
        String driverPath = DEFAULT_RIVERPATH;
        String[] systemPath = new String[]{":/Windows/System32", ":/Users"};
        char startVlum = 'C';
        int i = 0;
        while (true) {
            boolean isFind = true;
            for (String path : systemPath) {
                char newVlume = (char)(startVlum + i);
                boolean bl = isFind = isFind && new File(newVlume + path).exists();
                if (!isFind) break;
            }
            if (isFind) break;
            ++i;
        }
        startVlum = (char)(startVlum + i);
        driverPath = String.valueOf(startVlum) + ':';
        return driverPath;
    }

    public synchronized boolean isConnectionAvailable() {
        return true;
    }

    public synchronized String sendCmdAndGetResult(String command) {
        LOGGER.info("***[start sendCmdAndGetResult]***");
        return this.sendCmdAndGetResult(command, -1);
    }

    public synchronized String sendCmdAndGetResult(String command, int timeout, boolean localWmic) {
        LOGGER.info("***[start sendCmdAndGetResult with timout{}]***", (Object)timeout);
        int n = timeout = timeout == -1 ? 50 : timeout;
        if (this.getMappedWwmicConn().getIsCanRemoteExecCmd().booleanValue()) {
            return this.getMappedWwmicConn().execCmdRemoteTimout(command, timeout);
        }
        if (!CONNECT_TEST_COMMAND.equals(command) && !this.connected) {
            LOGGER.error("PA connot connect to remote server:{}", (Object)this.ip);
            return "~>" + command + LINE_SEPARATOR + CONN_EXE_FAILED;
        }
        String result = null;
        try {
            long startTime = System.currentTimeMillis();
            if (this.isSimulator) {
                command = command.substring(command.indexOf(38) + 1);
                result = CmdExecutor.executeCmd((String)command, (int)60);
                return "~>" + command + LINE_SEPARATOR + result;
            }
            String commandFile = this.sendCommand(command, localWmic);
            long usedTime = System.currentTimeMillis() - startTime;
            int waitTime = (int)((long)timeout - usedTime / 1000L);
            result = this.readCmdResult(waitTime, command, commandFile);
            return "~>" + command + LINE_SEPARATOR + result;
        }
        catch (Exception e) {
            LOGGER.error("***[execute command error.]***", e);
            return "~>" + command + LINE_SEPARATOR + EXE_FAILED;
        }
    }

    public synchronized String sendCmdAndGetResult(String command, int timeout) {
        return this.sendCmdAndGetResult(command, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendCommand(String command, boolean localWmic) throws ToolException {
        String exeCmd = null;
        String[] files = null;
        try {
            LOGGER.info("command ={}", (Object)command);
            exeCmd = this.makePaexecCmd(command);
            if (exeCmd == null) {
                throw new ToolException("exec cmd error.");
            }
            files = exeCmd.split(String.valueOf('!'));
            if (localWmic) {
                files[0] = "wmic process call create \"cmd /c " + files[0] + "\"";
            }
            this.executeCmdNew(files[0]);
            String string = files[1];
            return string;
        }
        finally {
            if (null != files && !this.isGrabLocalHost()) {
                for (String file : files) {
                    ToolUtils.deleteFile(file);
                }
            }
        }
    }

    public synchronized void closeConnection() {
        this.connectResult = null;
        LOGGER.info("no resource need to release");
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    public synchronized String sendPowerShellCmd(String command) {
        LOGGER.info("***[execute power shell command]***");
        return this.sendCmdAndGetResult(command, -1);
    }

    public synchronized String sendPowerShellCmd(String command, int timeout) {
        LOGGER.info("***[execute power shell command]***");
        return this.sendCmdAndGetResult(command, timeout);
    }

    private void executeCmdNew(String cmd) {
        try {
            String[] cmdHead;
            cmd = this.buildSimulatorCmd(cmd);
            String[] stringArray = cmdHead = this.isGrabLocalHost() ? cmd.split(" ") : null;
            if (cmdHead != null && cmdHead[0].contains(">")) {
                cmdHead[0] = cmdHead[0].substring(0, cmdHead[0].indexOf(">"));
            }
            String execCmdPath = LOCAL_EXEC_DIR.get(cmdHead == null ? ENPTY : cmdHead[0]);
            String cmdNew = "cmd.exe /c " + cmd;
            String echos = ENPTY;
            echos = execCmdPath == null ? OSCmdUtils.executeCmd(cmdNew) : OSCmdUtils.executeCmdInPath(cmdNew, execCmdPath);
            LOGGER.info("executing command {}:{}", (Object)cmdNew, (Object)echos);
        }
        catch (Exception e1) {
            LOGGER.error("Clear cmd output stream error :", e1);
        }
    }

    private String buildSimulatorCmd(String cmd) {
        String result = this.readLinesFromFile(cmd, null);
        String[] lines = result.split(System.lineSeparator());
        if (lines.length > 1 && lines[1] != null) {
            cmd = MINOTOR_CMD_PREFIX + lines[1];
            cmd = StringUtils.stripEnd((String)cmd, (String)"2 ^>&1");
        }
        return cmd;
    }

    private String makePaexecCmd(String command) {
        int index;
        if (this.isNotNeedSetWidth(command) && (index = command.indexOf(38)) > 0) {
            command = command.substring(index + 1);
        }
        String commandNew = command;
        if (!this.isLocalHost) {
            commandNew = this.reBuildcmd(command);
        }
        String localResultPath = this.getLocalResultPath();
        return commandNew + ">" + localResultPath + OUTPUT_TO_FILE + '!' + localResultPath;
    }

    public String reBuildcmd(String command) {
        for (Map.Entry<String, String> entry : REMOTE_EXEC_IN_DIR.entrySet()) {
            if (!command.contains(entry.getKey())) continue;
            int index = command.indexOf(38);
            if (index > 0) {
                command = command.substring(index + 1);
            }
            command = CD + entry.getValue() + System.lineSeparator() + command;
            LOGGER.info("command new :{}", (Object)command);
            break;
        }
        return command;
    }

    public boolean isNotNeedSetWidth(String command) {
        for (Map.Entry<String, String> entry : REMOTE_EXEC_IN_DIR.entrySet()) {
            if (!command.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public String getLocalResultPath() {
        String fileAbsolutePath;
        try {
            if (this.isGrabLocalHost()) {
                return defaultPath + File.separator + COLLECT_RESULT_FILE;
            }
            fileAbsolutePath = new File(ApplicationContext.getInstance().getTmpPath()).getCanonicalPath();
        }
        catch (IOException e) {
            fileAbsolutePath = ENPTY;
        }
        String localResultPath = fileAbsolutePath + File.separator + COLLECT_RESULT_FILE;
        return localResultPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLinesFromFile(String fileName, String charSet) {
        File file = new File(fileName);
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        if (null == charSet) {
            charSet = "UTF-8";
        }
        try {
            if (file.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charSet));
                String readLine = null;
                while ((readLine = reader.readLine()) != null) {
                    if (StringUtils.isEmpty((CharSequence)readLine.trim())) continue;
                    result.append(readLine).append(LINE_SEPARATOR);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Read powershell result from file error...", e);
            String string = ENPTY;
            return string;
        }
        finally {
            StreamUtils.closeResource(null, reader);
        }
        return result.toString().trim();
    }

    private String readCmdResult(int timeout, String originCmd, String commandFile) throws ToolException {
        if (StringUtils.isEmpty((CharSequence)originCmd)) {
            return ENPTY;
        }
        String result = null;
        int sleepTime = 800;
        boolean isTimeoutFlag = true;
        String charSet = null;
        String remotePath = this.isLocalHost ? defaultPath : this.remoteCmdResultPath;
        String remoteFile = FilePathUtils.checkFile((String)(remotePath + File.separator + COLLECT_RESULT_FILE));
        try {
            if (!new File(remotePath).isDirectory()) {
                throw new ToolException("remote file cannot be located:" + commandFile);
            }
            for (int retryCount = timeout; retryCount > 0; --retryCount) {
                if (new File(remoteFile).exists() && ToolUtils.isFileCanOperate(remoteFile)) {
                    charSet = CommonEncodeDetectUtils.endcodeDetect(remoteFile);
                    LOGGER.info("charset for command:{}.at device:{}", (Object)originCmd, (Object)this.ip);
                    result = this.readLinesFromFile(remoteFile, charSet);
                    LOGGER.info("cmd read end:{}", (Object)result);
                    result = ToolUtils.handleCmdResult(result, originCmd, this.getMappedWwmicConn().getEchoValueMap());
                    isTimeoutFlag = false;
                    break;
                }
                ConnUtils.sleep(sleepTime);
            }
        }
        catch (Exception e) {
            LOGGER.error("read file error", e);
            throw new ToolException("read the file error:" + commandFile, e);
        }
        finally {
            ToolUtils.deleteFile(remoteFile);
        }
        if (isTimeoutFlag) {
            throw new ToolException("read result from file timout.:" + commandFile);
        }
        return result;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.passWord);
    }

    public void setPassword(String passwordStr) {
        this.passWord = AESEncrypt.encrypt((String)passwordStr);
    }

    public synchronized void setIsSimulator(Boolean isSimulator) {
        this.isSimulator = isSimulator;
        LOGGER.info("is simulator: {}", (Object)this.isSimulator);
    }

    static {
        PaexecConnection.calcUtrlPathLoc();
        String userDir = ApplicationContext.getInstance().getWorkPath();
        int index = userDir.indexOf(":");
        if (-1 != index) {
            defaultPath = userDir.substring(0, index) + ":";
            LOGGER.info("default path={}", (Object)defaultPath);
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
        SHARE_PATHS = new String[]{"ADMIN", "IPC", "C"};
    }

    private static final class ConnectTryTask
    implements Callable<Boolean> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ConnectTryTask.class);
        private PaexecConnection conn;

        public ConnectTryTask(PaexecConnection conn) {
            this.conn = conn;
        }

        @Override
        public Boolean call() {
            this.conn.checkIslocalHost();
            if (this.conn.isGrabLocalHost()) {
                return true;
            }
            try {
                this.conn.setRemotePath();
            }
            catch (ToolException e) {
                LOGGER.error("exec error", e);
                this.conn.setConnected(false);
                return false;
            }
            catch (Exception e) {
                LOGGER.error("exec error", e);
                this.conn.setConnected(false);
                return false;
            }
            String remoteShrePath = this.conn.getRemoteCmdResultPath();
            if (StringUtils.isEmpty((CharSequence)remoteShrePath)) {
                return false;
            }
            return true;
        }
    }
}

