/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.win;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.executor.CmdExecutor;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.connection.AbstractGrabConn;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.PaexecConnection;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ToolUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class WmicConnection
extends AbstractGrabConn {
    private static final String PATH_NOT_FIND = "The system cannot find the path specified.";
    private static final String WMIC_REMOTE_SCRIPT_CMD = "wRemoteScript.cmd";
    private static final String TEST_SUPPORT_WMIC = "testSupportWmic!";
    private static final String TEST_SUPPORT_WMIC_CMD = "wmic testSupportWmic!";
    private static final String GRAB_WM_EXEC_RESULT = "grabWmExec.result";
    private static final String REMOTE_SUCCESS = "ReturnValue = 0";
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED\r\nunknown";
    public static final String EXE_TIMEOUT = "TOOLKIT_EXE_CMD_FAILED\r\nexec time out.";
    private static final String QUERY_LOCAL_IP_CMD = "wmic NICCONFIG get ipaddress";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(WmicConnection.class);
    private static final String CMD_INFO = "${cmdInfo}";
    private static final String RESULT_PATH = "${resultPath}";
    private static final int NOT_TESTED = -1;
    private static final int SUPPORTED = 1;
    private static final int NOT_SUPPORTED = 0;
    private static final String WMIC_CMD_EXEC_TEMPLATE = "wmic process call create \"cmd /c ${cmdInfo}\"";
    private static final String WMIC_CMD_APPEND_TEMPLATE = ">${resultPath} 2>&1";
    private static final String WMIC = "wmic";
    private static final String INTERACTIVE_OFF = "/INTERACTIVE:OFF ";
    private static final String REDIRECT_CMD = ">>";
    private static final String REDIRECT_WMIC = "/OUTPUT:";
    private int isLocalHostSupportWmic = -1;
    private String username;
    private String password;
    private String ip = "";
    private String wmicCmdHead = "wmic";
    private Boolean isSimulator = false;
    private Boolean isCanRemoteExecCmd = false;
    private Boolean isLocalHost = false;
    private Map<String, String> echoValueMap = new HashMap<String, String>();
    private PaexecConnection paexecConnection = null;
    private Future<String> osInfoFuture;

    public WmicConnection(String ip, User loginUser) throws ToolException {
        this.ip = ip;
        this.username = loginUser.getUserName();
        QueryOsTask infoQryTask = new QueryOsTask();
        this.osInfoFuture = AsyncExcutor.submit((Callable)infoQryTask);
        this.setEncryptPassword(loginUser.getEcptPassword());
        this.paexecConnection = new PaexecConnection(this.ip, loginUser, this);
        this.wmicCmdHead = this.createCmdHead();
        this.testifLocalSupportWmic();
    }

    public boolean isLocalSupportWmic() {
        return this.isLocalHostSupportWmic == 1;
    }

    private void testifLocalSupportWmic() {
        if (this.isLocalHostSupportWmic == -1) {
            String testResult = this.execWmicCmd(TEST_SUPPORT_WMIC_CMD, 30);
            this.isLocalHostSupportWmic = this.checkIsWmicEnabled(testResult) ? 1 : 0;
        }
    }

    private boolean checkIsWmicEnabled(String resultStr) {
        String header = "~>wmic testSupportWmic!";
        return (resultStr = resultStr.replace(header, "").trim()).contains(TEST_SUPPORT_WMIC);
    }

    public Map<String, String> getEchoValueMap() {
        return this.echoValueMap;
    }

    public Boolean getIsLocalHost() {
        return this.isLocalHost;
    }

    public void setIsLocalHost(Boolean isLocalHost) {
        this.isLocalHost = isLocalHost;
    }

    public Boolean getIsCanRemoteExecCmd() {
        return this.isCanRemoteExecCmd != false && this.isLocalHost == false;
    }

    public Boolean isCanRemoteExecCmd() {
        return this.isCanRemoteExecCmd;
    }

    public void setIsCanRemoteExecCmd(Boolean isCanRemoteExecCmd) {
        this.isCanRemoteExecCmd = isCanRemoteExecCmd;
    }

    private String createCmdHead() throws ToolException {
        try {
            if (this.osInfoFuture.get().matches("[\\s\\S]*Windows.*Server.*2003[\\s\\S]*")) {
                throw new ToolException("cbb.devicemager.add.windows.error.runin.2003");
            }
        }
        catch (ToolException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("eroror to check system info{}", e);
        }
        String ipLines = this.execWmicCmd(QUERY_LOCAL_IP_CMD, -1);
        LOGGER.info("create CmdHead ipLines = {}", (Object)ipLines);
        if (ipLines.contains(this.ip)) {
            this.isLocalHost = true;
            return WMIC;
        }
        return this.buildWmicHead();
    }

    private String buildWmicHead() {
        StringBuilder ret = new StringBuilder().append("wmic /node:").append(this.ip).append(" /user:").append(this.username).append(" /password:");
        if (this.getPassword().contains("\"")) {
            ret.append('\'').append(this.getPassword()).append('\'');
        } else {
            ret.append('\"').append(this.getPassword()).append('\"');
        }
        return ret.toString();
    }

    public String commandWithFilePath(String wmicCommand, String filePath) {
        String executeCmd = this.executeCmd("wmic is simulator", 30, "");
        if (executeCmd.contains("yes")) {
            this.paexecConnection.setIsSimulator(true);
            this.isSimulator = true;
            ApplicationContext.getInstance().setSimulatorFlag(true);
        }
        wmicCommand = "chcp 65001&" + wmicCommand + ToolUtils.getSpecialSymbols(this.isSimulator) + filePath;
        return wmicCommand;
    }

    private String execWmicCmd(String wmicCommand, int timeout) {
        String filePath = this.getFile();
        if (this.needSpecialHandle(wmicCommand)) {
            wmicCommand = this.commandWithFilePath(wmicCommand, filePath);
        }
        String result = this.executeCmd(wmicCommand, timeout, filePath);
        if (this.needSpecialHandle(wmicCommand) && result.contains(PATH_NOT_FIND)) {
            result = this.executeCmd(wmicCommand, timeout, filePath, true);
        }
        ToolUtils.deleteFile(filePath);
        return result;
    }

    private String executeCmd(String wmicCommand, int timeout, String filePath) {
        return this.executeCmd(wmicCommand, timeout, filePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCmd(String wmicCommand, int timeout, String filePath, boolean noHandleSpecCmd) {
        int retryCount = 30;
        if (timeout > 0) {
            retryCount = timeout;
        }
        Process wmicProcess = null;
        InputStreamReader wmicInputStreamReader = null;
        BufferedReader wmicReader = null;
        try {
            wmicProcess = wmicCommand.contains(WMIC) ? this.executeWmicCommand(wmicCommand) : this.executeOtherCommand(wmicCommand);
            wmicInputStreamReader = new InputStreamReader(wmicProcess.getInputStream(), "UTF-8");
            wmicReader = new BufferedReader(wmicInputStreamReader);
            StringBuffer resultBuffer = this.getCommandResult(wmicCommand, filePath, noHandleSpecCmd, retryCount, wmicReader);
            this.checkResult(wmicCommand, resultBuffer);
            LOGGER.info("cmd:{}  result:~>{},{}", wmicCommand, ToolConstants.ENTER, resultBuffer.toString());
            String string = "~>" + wmicCommand + ToolConstants.ENTER + resultBuffer.toString();
            this.doWmicClose(wmicProcess, wmicInputStreamReader, wmicReader);
            return string;
        }
        catch (ToolException e) {
            LOGGER.error("***[wimic execute command timeout]***", e);
            String string = "~>" + wmicCommand + ToolConstants.ENTER + EXE_FAILED;
            this.doWmicClose(wmicProcess, wmicInputStreamReader, wmicReader);
            return string;
        }
        catch (Exception e2) {
            LOGGER.error("something wrong.", e2);
            this.echoValueMap.put(wmicCommand, "unknown");
            String string = wmicCommand + ToolConstants.ENTER + EXE_FAILED;
            this.doWmicClose(wmicProcess, wmicInputStreamReader, wmicReader);
            return string;
            {
                catch (Throwable throwable) {
                    this.doWmicClose(wmicProcess, wmicInputStreamReader, wmicReader);
                    throw throwable;
                }
            }
        }
    }

    private Process executeWmicCommand(String wmicCommand) throws IOException {
        if (wmicCommand.lastIndexOf(WMIC) != wmicCommand.indexOf(WMIC)) {
            LOGGER.error("WMIC command error, command is " + wmicCommand);
        }
        String wmicCommandTemp = wmicCommand.replace(WMIC, this.wmicCmdHead);
        String wmicCommandHead = wmicCommandTemp.substring(0, wmicCommandTemp.indexOf(WMIC) + WMIC.length());
        String wmicCommandBody = this.getWmicCommandBody(wmicCommandTemp, wmicCommand);
        Process wmicProcess = this.processStart(wmicCommandHead);
        OutputStreamWriter ow = new OutputStreamWriter(wmicProcess.getOutputStream());
        ow.write(wmicCommandBody);
        ow.flush();
        ow.close();
        return wmicProcess;
    }

    private Process executeOtherCommand(String wmicCommand) throws IOException {
        Process wmicProcess = this.processStart(wmicCommand);
        return wmicProcess;
    }

    private Process processStart(String wmicCommand) throws IOException {
        String[] cmds = new String[]{"cmd.exe", "/C", wmicCommand};
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb = pb.redirectErrorStream(true);
        return pb.start();
    }

    private String getWmicCommandBody(String wmicCommandTemp, String wmicCommand) {
        String wmicCommandBody = INTERACTIVE_OFF + wmicCommandTemp.substring(wmicCommandTemp.indexOf(WMIC) + WMIC.length());
        if (wmicCommandBody.contains(REDIRECT_CMD)) {
            if (wmicCommandBody.lastIndexOf(REDIRECT_CMD) != wmicCommandBody.indexOf(REDIRECT_CMD)) {
                LOGGER.error("WMIC command error, command is " + wmicCommand);
            }
            String redirectPath = wmicCommandBody.substring(wmicCommandBody.lastIndexOf(REDIRECT_CMD) + REDIRECT_CMD.length());
            wmicCommandBody = REDIRECT_WMIC + redirectPath + " " + wmicCommandBody.substring(0, wmicCommandBody.indexOf(REDIRECT_CMD));
        }
        return wmicCommandBody;
    }

    private StringBuffer getCommandResult(String wmicCommand, String filePath, boolean noHandleSpecCmd, int retryCount, BufferedReader wmicReader) throws IOException {
        StringBuffer resultBuffer = new StringBuffer();
        int sleepTime = 1000;
        while (retryCount > 0) {
            this.appendResult(resultBuffer, wmicReader);
            if (!noHandleSpecCmd && this.needSpecialHandle(wmicCommand)) {
                String specialResult = this.readFileByLines(filePath);
                specialResult = specialResult.replace("null", "");
                resultBuffer.append(specialResult);
            }
            if (!resultBuffer.toString().isEmpty()) break;
            ConnUtils.sleep(sleepTime);
            --retryCount;
        }
        return resultBuffer;
    }

    private void appendResult(StringBuffer resultBuffer, BufferedReader wmicReader) throws IOException {
        String line;
        while ((line = wmicReader.readLine()) != null) {
            if ("".equals(line.trim())) continue;
            resultBuffer.append(line + ToolConstants.ENTER);
        }
    }

    private void checkResult(String wmicCommand, StringBuffer resultBuffer) throws ToolException {
        if (resultBuffer.toString().isEmpty()) {
            this.echoValueMap.put(wmicCommand, "unknown");
            throw new ToolException("***[wimic execute command timeout]***");
        }
    }

    private String getFile() {
        String tmpPath = ApplicationContext.getInstance().getTmpPath();
        String filePath = tmpPath + File.separator + "osName" + System.currentTimeMillis();
        return filePath;
    }

    private boolean needSpecialHandle(String wmicCommand) {
        return wmicCommand.toLowerCase(Locale.getDefault()).contains("os get name") || wmicCommand.toLowerCase(Locale.getDefault()).contains("os get caption /value");
    }

    private BufferedReader structureReader(File file, String code) throws UnsupportedEncodingException, FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), code));
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileByLines(String fileName) {
        StringBuffer result;
        BufferedReader reader;
        block6: {
            File file = new File(fileName);
            reader = null;
            result = new StringBuffer();
            try {
                reader = this.structureReader(file, this.isSimulator != false ? "UTF-8" : "Unicode");
                String tempString = null;
                while ((tempString = reader.readLine()) != null) {
                    result.append(tempString);
                }
                if (null == file) break block6;
                LOGGER.info("file delete result:{}", (Object)file.delete());
            }
            catch (IOException e) {
                block7: {
                    try {
                        LOGGER.error("Read wmic result from file error...", e);
                        if (null == file) break block7;
                        LOGGER.info("file delete result:{}", (Object)file.delete());
                    }
                    catch (Throwable throwable) {
                        if (null != file) {
                            LOGGER.info("file delete result:{}", (Object)file.delete());
                        }
                        WmicConnection.closeStrem(reader);
                        throw throwable;
                    }
                }
                WmicConnection.closeStrem(reader);
            }
        }
        WmicConnection.closeStrem(reader);
        return result.toString();
    }

    private static void closeStrem(BufferedReader reader) {
        StreamUtils.closeResource(null, (Closeable)reader);
    }

    private void doWmicClose(Process wmicProcess, InputStreamReader wmicInputStreamReader, BufferedReader wmicReader) {
        StreamUtils.closeResource(null, (Closeable)wmicReader);
        StreamUtils.closeResource(null, (Closeable)wmicInputStreamReader);
        if (null != wmicProcess) {
            wmicProcess.destroy();
        }
    }

    @Override
    public String execCmdWithNoCheckResult(String cmd, int timeOut) throws ToolException {
        return this.execCmdWithTimout(cmd, timeOut);
    }

    @Override
    public String execCmd(String command) throws ToolException {
        return this.executeCmdTimeout(command, -1);
    }

    @Override
    public String execCmdHasLog(String command) {
        String result = this.executeCmdTimeout(command, -1);
        if (!command.toLowerCase(Locale.getDefault()).startsWith(WMIC)) {
            LOGGER.info("execute command is : {} result = {},{}", command, System.lineSeparator(), result);
        }
        return result;
    }

    @Override
    public String executeCmdTimeout(String command, int timeout) {
        String cmdResult = "";
        if (command.toLowerCase(Locale.getDefault()).startsWith(WMIC)) {
            cmdResult = this.execWmicCmd(command, timeout);
            if (cmdResult.contains(EXE_FAILED) || !this.isLocalSupportWmic()) {
                cmdResult = this.paexecConnection.sendCmdAndGetResult(command, timeout);
            }
        } else {
            cmdResult = this.paexecConnection.sendCmdAndGetResult("mode con cols=380&" + command, timeout);
        }
        return cmdResult;
    }

    public String executeCmdTimeoutLcalWmic(String command, int timeout) {
        String cmdResult = "";
        if (command.toLowerCase(Locale.getDefault()).startsWith(WMIC)) {
            cmdResult = this.execWmicCmd(command, timeout);
            if (cmdResult.contains(EXE_FAILED) || !this.isLocalSupportWmic()) {
                cmdResult = this.paexecConnection.sendCmdAndGetResult(command, timeout);
            }
        } else {
            cmdResult = this.paexecConnection.sendCmdAndGetResult(command, timeout, true);
        }
        return cmdResult;
    }

    @Override
    public String execCmdNoLog(String command) throws ToolException {
        LOGGER.info("this method would not be called.");
        return null;
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut) throws ToolException {
        LOGGER.info("this method would not be called.");
        return null;
    }

    @Override
    public String execCmdWithTimout(String command, int timeout) throws ToolException {
        return this.executeCmdTimeout(command, timeout);
    }

    @Override
    public void execCmdWithOutReturn(String command) throws ToolException {
        LOGGER.info("this method would not be called.");
    }

    @Override
    public void setCLIMode(CliCmdModel mode) {
        LOGGER.info("this method would not be called.");
    }

    @Override
    public void close() {
        LOGGER.info("this method would not be called.");
    }

    @Override
    public void connect() throws ToolException {
        LOGGER.info("this method would not be called.");
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public void setPassword(String pwd) {
        this.password = AESEncrypt.encrypt((String)pwd);
    }

    public void setEncryptPassword(String pwd) {
        this.password = pwd;
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.password);
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLineW, int timeout) throws ToolException {
        return null;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLineW) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLineW, int keepInterval, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLineW, ICliConnection.SSHCmdParamEntity paramEntity) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithTimout(String commandLineW, int timeout, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public String execCmd(String commandLineW, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public Object execSql(String sqlW) throws ToolException {
        return null;
    }

    @Override
    public String execCmdNoLog(String command, List<String> endStrs) throws ToolException {
        LOGGER.warn("Windows execCmdNoLog is not implemented");
        return null;
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        LOGGER.warn("Windows execCmdNoLogTimout is not implemented");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execCmdRemoteTimout(String cmd, int timeOut) {
        if (this.paexecConnection.isGrabLocalHost()) {
            return this.paexecConnection.sendCmdAndGetResult(cmd, timeOut);
        }
        timeOut = timeOut == -1 ? 32 : timeOut;
        String cmdResultPath = this.paexecConnection.getRemoteCmdResultPath() + File.separator + GRAB_WM_EXEC_RESULT;
        String remotePath = this.paexecConnection.getRemoteCmdResultPath();
        try {
            ToolUtils.deleteFile(cmdResultPath);
            if (new File(cmdResultPath).exists()) {
                LOGGER.error("failed to delete remote file :" + cmdResultPath);
                throw new ToolException("failed to delete remote file :" + cmdResultPath);
            }
            String remoteCmd = WMIC_CMD_EXEC_TEMPLATE;
            String remoteRsult = WMIC_CMD_APPEND_TEMPLATE.replace(RESULT_PATH, cmdResultPath);
            String wmicCmdScriptPath = remotePath + File.separator + WMIC_REMOTE_SCRIPT_CMD;
            String newCmd = this.paexecConnection.reBuildcmd(cmd);
            Files.write(Paths.get(wmicCmdScriptPath, new String[0]), (newCmd + remoteRsult).getBytes(Charset.defaultCharset()), new OpenOption[0]);
            remoteCmd = remoteCmd.replace(CMD_INFO, wmicCmdScriptPath);
            long currentTimeMillis = System.currentTimeMillis();
            String result = this.execWmicCmd(remoteCmd, timeOut);
            long leftTimeLong = System.currentTimeMillis() - currentTimeMillis;
            int leftTime = (int)((long)timeOut - leftTimeLong / 1000L);
            if (!result.contains(REMOTE_SUCCESS)) {
                String string = cmd + ToolConstants.ENTER + EXE_FAILED;
                return string;
            }
            for (int i = 0; i < (leftTime < 0 ? 5 : leftTime); ++i) {
                if (new File(cmdResultPath).exists() && ToolUtils.isFileCanOperate(cmdResultPath)) {
                    result = ToolUtils.readFileContent(cmdResultPath);
                    LOGGER.info("exec cmd with wmic on remote result :{}", (Object)result);
                    result = ToolUtils.handleCmdResult(result, cmd, this.echoValueMap);
                    String string = "~>" + cmd + System.lineSeparator() + result;
                    return string;
                }
                ConnUtils.sleep(1000);
            }
            String string = cmd + ToolConstants.ENTER + EXE_TIMEOUT;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("cmd exec error", e);
        }
        finally {
            ToolUtils.deleteFile(cmdResultPath);
        }
        return cmd + ToolConstants.ENTER + EXE_FAILED;
    }

    public static String handleCmdResult(String result, String originCmd, Map<String, String> echoValueMap) {
        if (WmicConnection.isCommandNotSupport(result, originCmd)) {
            echoValueMap.put(originCmd, "127");
            result = new StringBuffer(result).append(ToolConstants.ENTER).append("TOOLKIT_EXE_CMD_FAILED").append(ToolConstants.ENTER).append("127").append(ToolConstants.ENTER).toString();
        }
        return result;
    }

    private static boolean isCommandNotSupport(String result, String cmd) {
        if (StringUtils.isBlank((CharSequence)cmd)) {
            return false;
        }
        String[] cmdWords = cmd.split(" ");
        return result.trim().startsWith('\'' + cmdWords[0] + '\'');
    }

    @Override
    public Map<String, String> getEchoValue() {
        return this.echoValueMap;
    }

    public PaexecConnection getPaexecConnection() {
        return this.paexecConnection;
    }

    public void setPaexecConnection(PaexecConnection paexecConnection) {
        this.paexecConnection = paexecConnection;
    }

    public String getIp() {
        return this.ip;
    }

    @Override
    public void execSwitchRootCmd(DevNode device) throws ToolException {
    }

    private static final class QueryOsTask
    implements Callable<String> {
        private QueryOsTask() {
        }

        @Override
        public String call() {
            return CmdExecutor.executeCmd((String)"systeminfo", (int)60);
        }
    }
}

