/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.win;

import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionCreator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ConnPoolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WmicConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmicConnectionManager.class);
    private static Map<String, WmicConnection> connectionPool = new HashMap<String, WmicConnection>();
    private static final Object LOCK = new Object();
    private static List<String> needToReleasePath = new ArrayList<String>();

    private WmicConnectionManager() {
        LOGGER.info("WmicConnectionManager has been initialized.");
    }

    public static List<String> getNeedToReleasePath() {
        return needToReleasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheWmicConnection(DevNode devNode, WmicConnection wmicConn) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        Object object = LOCK;
        synchronized (object) {
            if (wmicConn != null) {
                connectionPool.put(key, wmicConn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICliConnection getWmicConnection(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) throws ToolException {
        if (devNode.isFileNode()) {
            return new FileConnection(devNode);
        }
        String key = ConnPoolUtils.getKey(devNode);
        Object object = LOCK;
        synchronized (object) {
            WmicConnection wmicConn = connectionPool.get(key);
            if (wmicConn == null) {
                wmicConn = new WmicConnectionCreator(devNode).create();
                connectionPool.put(key, wmicConn);
            }
            return wmicConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICliConnection getWmicConnection(DevNode devNode) throws ToolException {
        if (devNode.isFileNode()) {
            return new FileConnection(EntityUtils.toNewDev(devNode));
        }
        String key = ConnPoolUtils.getKey(devNode);
        Object object = LOCK;
        synchronized (object) {
            WmicConnection wmicConn = connectionPool.get(key);
            if (wmicConn == null) {
                wmicConn = new WmicConnectionCreator(EntityUtils.toNewDev(devNode)).create();
                connectionPool.put(key, wmicConn);
            }
            return wmicConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConn(DevNode devNode) {
        Object object = LOCK;
        synchronized (object) {
            if (devNode == null) {
                return;
            }
            String key = ConnPoolUtils.getKey(devNode);
            connectionPool.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConn(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) {
        Object object = LOCK;
        synchronized (object) {
            if (devNode == null) {
                return;
            }
            String key = ConnPoolUtils.getKey(devNode);
            connectionPool.remove(key);
        }
    }
}

