/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ClusterNode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMPUTE = "compute";
    private static final List<BaseBoardType> PROPRIETARY_HARDWARE_LIST = BaseBoardType.access$000();
    private int id;
    private String name;
    private String serialNumber;
    private String managementIp;
    private String cabinet;
    private String subrack;
    private String slotNumber;
    private String model;
    private boolean inCluster;
    private ClusterNodeStatus status;
    private boolean installationStatus;
    private String softwareVersion;
    private boolean selected = true;
    private String bmcIp;
    private DevNode bmcNode;
    private DevNode osNode;
    private String osOriginalIp;
    private Set<String> roles = new HashSet<String>();
    private String modelByBmc = "";
    private FsmRole fsmRole = FsmRole.ELSE;
    private FusionStorStoragePool joinedStoragePool;
    private List<FusionStorDiskInfo> allDiskInfo = new ArrayList<FusionStorDiskInfo>();
    private List<FusionStorDiskInfo> mainStorageDisk = new ArrayList<FusionStorDiskInfo>();
    private List<FusionStorDiskInfo> cacheDisk = new ArrayList<FusionStorDiskInfo>();
    private BaseBoardType baseBoardType;
    private SandboxStatus sandboxStatus = SandboxStatus.UNSUPPORTED;
    private String taskId = "";
    private String deviceId = "";
    private String deviceType = "";
    private List<MultiRouteNode> sshForwardList;
    private String bmcAuthStatus;

    public ClusterNode() {
    }

    public ClusterNode(int id, String name, String serialNumber, String managementIp, String cabinet, String subrack, String slotNumber, String model, boolean inCluster, ClusterNodeStatus status, boolean installationStatus, String softwareVersion) {
        this.id = id;
        this.name = name;
        this.serialNumber = serialNumber;
        this.managementIp = managementIp;
        this.cabinet = cabinet;
        this.subrack = subrack;
        this.slotNumber = slotNumber;
        this.model = model;
        this.inCluster = inCluster;
        this.status = status;
        this.installationStatus = installationStatus;
        this.softwareVersion = softwareVersion;
        this.selected = true;
        this.modelByBmc = model;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getManagementIp() {
        return this.managementIp;
    }

    public void setManagementIp(String managementIp) {
        this.managementIp = managementIp;
    }

    public String getCabinet() {
        return this.cabinet;
    }

    public void setCabinet(String cabinet) {
        this.cabinet = cabinet;
    }

    public String getSubrack() {
        return this.subrack;
    }

    public void setSubrack(String subrack) {
        this.subrack = subrack;
    }

    public String getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(String slotNumber) {
        this.slotNumber = slotNumber;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean isInCluster() {
        return this.inCluster;
    }

    public void setInCluster(boolean inCluster) {
        this.inCluster = inCluster;
    }

    public ClusterNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ClusterNodeStatus status) {
        this.status = status;
    }

    public boolean isInstallationStatus() {
        return this.installationStatus;
    }

    public void setInstallationStatus(boolean installationStatus) {
        this.installationStatus = installationStatus;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterNode that = (ClusterNode)obj;
        return this.id == that.id && Objects.equals(this.managementIp, that.managementIp) && Objects.equals(this.cabinet, that.cabinet) && Objects.equals(this.taskId, that.taskId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.managementIp, this.cabinet, this.taskId);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setBmcNode(DevNode bmcNode) {
        this.bmcNode = bmcNode;
    }

    public DevNode getBmcNode() {
        return this.bmcNode;
    }

    public FusionStorStoragePool getJoinedStoragePool() {
        return this.joinedStoragePool;
    }

    public void setJoinedStoragePool(FusionStorStoragePool joinedStoragePool) {
        this.joinedStoragePool = joinedStoragePool;
    }

    public List<FusionStorDiskInfo> getAllDiskInfo() {
        return this.allDiskInfo;
    }

    public void setAllDiskInfo(List<FusionStorDiskInfo> allDiskInfo) {
        this.allDiskInfo = allDiskInfo;
    }

    public List<FusionStorDiskInfo> getMainStorageDisk() {
        return this.mainStorageDisk;
    }

    public void setMainStorageDisk(List<FusionStorDiskInfo> mainStorageDisk) {
        this.mainStorageDisk = mainStorageDisk;
    }

    public List<FusionStorDiskInfo> getCacheDisk() {
        return this.cacheDisk;
    }

    public void setCacheDisk(List<FusionStorDiskInfo> cacheDisk) {
        this.cacheDisk = cacheDisk;
    }

    public boolean includedStorageService() {
        return this.roles.stream().anyMatch(role -> role.contains("storage"));
    }

    public boolean includeManagementRole() {
        return this.roles.stream().anyMatch(role -> role.contains("management"));
    }

    public boolean isOnlyComputeNode() {
        return this.roles.size() == 1 && this.roles.stream().anyMatch(role -> role.contains(COMPUTE));
    }

    public boolean isPacificNode() {
        return this.baseBoardType == BaseBoardType.PACIFIC;
    }

    public boolean isAtlanticNode() {
        return this.baseBoardType == BaseBoardType.ATLANTIC;
    }

    public boolean isEastSeaNode() {
        return this.isEastSeaSingleNode() || this.isEastSeaDoubleNode();
    }

    public boolean isEastSeaSingleNode() {
        return this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaDoubleNode() {
        return this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaSingleProcessor() {
        return this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_SINGLE_PROCESSOR;
    }

    public boolean isEastSeaDoubleProcessor() {
        return this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054 || this.baseBoardType == BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaSingleNodeDualProcessor() {
        return this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isHGNode() {
        return this.baseBoardType == BaseBoardType.HG_SERVER;
    }

    public void setBaseBoardType(String baseBoardType) {
        Optional<BaseBoardType> tempTpye = BaseBoardType.mappingEnum(baseBoardType);
        if (tempTpye.isPresent()) {
            this.baseBoardType = tempTpye.get();
        }
    }

    public boolean isProprietaryHardware() {
        return PROPRIETARY_HARDWARE_LIST.contains((Object)this.baseBoardType);
    }

    public boolean isSiNanNode() {
        return this.baseBoardType == BaseBoardType.SINAN_HDD || this.baseBoardType == BaseBoardType.SINAN_PALM;
    }

    public boolean isA310Node() {
        return this.baseBoardType == BaseBoardType.NEW_ATLANTIC;
    }

    public boolean isDirectPlanesNode() {
        return this.baseBoardType == BaseBoardType.SSM_ATLANTIC;
    }

    public boolean isStorageNode() {
        return this.getRoles().contains("storage");
    }

    public String getBmcIp() {
        return this.bmcIp;
    }

    public void setBmcIp(String bmcIp) {
        this.bmcIp = bmcIp;
    }

    public void setOsNode(DevNode osNode) {
        this.osNode = osNode;
    }

    public DevNode getOsNode() {
        return this.osNode;
    }

    public void setOsOriginalIp(String osOriginalIp) {
        this.osOriginalIp = osOriginalIp;
    }

    public String getOsOriginalIp() {
        return this.osOriginalIp;
    }

    public void setModelByBmc(String modelByBmc) {
        this.modelByBmc = modelByBmc;
    }

    public String getModelByBmc() {
        return this.modelByBmc;
    }

    public void setFsmRole(FsmRole fsmRole) {
        this.fsmRole = fsmRole;
    }

    public FsmRole getFsmRole() {
        return this.fsmRole;
    }

    public BaseBoardType getBaseBoardType() {
        return this.baseBoardType;
    }

    public SandboxStatus getSandboxStatus() {
        return this.sandboxStatus;
    }

    public void setSandboxStatus(SandboxStatus sandboxStatus) {
        this.sandboxStatus = sandboxStatus;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public List<MultiRouteNode> getSshForwardList() {
        return this.sshForwardList;
    }

    public void setSshForwardList(List<MultiRouteNode> sshForwardList) {
        this.sshForwardList = sshForwardList;
    }

    public String getBmcAuthStatus() {
        return this.bmcAuthStatus;
    }

    public void setBmcAuthStatus(String bmcAuthStatus) {
        this.bmcAuthStatus = bmcAuthStatus;
    }

    public static enum BaseBoardType {
        PACIFIC("STL6SPCM", "OceanStor Pacific 9550,OceanStor Pacific 9350,OceanStor Pacific 9150"),
        ATLANTIC("STL6SPCN", "OceanStor Pacific 9950"),
        ARCTIC("STL6SPCP", ""),
        SINAN_HDD("STL6SPCY91", ""),
        SINAN_PALM("STL6SPCY92", ""),
        HG_SERVER("H01_HG_2P", ""),
        DH_SINGLE_SERVER_DOUBLE_PROCESSOR("STL6SPCX", "OceanStor Pacific 9546(1 Node 2 P),OceanStor Pacific 9346(1 Node 2 P)"),
        DH_SINGLE_SERVER_SINGLE_PROCESSOR("STL6SPCY55", "OceanStor Pacific 9346(1 Node 1 P),OceanStor Pacific 9146(1 Node 1 P)"),
        DH_DOUBLE_SERVER_DOUBLE_PROCESSOR("STL6SPCY", "OceanStor Pacific 9546(2 Nodes 2 P)"),
        DH_DOUBLE_SERVER_SINGLE_PROCESSOR("STL6SPCY44", "OceanStor Pacific 9546(2 Nodes 1 P)"),
        DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054("STL6SPCH02", "OceanStor Pacific 9546(1 Node 2 P),OceanStor Pacific 9346(1 Node 2 P)"),
        DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054("STL6SPCH01", "OceanStor Pacific 9546(2 Nodes 2 P)"),
        DH_SERVER("", "OceanStor Pacific 9546,OceanStor Pacific 9346,OceanStor Pacific 9146"),
        NEW_ATLANTIC("STL6SPCNE", "OceanStor A310"),
        SSM_ATLANTIC("Data Cluster Module", "Data Cluster Module");

        String productName;
        String devType;

        public static List<String> getProprietaryHardwareProductName() {
            return BaseBoardType.getProprietaryHardwares().stream().map(BaseBoardType::getProductName).collect(Collectors.toList());
        }

        private static List<BaseBoardType> getProprietaryHardwares() {
            return Arrays.asList(PACIFIC, ATLANTIC, ARCTIC, DH_DOUBLE_SERVER_DOUBLE_PROCESSOR, DH_SINGLE_SERVER_DOUBLE_PROCESSOR, DH_DOUBLE_SERVER_SINGLE_PROCESSOR, DH_SINGLE_SERVER_SINGLE_PROCESSOR, DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054, DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054, SINAN_HDD, SINAN_PALM, NEW_ATLANTIC);
        }

        public static Optional<BaseBoardType> mappingEnum(String name) {
            return Arrays.stream(BaseBoardType.values()).filter(value -> value.getProductName().equals(name)).findFirst();
        }

        public static Optional<BaseBoardType> mappingEnumByType(String devType) {
            if (StringUtils.isNULLStr(devType)) {
                return Optional.empty();
            }
            return Arrays.stream(BaseBoardType.values()).filter(value -> BaseBoardType.isContainsDevType(value.getDevType(), devType)).findFirst();
        }

        private static boolean isContainsDevType(String devTypes, String devType) {
            return Arrays.asList(devTypes.split(",")).contains(devType);
        }

        private BaseBoardType(String productName, String devType) {
            this.productName = productName;
            this.devType = devType;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getDevType() {
            return this.devType;
        }

        static /* synthetic */ List access$000() {
            return BaseBoardType.getProprietaryHardwares();
        }
    }
}

