/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.entity.HostInfo;
import com.huawei.ism.tool.obase.entity.InitiatorEnttiy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceInfo {
    private String deviceSn;
    private String deviceIp;
    private List<InitiatorEnttiy> fcInitiator;
    private List<InitiatorEnttiy> iscsiInitiator;
    private List<InitiatorEnttiy> ibInitiator;
    private List<HostInfo> hostInfo = new ArrayList<HostInfo>();
    private Map<String, InitiatorEnttiy> wwnInitMap = new HashMap<String, InitiatorEnttiy>();

    public List<InitiatorEnttiy> getFcInitiator() {
        return this.fcInitiator;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setFcInitiator(List<InitiatorEnttiy> fcInitiator) {
        this.fcInitiator = fcInitiator;
        if (fcInitiator == null) {
            return;
        }
        for (InitiatorEnttiy entity : fcInitiator) {
            entity.setInitiatorType("FC");
            this.wwnInitMap.put(entity.getWwn(), entity);
        }
    }

    public List<InitiatorEnttiy> getIscsiInitiator() {
        return this.iscsiInitiator;
    }

    public void setIscsiInitiator(List<InitiatorEnttiy> iscsiInitiator) {
        this.iscsiInitiator = iscsiInitiator;
        if (iscsiInitiator == null) {
            return;
        }
        for (InitiatorEnttiy entity : iscsiInitiator) {
            entity.setInitiatorType("iSCSI");
            this.wwnInitMap.put(entity.getIscsiIQN(), entity);
        }
    }

    public List<InitiatorEnttiy> getIbInitiator() {
        return this.ibInitiator;
    }

    public void setIbInitiator(List<InitiatorEnttiy> ibInitiator) {
        this.ibInitiator = ibInitiator;
        if (ibInitiator == null) {
            return;
        }
        for (InitiatorEnttiy entity : ibInitiator) {
            entity.setInitiatorType("IB");
            this.wwnInitMap.put(entity.getWwn(), entity);
        }
    }

    public List<HostInfo> getHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(List<HostInfo> hostInfo) {
        this.hostInfo = hostInfo;
    }

    public Map<HostInfo, List<InitiatorEnttiy>> getHostInitMap() {
        HashMap<HostInfo, List<InitiatorEnttiy>> resMap = new HashMap<HostInfo, List<InitiatorEnttiy>>();
        if (this.fcInitiator == null && this.iscsiInitiator == null && this.ibInitiator == null || this.hostInfo == null) {
            return resMap;
        }
        if (this.fcInitiator != null) {
            this.fillFcInitintor(this.fcInitiator, resMap, "FC");
        }
        if (this.iscsiInitiator != null) {
            this.fillFcInitintor(this.iscsiInitiator, resMap, "iSCSI");
        }
        if (this.ibInitiator != null) {
            this.fillFcInitintor(this.ibInitiator, resMap, "IB");
        }
        return resMap;
    }

    public void fillFcInitintor(List<InitiatorEnttiy> fcInitiators, Map<HostInfo, List<InitiatorEnttiy>> resMap, String initiatorType) {
        for (InitiatorEnttiy initiatorEnttiy : fcInitiators) {
            if (this.hostInfo == null) continue;
            for (HostInfo hInfo : this.hostInfo) {
                if (hInfo.getHostId() == null || !hInfo.getHostId().equals(initiatorEnttiy.getHostId())) continue;
                initiatorEnttiy.setInitiatorType(initiatorType);
                List<InitiatorEnttiy> initiatorList = resMap.get(hInfo);
                if (initiatorList == null) {
                    initiatorList = new ArrayList<InitiatorEnttiy>();
                    resMap.put(hInfo, initiatorList);
                }
                initiatorList.add(initiatorEnttiy);
            }
        }
    }

    public Map<String, InitiatorEnttiy> getWwnInitMap() {
        return this.wwnInitMap;
    }

    public void setWwnInitMap(Map<String, InitiatorEnttiy> wwnInitMap) {
        this.wwnInitMap = wwnInitMap;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public void setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public String toString() {
        return "DeviceInfo [deviceSn=" + this.deviceSn + "]";
    }
}

