/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.CheckDevNode;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DevMap;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.ResultDevNode;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class EntityUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EntityUtils.class);
    private static final String KEYPWD = "keypwd";
    private static final String KEYPATH = "keypath";
    private static final String KEYNAME = "keyname";
    private static final String UUID = "uuid";
    private static final String UNAME = "uname";
    private static final String HOST = "host";
    private static final String PWD = "pwd";
    private static final String USER = "user";
    private static final String SERVER_IP = "serverIp";
    private static final String PORT = "port";
    private static final String PASS_WORD = "pass";
    private static final String NAME = "name";
    static final String AUTHENTIC = "authentic";

    private EntityUtils() {
    }

    public static DevNode toOldDev(com.huawei.ism.tool.framework.pubservice.entity.DevNode node) {
        if (null == node) {
            return null;
        }
        DevNode ret = EntityUtils.getDevNode(node);
        com.huawei.ism.tool.framework.pubservice.entity.DeviceType deviceLevel2 = node.getDevTypeLevel2();
        if (null != deviceLevel2) {
            ret.setDevTypeLevel2(DeviceType.valueOf(deviceLevel2.toString()));
        }
        EntityUtils.setLoginUserInfo(node, ret);
        EntityUtils.setRootUserInfo(node, ret);
        EntityUtils.setFusionCubeLoginUser(node, ret);
        EntityUtils.setA3000LoginUser(node, ret);
        EntityUtils.setClientUser(node, ret);
        ret.setVerifyCertificate(node.isVerifyCertificate());
        ret.setCreateTime(node.getCreateTime());
        if (node.getPeerIp() != null) {
            ret.setPeerIp(node.getPeerIp());
        }
        if (node.getSocks5Proxy() != null) {
            ret.setSocks5Proxy(EntityUtils.toOldSocksProxy(node.getSocks5Proxy()));
        }
        if (node.getSshForwardList() != null) {
            EntityUtils.setRetDevicesSshForwardList(node, ret);
        }
        if (null != node.getPriKey()) {
            EntityUtils.setRetDevicePrikey(node, ret);
        }
        EntityUtils.setDevKey(node, ret);
        ReflectionUtils.syncObjectAttr((Object)node, (Object)ret);
        return ret;
    }

    private static void setLoginUserInfo(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (null != node.getLoginUser()) {
            String name = node.getLoginUser().getUserName();
            String pass = node.getLoginUser().getPassword();
            int port = node.getLoginUser().getPort();
            String domainName = node.getLoginUser().getDomainName();
            User user = new User(name, pass, port);
            user.setDomainName(domainName);
            ret.setLoginUser(user);
        }
    }

    private static void setRootUserInfo(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (null != node.getRootUser()) {
            String name = node.getRootUser().getUserName();
            String pass = node.getRootUser().getPassword();
            int port = node.getRootUser().getPort();
            String domainName = node.getRootUser().getDomainName();
            User user = new User(name, pass, port);
            user.setDomainName(domainName);
            ret.setRootUser(user);
        }
    }

    private static void setFusionCubeLoginUser(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (Objects.nonNull(node.getFusionCubeLoginUser())) {
            String name = node.getFusionCubeLoginUser().getUserName();
            String pass = node.getFusionCubeLoginUser().getPassword();
            int port = node.getFusionCubeLoginUser().getPort();
            String domainName = node.getFusionCubeLoginUser().getDomainName();
            User user = new User(name, pass, port);
            user.setDomainName(domainName);
            ret.setFusionCubeLoginUser(user);
        }
    }

    private static void setA3000LoginUser(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (Objects.nonNull(node.getA3000LoginUser())) {
            String name = node.getA3000LoginUser().getUserName();
            String pass = node.getA3000LoginUser().getPassword();
            int port = node.getA3000LoginUser().getPort();
            String domainName = node.getA3000LoginUser().getDomainName();
            User user = new User(name, pass, port);
            user.setDomainName(domainName);
            ret.setA3000LoginUser(user);
        }
    }

    private static void setClientUser(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (Objects.nonNull(node.getClientUser())) {
            String name = node.getClientUser().getUserName();
            String pass = node.getClientUser().getPassword();
            ret.setClientUser(new User(name, pass));
        }
    }

    private static void setRetDevicesSshForwardList(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        ArrayList<com.huawei.ism.tool.obase.connection.MultiRouteNode> sshForwardList = new ArrayList<com.huawei.ism.tool.obase.connection.MultiRouteNode>();
        for (MultiRouteNode routeNode : node.getSshForwardList()) {
            com.huawei.ism.tool.obase.connection.MultiRouteNode rNode = EntityUtils.toOldMultiRouteNode(routeNode);
            sshForwardList.add(rNode);
        }
        ret.setSshForwardList(sshForwardList);
    }

    private static void setRetDevicePrikey(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        PriKeyInfo info = new PriKeyInfo();
        info.setKeyName(node.getPriKey().getKeyName());
        info.setKeyPath(node.getPriKey().getKeyPath());
        info.setKeyPwd(node.getPriKey().getKeyPwd());
        ret.setPriKey(info);
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.DevNode cloneDevNode(com.huawei.ism.tool.framework.pubservice.entity.DevNode node) {
        return EntityUtils.toNewDev(EntityUtils.toOldDev(node));
    }

    public static DevNode cloneDevNode(DevNode node) {
        return EntityUtils.toOldDev(EntityUtils.toNewDev(node));
    }

    private static DevNode getDevNode(com.huawei.ism.tool.framework.pubservice.entity.DevNode node) {
        DevNode ret = new DevNode();
        ret.setIp(node.getIp());
        ret.setUseJdbc(node.isUseJdbc());
        ret.setDeviceName(node.getDeviceName());
        ret.setOemModel(node.getOemModel());
        ret.setBrand(node.getBrand());
        ret.setVendor(node.getVendor());
        ret.setUpgrade(node.isUpgrade());
        ret.setMiniSystem(node.isMiniSystem());
        ret.setDeviceSerialNumber(node.getDeviceSerialNumber());
        ret.setPort(node.getPort());
        ret.setTlvPort(node.getTlvPort());
        ret.setIpListAreInnerIp(node.isIpListAreInnerIp());
        ret.setProductVersion(node.getProductVersion());
        ret.setHotPatchVersion(node.getHotPatchVersion());
        ret.setUuid(node.getUuid());
        ret.setRemoteSNs(node.getRemoteSNs());
        ret.setHostAssociatedRemoteSN(node.getHostAssociatedRemoteSN());
        ret.setHostInfo(node.getHostInfo());
        ret.setAllStrgHyprMtrLns(node.getAllStrgHyprMtrLns());
        ret.setAdminUser(node.getAdminUser());
        ret.setHostFCLauncherWwns(node.getHostFCLauncherWwns());
        ret.setHostISCSILauncherWwns(node.getHostISCSILauncherWwns());
        ret.setHostIbLauncherWwns(node.getHostIbLauncherWwns());
        ret.setHostNvmeLauncherWwns(node.getHostNvmeLauncherWwns());
        ret.setHighDevSVPModuleInfo(node.getHighDevSVPModuleInfo());
        ret.setDevInfoPkgPath(node.getDevInfoPkgPath());
        ret.setHyperMetroHost(node.isHyperMetroHost());
        ret.setNodeAddType(node.getNodeAddType());
        ret.setSelectedNodeIps(node.getSelectedNodeIps());
        ret.setVerifyCertificate(node.isVerifyCertificate());
        EntityUtils.setOldDevComputeStorageInfo(node, ret);
        if (node.getDbName() != null) {
            ret.setDbName(node.getDbName());
        }
        if (node.getDeviceType() != null) {
            ret.setDeviceType(DeviceType.valueOf(node.getDeviceType().toString()));
        }
        String debugPwd = node.getDeveloperPwd();
        ret.setDeveloperPwd(debugPwd);
        for (String ip : node.getIpList()) {
            ret.addIp(ip);
        }
        ret.setItDeviceType(node.getItDeviceType());
        ret.setCanEnterDiagnose(node.canEnterDiagnose());
        ret.setScenarioInfo(node.getScenarioInfo());
        return ret;
    }

    private static void setOldDevComputeStorageInfo(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (ItDeviceType.COMPUTE_STORAGE.equals((Object)node.getStorageDeviceType()) && node.getComputeStorageDevNode() != null) {
            ComputeStorageDevNode csDevNode = new ComputeStorageDevNode();
            com.huawei.ism.tool.framework.pubservice.entity.ComputeStorageDevNode oldCsDevNode = node.getComputeStorageDevNode();
            csDevNode.setFcvIp(oldCsDevNode.getFcvIp());
            csDevNode.setOpenapiUser(new User(oldCsDevNode.getOpenapiUser().getUserName(), oldCsDevNode.getOpenapiUser().getPassword()));
            csDevNode.setComputeStorageFcvDeviceId(oldCsDevNode.getComputeStorageFcvDeviceId());
            csDevNode.setChassisNum(oldCsDevNode.getChassisNum());
            csDevNode.setStorageNodesInfo(oldCsDevNode.getStorageNodesInfo());
            ret.setComputeStorageDevNode(csDevNode);
        }
    }

    private static void setDevKey(com.huawei.ism.tool.framework.pubservice.entity.DevNode node, DevNode ret) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)node.getDeviceSerialNumber())) {
            ret.setDevKey(node.getDevKey());
        }
    }

    public static PriKeyInfo transToBasPk(com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo pkInfo) {
        PriKeyInfo info = null;
        if (pkInfo != null) {
            info = new PriKeyInfo();
            info.setKeyName(pkInfo.getKeyName());
            info.setKeyPath(pkInfo.getKeyPath());
            info.setKeyPwd(pkInfo.getKeyPwd());
        }
        return info;
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo transToPubPk(PriKeyInfo pkInfo) {
        com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo info = null;
        if (pkInfo != null) {
            info = new com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo();
            info.setKeyName(pkInfo.getKeyName());
            info.setKeyPath(pkInfo.getKeyPath());
            info.setKeyPwd(pkInfo.getKeyPwd());
        }
        return info;
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.DevNode toNewDev(DevNode node) {
        if (null == node) {
            return null;
        }
        com.huawei.ism.tool.framework.pubservice.entity.DevNode ret = EntityUtils.intRetDevNode(node);
        DeviceType deviceLevel2 = node.getDevTypeLevel2();
        if (null != deviceLevel2) {
            ret.setDevTypeLevel2(com.huawei.ism.tool.framework.pubservice.entity.DeviceType.valueOf((String)deviceLevel2.toString()));
        }
        if (null != node.getLoginUser()) {
            EntityUtils.setRetDeviceLoginUser(node, ret);
        }
        EntityUtils.setRootUserInfo(node, ret);
        EntityUtils.setFusionCubeLoginUser(node, ret);
        EntityUtils.setA3000LoginUser(node, ret);
        EntityUtils.setClientUser(node, ret);
        ret.setScenarioInfo(node.getScenarioInfo());
        ret.setCreateTime(node.getCreateTime());
        if (node.getPeerIp() != null) {
            ret.setPeerIp(node.getPeerIp());
        }
        if (node.getSocks5Proxy() != null) {
            ret.setSocks5Proxy(EntityUtils.toNewSocks5Proxy(node.getSocks5Proxy()));
        }
        EntityUtils.setSshForwardInfo(node, ret);
        EntityUtils.setComputeStorageInfo(node, ret);
        EntityUtils.setPriKeyInfo(node, ret);
        EntityUtils.setDevKey(node, ret);
        ReflectionUtils.syncObjectAttr((Object)node, (Object)ret);
        return ret;
    }

    private static void setFusionCubeLoginUser(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (Objects.nonNull(node.getFusionCubeLoginUser())) {
            String name = node.getFusionCubeLoginUser().getUserName();
            String pass = node.getFusionCubeLoginUser().getPassword();
            int port = node.getFusionCubeLoginUser().getPort();
            String domainName = node.getFusionCubeLoginUser().getDomainName();
            com.huawei.ism.tool.framework.pubservice.entity.User user = new com.huawei.ism.tool.framework.pubservice.entity.User(name, pass, port);
            user.setDomainName(domainName);
            ret.setFusionCubeLoginUser(user);
        }
    }

    private static void setA3000LoginUser(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (Objects.nonNull(node.getA3000LoginUser())) {
            String name = node.getA3000LoginUser().getUserName();
            String pass = node.getA3000LoginUser().getPassword();
            int port = node.getA3000LoginUser().getPort();
            String domainName = node.getA3000LoginUser().getDomainName();
            com.huawei.ism.tool.framework.pubservice.entity.User user = new com.huawei.ism.tool.framework.pubservice.entity.User(name, pass, port);
            user.setDomainName(domainName);
            ret.setA3000LoginUser(user);
        }
    }

    private static void setClientUser(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (Objects.nonNull(node.getClientUser())) {
            String name = node.getClientUser().getUserName();
            String pass = node.getClientUser().getPassword();
            ret.setClientUser(new com.huawei.ism.tool.framework.pubservice.entity.User(name, pass));
        }
    }

    public static DevNode convertToComputeStorageDevNode(DevNode devNode) {
        DevNode tmpDevNode = EntityUtils.cloneDevNode(devNode);
        tmpDevNode.setLoginUser(devNode.getComputeStorageDevNode().getOpenapiUser());
        tmpDevNode.setIp(devNode.getComputeStorageDevNode().getFcvIp());
        return tmpDevNode;
    }

    public static DevNode convertToStorageDevNode(DevNode devNode) {
        return EntityUtils.cloneDevNode(devNode);
    }

    private static void setPriKeyInfo(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (null != node.getPriKey()) {
            com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo info = new com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo();
            info.setKeyName(node.getPriKey().getKeyName());
            info.setKeyPath(node.getPriKey().getKeyPath());
            info.setKeyPwd(node.getPriKey().getKeyPwd());
            ret.setPriKey(info);
        }
    }

    private static void setSshForwardInfo(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (node.getSshForwardList() != null) {
            ArrayList<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();
            for (com.huawei.ism.tool.obase.connection.MultiRouteNode routeNode : node.getSshForwardList()) {
                MultiRouteNode rNode = EntityUtils.toNewMultiRouteNode(routeNode);
                sshForwardList.add(rNode);
            }
            ret.setSshForwardList(sshForwardList);
        }
    }

    private static void setRootUserInfo(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (null != node.getRootUser()) {
            String name = node.getRootUser().getUserName();
            String pass = node.getRootUser().getPassword();
            int port = node.getRootUser().getPort();
            String domainName = node.getRootUser().getDomainName();
            com.huawei.ism.tool.framework.pubservice.entity.User user = new com.huawei.ism.tool.framework.pubservice.entity.User(name, pass, port);
            user.setDomainName(domainName);
            ret.setRootUser(user);
        }
    }

    private static void setComputeStorageInfo(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        com.huawei.ism.tool.framework.pubservice.entity.ComputeStorageDevNode csDevNode = new com.huawei.ism.tool.framework.pubservice.entity.ComputeStorageDevNode();
        ComputeStorageDevNode oldCsDevNode = node.getComputeStorageDevNode();
        if (Objects.nonNull(oldCsDevNode)) {
            csDevNode.setFcvIp(oldCsDevNode.getFcvIp());
            csDevNode.setOpenapiUser(new com.huawei.ism.tool.framework.pubservice.entity.User(oldCsDevNode.getOpenapiUser().getUserName(), oldCsDevNode.getOpenapiUser().getPassword()));
            csDevNode.setComputeStorageFcvDeviceId(oldCsDevNode.getComputeStorageFcvDeviceId());
            csDevNode.setChassisNum(oldCsDevNode.getChassisNum());
            csDevNode.setStorageNodesInfo(oldCsDevNode.getStorageNodesInfo());
            ret.setComputeStorageDevNode(csDevNode);
        }
    }

    private static void setRetDeviceLoginUser(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        String name = node.getLoginUser().getUserName();
        String pass = node.getLoginUser().getPassword();
        int port = node.getLoginUser().getPort();
        String domainName = node.getLoginUser().getDomainName();
        com.huawei.ism.tool.framework.pubservice.entity.User user = new com.huawei.ism.tool.framework.pubservice.entity.User(name, pass, port);
        user.setDomainName(domainName);
        ret.setLoginUser(user);
    }

    private static com.huawei.ism.tool.framework.pubservice.entity.DevNode intRetDevNode(DevNode node) {
        com.huawei.ism.tool.framework.pubservice.entity.DevNode ret = EntityUtils.copyCommonInfo(node);
        LOGGER.info("highDevSVPModuleInfo: {}", (Object)StringUtils.getCleanMessage((String)node.getHighDevSVPModuleInfo()));
        if (node.getDeviceType() != null) {
            ret.setDeviceType(com.huawei.ism.tool.framework.pubservice.entity.DeviceType.valueOf((String)node.getDeviceType().toString()));
        }
        ret.setPort(node.getPort());
        ret.setTlvPort(node.getTlvPort());
        ret.setIpListAreInnerIp(node.isIpListAreInnerIp());
        ret.setProductVersion(node.getProductVersion());
        ret.setHotPatchVersion(node.getHotPatchVersion());
        ret.setUuid(node.getUuid());
        ret.setDeveloperPwd(node.getDeveloperPwd());
        ret.setErrorDecs(node.getErrorDecs());
        ret.setMigrType(node.getMigrType());
        ret.setSudoGrab(node.isSudoGrab());
        ret.setDeviceModel(node.getDeviceModel());
        for (String ip : node.getIpList()) {
            ret.addIp(ip);
        }
        ret.setItDeviceType(node.getItDeviceType());
        ret.setCanEnterDiagnose(node.canEnterDiagnose());
        ret.setSshHostKey(node.getSshHostKey());
        ret.setVerifySshHostKey(node.isVerifySshHostKey());
        return ret;
    }

    @NotNull
    private static com.huawei.ism.tool.framework.pubservice.entity.DevNode copyCommonInfo(DevNode node) {
        com.huawei.ism.tool.framework.pubservice.entity.DevNode ret = new com.huawei.ism.tool.framework.pubservice.entity.DevNode();
        ret.setUseJdbc(node.isUseJdbc());
        ret.setDbName(node.getDbName());
        ret.setIp(node.getIp());
        ret.setDeviceName(node.getDeviceName());
        ret.setDeviceSerialNumber(node.getDeviceSerialNumber());
        ret.setOemModel(node.getOemModel());
        ret.setBrand(node.getBrand());
        ret.setVendor(node.getVendor());
        ret.setUpgrade(node.isUpgrade());
        ret.setMiniSystem(node.isMiniSystem());
        ret.setRemoteSNs(node.getRemoteSNs());
        ret.setRelatedSNIPs(node.getRelatedSNIPs());
        ret.setHostAssociatedRemoteSN(node.getHostAssociatedRemoteSN());
        ret.setHostInfo(node.getHostInfo());
        ret.setAllStrgHyprMtrLns(node.getAllStrgHyprMtrLns());
        ret.setAdminUser(node.getAdminUser());
        ret.setHostFCLauncherWwns(node.getHostFCLauncherWwns());
        ret.setHostISCSILauncherWwns(node.getHostISCSILauncherWwns());
        ret.setHighDevSVPModuleInfo(node.getHighDevSVPModuleInfo());
        ret.setDevInfoPkgPath(node.getDevInfoPkgPath());
        ret.setHyperMetroHost(node.isHyperMetroHost());
        ret.setNodeAddType(node.getNodeAddType());
        ret.setVerifyCertificate(node.isVerifyCertificate());
        ret.setSelectedNodeIps(node.getSelectedNodeIps());
        return ret;
    }

    private static void setDevKey(DevNode node, com.huawei.ism.tool.framework.pubservice.entity.DevNode ret) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)node.getDeviceSerialNumber())) {
            ret.setDevKey(node.getDevKey());
        }
    }

    public static MultiRouteNode toNewMultiRouteNode(com.huawei.ism.tool.obase.connection.MultiRouteNode node) {
        return new MultiRouteNode(node.getHost(), node.getPort(), node.getUname(), node.getPwd());
    }

    public static com.huawei.ism.tool.obase.connection.MultiRouteNode toOldMultiRouteNode(MultiRouteNode node) {
        return new com.huawei.ism.tool.obase.connection.MultiRouteNode(node.getHost(), node.getPort(), node.getUname(), node.getPwd());
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy toNewSocks5Proxy(Socks5Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy socks5Proxy = new com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy();
        socks5Proxy.setName(proxy.getName());
        socks5Proxy.setPort(proxy.getPort());
        socks5Proxy.setServerIp(proxy.getServerIp());
        String pass = proxy.getPass();
        socks5Proxy.setPass(pass);
        socks5Proxy.setAuthentic(proxy.isAuthentic());
        socks5Proxy.setUuid(proxy.getUuid());
        socks5Proxy.setUser(proxy.getUser());
        return socks5Proxy;
    }

    public static Socks5Proxy toOldSocksProxy(com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.setName(proxy.getName());
        socks5Proxy.setPort(proxy.getPort());
        socks5Proxy.setServerIp(proxy.getServerIp());
        socks5Proxy.setPass(proxy.getPass());
        socks5Proxy.setAuthentic(proxy.isAuthentic());
        socks5Proxy.setUuid(proxy.getUuid());
        socks5Proxy.setUser(proxy.getUser());
        return socks5Proxy;
    }

    public static List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> toNewDevList(List<DevNode> nodeList) {
        ArrayList<com.huawei.ism.tool.framework.pubservice.entity.DevNode> retList = new ArrayList<com.huawei.ism.tool.framework.pubservice.entity.DevNode>();
        for (DevNode node : nodeList) {
            retList.add(EntityUtils.toNewDev(node));
        }
        return retList;
    }

    public static List<DevNode> toOldDevList(List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> nodeList) {
        ArrayList<DevNode> retList = new ArrayList<DevNode>();
        for (com.huawei.ism.tool.framework.pubservice.entity.DevNode node : nodeList) {
            retList.add(EntityUtils.toOldDev(node));
        }
        return retList;
    }

    public static CheckDevNode toNewCheckDevNode(DevNode devNode, File scriptDir) {
        CheckDevNode checkDevNode = new CheckDevNode();
        checkDevNode.setDevNode(devNode);
        checkDevNode.setScriptDir(scriptDir);
        return checkDevNode;
    }

    public static Map<String, String> toShowMsg(Map<String, ResultDevNode> resultDevNodes) {
        HashMap<String, String> showMsgs = new HashMap<String, String>();
        for (Map.Entry<String, ResultDevNode> entry : resultDevNodes.entrySet()) {
            ResultDevNode value = entry.getValue();
            if (!value.isFlag()) continue;
            showMsgs.put(value.getIp(), value.getInfoMsg());
        }
        return showMsgs;
    }

    public static List<com.huawei.ism.tool.obase.connection.MultiRouteNode> cvtJsonToNewForwardList(String json) {
        return EntityUtils.cvtJsonToNewForwardList(json, null);
    }

    public static List<com.huawei.ism.tool.obase.connection.MultiRouteNode> cvtJsonToNewForwardList(String json, String decryptPass) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        JSONArray proxyArrayJson = new JSONArray(json);
        ArrayList<com.huawei.ism.tool.obase.connection.MultiRouteNode> forwardList = new ArrayList<com.huawei.ism.tool.obase.connection.MultiRouteNode>();
        for (int i = 0; i < proxyArrayJson.length(); ++i) {
            JSONObject proxyJson = proxyArrayJson.getJSONObject(i);
            String pass = (String)EntityUtils.getJsonVal(proxyJson, PWD);
            int port = (Integer)EntityUtils.getJsonVal(proxyJson, PORT);
            String ip = (String)EntityUtils.getJsonVal(proxyJson, HOST);
            String user = (String)EntityUtils.getJsonVal(proxyJson, UNAME);
            com.huawei.ism.tool.obase.connection.MultiRouteNode forward = new com.huawei.ism.tool.obase.connection.MultiRouteNode(ip, port, user, AESEncrypt.decrypt((String)pass));
            forwardList.add(forward);
        }
        return forwardList;
    }

    public static String toJsonPriKey(PriKeyInfo priKey) {
        if (priKey == null) {
            return "";
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(KEYNAME, (Object)Base64EncodeUtils.encode(priKey.getKeyName()));
        jsonObj.put(KEYPATH, (Object)Base64EncodeUtils.encode(priKey.getKeyPath()));
        jsonObj.put(KEYPWD, (Object)priKey.getEcptKeyPwd());
        return jsonObj.toString();
    }

    public static PriKeyInfo jsonToPriKey(String priKey) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)priKey)) {
            return null;
        }
        JSONObject jsonObj = new JSONObject(priKey);
        PriKeyInfo info = new PriKeyInfo();
        String keyname = (String)EntityUtils.getJsonVal(jsonObj, KEYNAME);
        info.setKeyName(Base64EncodeUtils.decode(keyname));
        String keypath = (String)EntityUtils.getJsonVal(jsonObj, KEYPATH);
        info.setKeyPath(Base64EncodeUtils.decode(keypath));
        String keyPwd = (String)EntityUtils.getJsonVal(jsonObj, KEYPWD);
        info.setEcptKeyPwd(keyPwd);
        return info;
    }

    public static com.huawei.ism.tool.obase.connection.MultiRouteNode cvtJsonToNewForward(String json) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        JSONObject proxyJson = new JSONObject(json);
        String pass = (String)EntityUtils.getJsonVal(proxyJson, PWD);
        int port = (Integer)EntityUtils.getJsonVal(proxyJson, PORT);
        String ip = (String)EntityUtils.getJsonVal(proxyJson, HOST);
        String user = (String)EntityUtils.getJsonVal(proxyJson, UNAME);
        com.huawei.ism.tool.obase.connection.MultiRouteNode forward = new com.huawei.ism.tool.obase.connection.MultiRouteNode(ip, port, user, pass);
        return forward;
    }

    public static MultiRouteNode cvtJsonToOldForward(String json) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        JSONObject proxyJson = new JSONObject(json);
        String pass = (String)EntityUtils.getJsonVal(proxyJson, PWD);
        int port = (Integer)EntityUtils.getJsonVal(proxyJson, PORT);
        String ip = (String)EntityUtils.getJsonVal(proxyJson, HOST);
        String user = (String)EntityUtils.getJsonVal(proxyJson, UNAME);
        MultiRouteNode forward = new MultiRouteNode(ip, port, user, pass);
        return forward;
    }

    public static JSONObject toOldSocks5ProxyJsonEncode(com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy proxy) {
        return EntityUtils.toNewSocks5ProxyJsonEncode(proxy);
    }

    public static JSONObject toNewSocks5ProxyJsonEncode(com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy proxy) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(PORT, (Object)proxy.getPort());
        jsonObj.put(NAME, (Object)proxy.getName());
        jsonObj.put(SERVER_IP, (Object)proxy.getServerIp());
        jsonObj.put(UUID, (Object)proxy.getUuid());
        jsonObj.put(USER, (Object)proxy.getUser());
        jsonObj.put(PASS_WORD, (Object)proxy.getEcptPass());
        jsonObj.put(AUTHENTIC, proxy.isAuthentic());
        return jsonObj;
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy cvtJsonToNewS5Peoxy(String json) {
        return EntityUtils.cvtJsonToNewS5Peoxy(json, null);
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy cvtJsonToNewS5Peoxy(String json, String decryptPass) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        JSONObject proxyJson = new JSONObject(json);
        com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy proxy = new com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy();
        boolean auth = (Boolean)EntityUtils.getJsonVal(proxyJson, AUTHENTIC);
        proxy.setAuthentic(auth);
        String name = (String)EntityUtils.getJsonVal(proxyJson, NAME);
        proxy.setName(name);
        String pass = (String)EntityUtils.getJsonVal(proxyJson, PASS_WORD);
        if (StringUtils.isNULLStr((String)decryptPass)) {
            proxy.setEcptPass(pass);
        } else {
            proxy.setPass(AESEncrypt.decrypt((String)pass));
        }
        String port = (String)EntityUtils.getJsonVal(proxyJson, PORT);
        proxy.setPort(port);
        String ip = (String)EntityUtils.getJsonVal(proxyJson, SERVER_IP);
        proxy.setServerIp(ip);
        String user = (String)EntityUtils.getJsonVal(proxyJson, USER);
        proxy.setUser(user);
        String uuid = (String)EntityUtils.getJsonVal(proxyJson, UUID);
        proxy.setUuid(uuid);
        return proxy;
    }

    private static <T> T getJsonVal(JSONObject proxyJson, String key) {
        return (T)proxyJson.get(key);
    }

    public static Socks5Proxy cvtJsonToOldS5Peoxy(String json) {
        return EntityUtils.toOldSocksProxy(EntityUtils.cvtJsonToNewS5Peoxy(json));
    }

    public static Socks5Proxy cvtJsonToOldS5Peoxy(String json, String decryptPass) {
        return EntityUtils.toOldSocksProxy(EntityUtils.cvtJsonToNewS5Peoxy(json, decryptPass));
    }

    public static JSONArray toSshForwardJsonEncode(List<com.huawei.ism.tool.obase.connection.MultiRouteNode> muList) throws JSONException {
        if (muList == null) {
            return null;
        }
        JSONArray jsonArr = new JSONArray();
        for (com.huawei.ism.tool.obase.connection.MultiRouteNode mu : muList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put(PORT, mu.getPort());
            jsonObj.put(HOST, (Object)mu.getHost());
            jsonObj.put(PWD, (Object)mu.getEcptPwd());
            jsonObj.put(UNAME, (Object)mu.getUname());
            jsonArr.put((Object)jsonObj);
        }
        return jsonArr;
    }

    public static JSONArray toSshForwardJsonEncodeNew(List<MultiRouteNode> muList) throws JSONException {
        if (muList == null) {
            return null;
        }
        JSONArray jsonArr = new JSONArray();
        for (MultiRouteNode mu : muList) {
            com.huawei.ism.tool.obase.connection.MultiRouteNode node = EntityUtils.toOldMultiRouteNode(mu);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put(PORT, node.getPort());
            jsonObj.put(HOST, (Object)node.getHost());
            jsonObj.put(PWD, (Object)node.getEcptPwd());
            jsonObj.put(UNAME, (Object)node.getUname());
            jsonArr.put((Object)jsonObj);
        }
        return jsonArr;
    }

    public static String getCurLoginUser(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) {
        User user = SshConnectionManager.getDevRUser(devNode.getDevKey());
        if (user != null) {
            return user.getUserName();
        }
        com.huawei.ism.tool.framework.pubservice.entity.User loginUser = devNode.getLoginUser();
        return loginUser == null ? "" : loginUser.getUserName();
    }

    public static String getCurLoginUser(DevNode devNode) {
        User user = SshConnectionManager.getDevRUser(devNode.getDevKey());
        if (user != null) {
            return user.getUserName();
        }
        User loginUser = devNode.getLoginUser();
        return loginUser == null ? "" : loginUser.getUserName();
    }

    public static Map<String, String> getDevMapDict(com.huawei.ism.tool.framework.pubservice.entity.DevNode dev) {
        DevMap<String, String> devMapDict = new DevMap<String, String>();
        devMapDict.put("sn", dev.getDeviceSerialNumber());
        devMapDict.put("type", dev.getDeviceType().toString());
        devMapDict.put("version", dev.getProductVersion());
        devMapDict.put(NAME, dev.getDeviceName());
        devMapDict.put("ip", dev.getIp());
        devMapDict.put("sshPort", String.valueOf(dev.getPort()));
        devMapDict.put("tlvPort", "0");
        devMapDict.put(USER, dev.getLoginUser().getUserName());
        String pwd = dev.getLoginUser().getPassword();
        devMapDict.put("pawd", pwd);
        String debugPwd = dev.getDeveloperPwd();
        devMapDict.put("devPassword", debugPwd);
        return devMapDict;
    }

    public static List<Map<String, String>> jsonToListHashMap(JSONObject jsonObj, String jsonArrayKey) {
        JSONArray jsonArray = EntityUtils.getJsonArrayByArrayKey(jsonObj, jsonArrayKey);
        return IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).getJSONObject(arg_0)).map(EntityUtils::escJsonToMap).collect(Collectors.toList());
    }

    @NotNull
    private static JSONArray getJsonArrayByArrayKey(JSONObject jsonObj, String jsonArrayKey) {
        JSONArray jsonArray;
        Object object = jsonObj.get(jsonArrayKey);
        if (object instanceof JSONArray) {
            jsonArray = (JSONArray)object;
        } else if (object instanceof String) {
            jsonArray = new JSONArray(object.toString());
        } else {
            throw new JSONException("JSONObject has not specify  JSONArray.");
        }
        return jsonArray;
    }

    private static Map<String, String> escJsonToMap(JSONObject obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = obj.get(key).toString();
            map.put(key, value);
        }
        return map;
    }

    public static com.huawei.ism.tool.framework.pubservice.entity.DevNode convertMapToOldDevNode(com.huawei.ism.tool.framework.pubservice.entity.DevNode oldDev, Map<String, String> devInfoMap) {
        com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode = EntityUtils.cloneDevNode(oldDev);
        devNode.setDeviceName(String.format("%s MetaVision(%s)%s", devInfoMap.get("deviceName"), oldDev.getIp(), ResourceUtil.getString("metavision.title")));
        devNode.setIp(devInfoMap.get("ip"));
        com.huawei.ism.tool.framework.pubservice.entity.User user = new com.huawei.ism.tool.framework.pubservice.entity.User(devInfoMap.get("username"), AESEncrypt.decrypt((String)devInfoMap.get("password")));
        devNode.setLoginUser(user);
        devNode.setProductVersion(devInfoMap.get("productVersion"));
        com.huawei.ism.tool.framework.pubservice.entity.DeviceType type = com.huawei.ism.tool.framework.pubservice.entity.DeviceType.valueOf((String)devInfoMap.get("productModel"));
        devNode.setDeviceType(type);
        devNode.setDeviceSerialNumber(devInfoMap.get("sn"));
        devNode.setHotPatchVersion(devInfoMap.get("hotPatchVersion"));
        devNode.getComputeStorageDevNode().setChassisNum(devInfoMap.get("computeStorageInfoChassisNum"));
        devNode.setItDeviceType(ItDeviceType.Storage);
        return devNode;
    }

    public static List<DevNode> convertComputeStorageToOldDevNode(DevNode devNode) {
        return devNode.getComputeStorageDevNode().getStorageNodesInfo().stream().map(stringStringMap -> EntityUtils.convertMapToOldDevNode(EntityUtils.toNewDev(devNode), stringStringMap)).map(EntityUtils::toOldDev).collect(Collectors.toList());
    }

    public static boolean isComputeStorageDevLoginThroughFcv(DevNode devNode) {
        return Objects.nonNull(devNode.getComputeStorageDevNode()) && devNode.getIp().equals(devNode.getComputeStorageDevNode().getFcvIp());
    }
}

