/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;

public class FusionStorDiskInfo
implements Cloneable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.000");
    private String sn;
    private DiskTypeEnum type;
    private String capacity;
    private CapacityUnit capacityUnit = CapacityUnit.BYTE;
    private boolean free = true;
    private boolean customConfig = false;
    private String diskZoneId;

    public Long getCapacityByLong() {
        if (StringUtils.isNULLStr(this.capacity)) {
            return 0L;
        }
        return (long)(Double.valueOf(this.capacity) * FusionStorDiskInfo.equation(this.getDigitNumber(), this.capacityUnit.getMultiples()));
    }

    public Double getCapacityAssignUnit(CapacityUnit unit, int scale) {
        BigDecimal digitNumber = BigDecimal.valueOf(this.getDigitNumber());
        BigDecimal resultCapacity = new BigDecimal(this.getCapacityByLong());
        int multiples = unit.getMultiples();
        for (int i = 1; i < multiples; ++i) {
            resultCapacity = resultCapacity.divide(digitNumber, scale, RoundingMode.FLOOR);
        }
        return resultCapacity.doubleValue();
    }

    public String getCapacityByUnit() {
        double digitNumber = this.getDigitNumber();
        double mb = (double)this.getCapacityByLong().longValue() / digitNumber / digitNumber;
        if (mb < digitNumber) {
            return DECIMAL_FORMAT.format(mb) + "MB";
        }
        double gb = mb / digitNumber;
        if (gb < digitNumber) {
            return DECIMAL_FORMAT.format(gb) + "GB";
        }
        double tb = gb / digitNumber;
        if (tb < digitNumber) {
            return DECIMAL_FORMAT.format(tb) + "TB";
        }
        double pb = tb / digitNumber;
        return DECIMAL_FORMAT.format(pb) + "PB";
    }

    private double getDigitNumber() {
        if (DiskTypeEnum.SSD_CARD_AND_NVME_SSD == this.type) {
            return 1000.0;
        }
        return 1024.0;
    }

    private static double equation(double digitNumber, int multiples) {
        double value = 1.0;
        for (int i = 1; i < multiples; ++i) {
            value *= digitNumber;
        }
        return value;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public DiskTypeEnum getType() {
        return this.type;
    }

    public void setType(DiskTypeEnum type) {
        this.type = type;
    }

    public String getCapacity() {
        return this.getCapacityByLong() + "";
    }

    public String getOriCapacity() {
        return this.capacity;
    }

    public String getOriginalCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public CapacityUnit getCapacityUnit() {
        return this.capacityUnit;
    }

    public void setCapacityAndUnit(String capacity, CapacityUnit capacityUnit) {
        this.capacity = capacity;
        this.capacityUnit = capacityUnit;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isCustomConfig() {
        return this.customConfig;
    }

    public void setCustomConfig(boolean customConfig) {
        this.customConfig = customConfig;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getDiskZoneId() {
        return this.diskZoneId;
    }

    public void setDiskZoneId(String diskZoneId) {
        this.diskZoneId = diskZoneId;
    }

    public static enum CapacityUnit {
        BYTE(1, "Byte"),
        KB(2, "KB"),
        MB(3, "MB"),
        GB(4, "GB"),
        TB(5, "TB");

        private int multiples;
        private String description;

        private CapacityUnit(int multiples, String description) {
            this.multiples = multiples;
            this.description = description;
        }

        public int getMultiples() {
            return this.multiples;
        }

        public String getDescription() {
            return this.description;
        }

        public static CapacityUnit mappingEnum(String description) {
            return Arrays.stream(CapacityUnit.values()).filter(value -> value.getDescription().equals(description)).findFirst().orElse(BYTE);
        }
    }
}

