/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.listener.IDhcpObserver;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.DefaultIpaddressStratage;
import com.huawei.ism.tool.obase.net.dhcp.IIpAddressDispatchStratage;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPCoreServer;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPServlet;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public final class DHCPServiceManager {
    private static final Logger DHCPLOGGER = ToolLoggerFactory.getLogger(DHCPServiceManager.class);
    private static DHCPServiceManager instance = new DHCPServiceManager();
    private boolean isRuning = false;
    private String serverIp = "";
    private DHCPCoreServer server = null;
    private IIpAddressDispatchStratage strategy;

    public static synchronized DHCPServiceManager getInstance() {
        return instance;
    }

    public Map<String, String> getAddressMap() {
        if (null == this.strategy) {
            return new HashMap<String, String>();
        }
        return this.strategy.getIpaddressPool();
    }

    public void initIpaddressStrategy(String startIp, String endIp, String mask) {
        this.strategy = new DefaultIpaddressStratage(startIp, endIp, mask);
    }

    public void initIpaddressStrategy(String startIp, String endIp, String mask, IDhcpObserver observer) {
        this.initIpaddressStrategy(startIp, endIp, mask);
        this.strategy.addDhcpListener(observer);
    }

    public void startDHCPServer(String socketAddress, int port) throws ToolException {
        this.startDHCPServer(socketAddress, port, true, 60000);
        DHCPLOGGER.error("Start dhcp server successful.");
    }

    public void startDHCPServer(String socketAddress, int port, boolean isTimout, int timout) throws ToolException {
        if (this.isRuning) {
            DHCPLOGGER.error("DHCP server alerady started.");
            return;
        }
        try {
            this.serverIp = socketAddress;
            InetSocketAddress addr = new InetSocketAddress(socketAddress, port);
            this.server = DHCPCoreServer.initServer(new DHCPServlet(this.strategy), addr, isTimout, timout);
            ThreadPoolManager.getInstance().execute((Runnable)this.server);
        }
        catch (ToolException e) {
            DHCPLOGGER.error("Start dhcp server error.", e);
            throw e;
        }
        this.isRuning = true;
        DHCPLOGGER.error("Start dhcp server successful.");
    }

    public void stopDHCPServer() {
        if (null != this.server && this.isRuning) {
            this.server.stopServer();
            this.strategy.clearAddressPool();
            this.isRuning = false;
        }
        DHCPLOGGER.error("Stop dhcp server successful.");
    }

    public boolean isDhcpStart() {
        return this.isRuning;
    }

    public String getDhcpServerIp() {
        return this.serverIp;
    }
}

