/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.config.PublicIpAddressUtils;
import com.huawei.ism.tool.obase.net.dhcp.utils.ToolNetUtil;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InetCidr
implements Serializable,
Comparable<InetCidr> {
    private static final long serialVersionUID = 1L;
    private static final String[] CIDR_MASKS = PublicIpAddressUtils.getValue("cidrMask").split(",");
    private static final Map<InetAddress, Integer> GCIDR = new HashMap<InetAddress, Integer>(48);
    private static final int NUM_33 = 33;
    private static final long[] GCIDRMASK = new long[33];
    private static final int MAX_MASK = 32;
    private final int addr;
    private final int mask;

    public InetCidr(InetAddress addr, int mask) {
        if (addr == null) {
            throw new NullPointerException("addr is null");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        if (mask < 1 || mask > 32) {
            throw new IllegalArgumentException("Bad mask:" + mask + " must be between 1 and 32");
        }
        this.addr = ToolNetUtil.inetAddress2Int(addr) & (int)GCIDRMASK[mask];
        this.mask = mask;
    }

    public InetCidr(InetAddress addr, InetAddress netMask) {
        if (addr == null || netMask == null) {
            throw new NullPointerException();
        }
        if (!(addr instanceof Inet4Address) || !(netMask instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        Integer intMask = GCIDR.get(netMask);
        if (intMask == null) {
            throw new IllegalArgumentException("netmask: " + netMask + " is not a valid mask");
        }
        this.addr = ToolNetUtil.inetAddress2Int(addr) & (int)GCIDRMASK[intMask];
        this.mask = intMask;
    }

    public String toString() {
        return ToolNetUtil.int2InetAddress(this.addr).getHostAddress() + '/' + this.mask;
    }

    public InetAddress getAddr() {
        return ToolNetUtil.int2InetAddress(this.addr);
    }

    public long getAddrLong() {
        return (long)this.addr & 0xFFFFFFFFL;
    }

    public int getMask() {
        return this.mask;
    }

    public final long toLong() {
        return ((long)this.addr & 0xFFFFFFFFL) + ((long)this.mask << 32);
    }

    public static final InetCidr fromLong(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("l must not be negative: " + value);
        }
        long ip = value & 0xFFFFFFFFL;
        long mask = value >> 32;
        return new InetCidr(ToolNetUtil.long2InetAddress(ip), (int)mask);
    }

    public int hashCode() {
        return this.addr ^ this.mask;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetCidr)) {
            return false;
        }
        InetCidr cidr = (InetCidr)obj;
        return this.addr == cidr.addr && this.mask == cidr.mask;
    }

    public static InetCidr[] addr2Cidr(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr must not be null");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        int addrInt = ToolNetUtil.inetAddress2Int(addr);
        InetCidr[] cidrs = new InetCidr[32];
        for (int i = cidrs.length; i >= 1; --i) {
            cidrs[32 - i] = new InetCidr(ToolNetUtil.int2InetAddress(addrInt & (int)GCIDRMASK[i]), i);
        }
        return cidrs;
    }

    @Override
    public int compareTo(InetCidr inetCidr) {
        long oLongTypeAddr;
        if (inetCidr == null) {
            throw new NullPointerException();
        }
        if (this.equals(inetCidr)) {
            return 0;
        }
        long longTypeAddr = InetCidr.int2UnsignedLong(this.addr);
        if (longTypeAddr == (oLongTypeAddr = InetCidr.int2UnsignedLong(inetCidr.addr))) {
            if (this.mask == inetCidr.mask) {
                return 0;
            }
            if (this.mask > inetCidr.mask) {
                return 1;
            }
            return -1;
        }
        if (longTypeAddr > oLongTypeAddr) {
            return 1;
        }
        return -1;
    }

    private static final long int2UnsignedLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static boolean isSorted(List<InetCidr> list) {
        if (list == null) {
            return true;
        }
        InetCidr preCidr = null;
        for (InetCidr cidr : list) {
            if (cidr == null) {
                throw new NullPointerException();
            }
            if (preCidr == null) {
                preCidr = cidr;
                continue;
            }
            if (preCidr.compareTo(cidr) >= 0) {
                return false;
            }
            preCidr = cidr;
        }
        return true;
    }

    public static void checkNoOverlap(List<InetCidr> list) {
        if (list == null) {
            return;
        }
        InetCidr prev = null;
        long pivotEnd = -1L;
        for (InetCidr cidr : list) {
            if (cidr == null) {
                throw new NullPointerException();
            }
            if (prev != null && cidr.getAddrLong() <= pivotEnd) {
                throw new IllegalStateException("Overlapping cidr: " + prev + ", " + cidr);
            }
            pivotEnd = cidr.getAddrLong() + (GCIDRMASK[cidr.getMask()] ^ 0xFFFFFFFFL);
            prev = cidr;
        }
    }

    static {
        try {
            InetCidr.GCIDRMASK[0] = 0L;
            for (int i = 0; i < CIDR_MASKS.length; ++i) {
                InetAddress mask = InetAddress.getByName(CIDR_MASKS[i]);
                InetCidr.GCIDRMASK[i + 1] = ToolNetUtil.inetAddress2Long(mask);
                GCIDR.put(mask, i + 1);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to initialize CIDR", e);
        }
    }
}

