/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.processor.cli;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.processor.cli.CliProcessor;
import com.huawei.ism.tool.obase.processor.parser.ArrayReturnParser;
import com.huawei.ism.tool.obase.processor.parser.ICmdReturnParser;
import com.huawei.ism.tool.obase.processor.parser.XmlReturnParser;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.xml.cli.CliCmdNode;
import com.huawei.ism.tool.obase.xml.cli.ResultNode;
import java.util.List;
import java.util.Locale;

public final class ProcessorCreator {
    private ProcessorCreator() {
    }

    public static CliProcessor createCLIProcessor(CliCmdNode xmlNode, DeviceType deviceType, ICliConnection connection) throws ToolException {
        CliProcessor processor = ProcessorCreator.createCLIProcessor(xmlNode, deviceType);
        processor.setConnection(connection);
        return processor;
    }

    public static CliProcessor createCLIProcessor(CliCmdNode xmlNode, DeviceType deviceType) throws ToolException {
        CliProcessor processor = ProcessorCreator.createProcessorByXml(xmlNode);
        List<ResultNode> checkNodes = xmlNode.getResultNodes();
        if (1 != checkNodes.size()) {
            throw new IllegalArgumentException("The clicmd node config error,the number of checknode must be 1,the clicmd is \"" + xmlNode + "\"");
        }
        ResultNode checkNode = checkNodes.get(0);
        ICmdReturnParser checker = ProcessorCreator.getReturnChecker(deviceType, checkNode);
        processor.setChecker(checker);
        return processor;
    }

    public static CliProcessor createProcessorByXml(CliCmdNode xmlNode) throws ToolException {
        CliProcessor processor = null;
        String processorClassName = xmlNode.getPocessor();
        if (StringUtils.isNULLStr(processorClassName)) {
            processor = new CliProcessor();
        } else {
            try {
                Class<?> processorClass = Class.forName(processorClassName);
                processor = (CliProcessor)processorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ToolException("New instance error", e);
            }
            catch (InstantiationException e) {
                throw new ToolException("New instance error", e);
            }
            catch (IllegalAccessException e) {
                throw new ToolException("New instance error", e);
            }
            catch (Exception e1) {
                throw new ToolException("New instance error", e1);
            }
        }
        processor.setCmdModel(xmlNode.getModel());
        processor.setCommand(xmlNode.getCommand());
        processor.setDescription(xmlNode.getName(Locale.getDefault()));
        processor.setID(xmlNode.getID());
        return processor;
    }

    public static ICmdReturnParser getReturnChecker(DeviceType deviceType, ResultNode checkNode) {
        if (DeviceType.N8000.equals(deviceType)) {
            XmlReturnParser checker = new XmlReturnParser();
            checker.setXmlCheckNode(checkNode);
            return checker;
        }
        return new ArrayReturnParser();
    }
}

