/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.processor.parser;

import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.entity.TSonData;
import com.huawei.ism.tool.obase.processor.parser.AbstractReturnParser;
import java.util.ArrayList;
import java.util.List;

public class ArrayReturnParser
extends AbstractReturnParser {
    private String title;

    @Override
    protected List<TSonData> parseReturnData(String cmdResult) {
        if (this.checkCondition(cmdResult)) {
            return new ArrayList<TSonData>(0);
        }
        int contentBegin = 0;
        String[] lines = cmdResult.split("\n");
        if (lines.length >= 2) {
            contentBegin = this.fixParamaters(contentBegin, lines);
        }
        ArrayList<TSonData> datas = new ArrayList<TSonData>();
        this.fullfillListDatas(cmdResult, contentBegin, lines, datas);
        return datas;
    }

    private void fullfillListDatas(String cmdResult, int contentBegin, String[] lines, List<TSonData> datas) {
        if (cmdResult.indexOf("|") > -1) {
            TSonData data = this.parseBoxResult(lines, contentBegin);
            datas.add(data);
        } else {
            List<TSonData> rows = this.parseTableResult(lines, contentBegin);
            if (!rows.isEmpty()) {
                datas.addAll(rows);
            }
        }
    }

    private int fixParamaters(int contentBegin, String[] lines) {
        if (lines[0].indexOf("======") > -1) {
            if (lines[1].indexOf("===") > -1) {
                this.title = lines[2].trim();
                contentBegin = 3;
            } else {
                this.title = lines[1].trim();
                contentBegin = 2;
            }
        }
        return contentBegin;
    }

    private boolean checkCondition(String cmdResult) {
        return null == cmdResult || cmdResult.length() < 3 || cmdResult.startsWith("Error ");
    }

    public String getTitle() {
        return this.title;
    }

    protected TSonData parseBoxResult(String[] lines, int contentBegin) {
        TSonData data = new TSonData();
        for (int i = contentBegin; i < lines.length; ++i) {
            String[] keyvalue;
            String line = lines[contentBegin];
            if ((line = line.replaceAll("\r", "").trim()).indexOf("------") > -1 || line.indexOf("======") > -1 || !line.contains(" \\| ") || (keyvalue = line.split(" \\| ")).length != 2) continue;
            KeyValue<String, String> keyValue = new KeyValue<String, String>(keyvalue[0], keyvalue[1]);
            data.addData(keyValue);
        }
        return data;
    }

    protected List<TSonData> parseTableResult(String[] lines, int contentBegin) {
        ArrayList<Object> tableHeadRows = new ArrayList<Object>();
        boolean readHead = false;
        int tableContentBegin = contentBegin;
        for (int i = contentBegin; i < lines.length; ++i) {
            String line = lines[i];
            if (line.indexOf("------") > -1) {
                if (!readHead) {
                    continue;
                }
            } else {
                tableHeadRows.add(line);
                readHead = true;
            }
            ++tableContentBegin;
        }
        StringBuffer headStrBuffer = new StringBuffer("");
        for (String string : tableHeadRows) {
            headStrBuffer.append(string);
        }
        String headLine = headStrBuffer.toString();
        headLine = headLine.replaceAll("\r", "").trim();
        String[] stringArray = headLine.split("\\s(\\s)+");
        ArrayList<String> head = new ArrayList<String>();
        for (String str : stringArray) {
            head.add(str);
        }
        ArrayList<TSonData> datas = new ArrayList<TSonData>();
        for (int i = tableContentBegin; i < lines.length; ++i) {
            String[] segs = lines[i].replaceAll("\r", "").trim().split("\\s(\\s)+");
            if (segs.length < 2) continue;
            TSonData rowData = new TSonData();
            for (int j = 0; j < segs.length; ++j) {
                KeyValue<String, String> keyValue = new KeyValue<String, String>((String)head.get(j), segs[j]);
                rowData.addData(keyValue);
            }
            datas.add(rowData);
        }
        return datas;
    }
}

