/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.ui.component.RolloverButton;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;

public abstract class AbstractBasePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double DEFALUTRESIZEWEIGHT = 0.65;
    private static final Dimension DEFAULT_BTNPANESIZE = new Dimension(0, 32);
    private static final Dimension DEFAULT_TOPTABLESIZE = new Dimension(0, 100);
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private JSplitPane splitPane;
    private JPanel buttonPanel;
    private List<ToolAction> actionList = new ArrayList<ToolAction>();
    private List<JButton> btnList = new ArrayList<JButton>();
    private DefaultTableModel topTableModel = null;
    private JTable table = null;
    private JPanel bottomPanel;
    private boolean hasBottomPane;
    private Box buttonBox;
    private boolean isRolloverButton = true;

    public AbstractBasePanel(boolean hasBottomPane) {
        this.hasBottomPane = hasBottomPane;
        this.initComponents();
        this.initListeners();
    }

    public AbstractBasePanel() {
        this(true);
    }

    public Object getSelectObj() {
        return null;
    }

    public void updateButtons() {
        List<JButton> list = this.getBtnList();
        for (JButton button : list) {
            Object rows = this.getSelectObj();
            ToolAction btnAction = (ToolAction)button.getAction();
            btnAction.setSelectObject(rows);
            button.setEnabled(btnAction.isAvailable());
        }
    }

    public Box getButtonBox() {
        this.buttonBox = Box.createHorizontalBox();
        return this.buttonBox;
    }

    protected JComponent getTopComponent() {
        if (null == this.table) {
            this.table = new JTable(this.topTableModel);
        }
        return this.table;
    }

    protected JComponent getBottomPane() {
        this.bottomPanel = new JPanel();
        return this.bottomPanel;
    }

    protected void seSplitPaneResizeWeight() {
        this.splitPane.setResizeWeight(0.65);
    }

    public JComponent initTopComponent() {
        JComponent topComp = this.getTopComponent();
        JScrollPane panel = new JScrollPane(topComp);
        panel.setBorder(new JScrollPaneBorder(Color.white));
        return panel;
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(this.getButtonBox());
        this.buttonPanel.add(Box.createGlue());
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(Box.createRigidArea(DEFAULT_BTNPANESIZE));
        this.add((Component)this.buttonPanel, "North");
        JComponent topComponent = this.initTopComponent();
        if (this.hasBottomPane) {
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBorder(EMPTY_BORDER);
            this.splitPane.setDividerSize(7);
            this.splitPane.setContinuousLayout(true);
            JPanel bottomJPanel = new JPanel(new BorderLayout());
            bottomJPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
            bottomJPanel.add((Component)this.getBottomPane(), "Center");
            this.splitPane.setBottomComponent(bottomJPanel);
            topComponent.setMinimumSize(new Dimension(100, 100));
            this.splitPane.setTopComponent(topComponent);
            topComponent.setPreferredSize(DEFAULT_TOPTABLESIZE);
            this.seSplitPaneResizeWeight();
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)topComponent, "Center");
        }
        Component comp = Box.createVerticalStrut(15);
        this.setBackground(Color.WHITE);
        this.add(comp, "South");
    }

    protected void initListeners() {
    }

    public void addButton(ToolAction ... toolActions) {
        if (null == toolActions) {
            return;
        }
        for (ToolAction action : toolActions) {
            this.actionList.add(action);
            JComponent componet = null;
            Object isToolHyperLinkLabel = action.getValue("isToolHyperLinkLabel");
            if (null != isToolHyperLinkLabel) {
                String lblName = action.getValue("Name").toString();
                ToolHyperLinkLabel lbl = new ToolHyperLinkLabel(lblName);
                lbl.addClickListener(new ToolHyperLinkLabelListener(action));
                Object icon = action.getValue("Icon");
                if (icon != null && icon instanceof ImageIcon) {
                    lbl.setIcon((ImageIcon)icon);
                }
                componet = lbl;
            } else {
                JButton btn = this.createButton(action);
                this.btnList.add(btn);
                componet = btn;
            }
            this.buttonBox.add(componet);
            this.buttonBox.add(Box.createHorizontalStrut(4));
        }
    }

    public void addButton(ToolAction toolAction, boolean isArrowVisiable) {
        if (null == toolAction) {
            return;
        }
        this.actionList.add(toolAction);
        RolloverButton button = new RolloverButton(toolAction, isArrowVisiable);
        this.btnList.add(button);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(4));
    }

    public void addGroupButton(String groupName, List<ToolAction> actions) {
        RolloverButton btn = new RolloverButton(groupName, actions);
        this.buttonBox.add(btn);
        this.buttonBox.add(Box.createHorizontalStrut(12));
        for (ToolAction act : actions) {
            this.actionList.add(act);
        }
    }

    public List<JButton> getBtnList() {
        return this.btnList;
    }

    public JPanel getBtnPanel() {
        return this.buttonPanel;
    }

    public boolean isRolloverButton() {
        return this.isRolloverButton;
    }

    public void setRolloverButton(boolean isRollover) {
        this.isRolloverButton = isRollover;
    }

    private JButton createButton(ToolAction action) {
        JButton button = null;
        if (this.isRolloverButton()) {
            button = new RolloverButton(action);
        } else {
            Object icon;
            button = new JButton(action);
            button.setEnabled(action.isAvailable());
            if (null != action.getValue("Name")) {
                this.setToolTipText(action.getValue("Name").toString());
            }
            if ((icon = action.getValue("Icon")) != null && icon instanceof ImageIcon) {
                button.setIcon((ImageIcon)icon);
            }
        }
        return button;
    }

    public void setButtonPanelBackground(Color clr) {
        this.buttonPanel.setBackground(clr);
    }

    public static class JScrollPaneBorder
    extends LineBorder {
        private static final long serialVersionUID = 1L;

        public JScrollPaneBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component component, Graphics grap, int xValue, int yValue, int width, int height) {
            Color oldColor = grap.getColor();
            JScrollPane sp = null;
            if (!(component instanceof JScrollPane)) {
                return;
            }
            sp = (JScrollPane)component;
            if (sp.getViewport().getView() == null) {
                throw new NullPointerException("sp.getViewport().getView()");
            }
            grap.setColor(Color.WHITE);
            grap.fillRect(xValue, yValue, width - 1, 1);
            grap.fillRect(xValue, yValue + 1, 1, height);
            grap.setColor(oldColor);
        }
    }

    private static class ToolHyperLinkLabelListener
    implements ToolHyperLinkLabel.ClickListener {
        private static final long serialVersionUID = -7634099898426736566L;
        private ToolAction action;

        ToolHyperLinkLabelListener(ToolAction ta) {
            this.action = ta;
        }

        @Override
        public void clickLink(MouseEvent me) {
            this.action.actionPerformed(null);
        }
    }
}

