/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.connection.support.IDefineDateSelectAction;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DateChooserDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateChooseField
extends JTextField {
    public static final int CHOOSE_TYPE_DATE = 0;
    public static final int CHOOSE_TYPE_TIME = 1;
    public static final int CHOOSE_TYPE_DATETIME = 2;
    private static final ImageIcon CAL_ICON = ResourceUtil.getImage("calender.gif");
    private static final long serialVersionUID = -6059832561009845524L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DateChooseField.class);
    private JButton button;
    private Date currentTime = null;
    private transient IDefineDateSelectAction action = null;

    public DateChooseField() {
        this.setEditable(false);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(this.initUI(), "Center");
        this.setBackground(Color.WHITE);
    }

    public DateChooseField(int chooseModel) {
        this();
        this.setDateChooseModel(chooseModel);
    }

    public void initDate(Date date, String model) {
        this.currentTime = (Date)date.clone();
        this.setText(StringUtils.formatDate(this.currentTime, model));
    }

    private Component initUI() {
        this.button = new JButton();
        this.button.setRolloverIcon(CAL_ICON);
        this.button.setIcon(CAL_ICON);
        this.button.setPressedIcon(CAL_ICON);
        this.button.setSelectedIcon(CAL_ICON);
        this.button.setRolloverSelectedIcon(CAL_ICON);
        UiMethod.setComponentSize(new Dimension(CAL_ICON.getIconWidth(), CAL_ICON.getIconHeight()), this.button);
        this.addButtonListenner();
        return UiMethod.buildCompsRight(this.button);
    }

    private void addButtonListenner() {
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DateChooseField.this.button.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DateChooseField.this.button.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setDateChooseModel(int model) {
        this.button.addActionListener(new DateChooselistener(model, this, this.currentTime));
    }

    public void setAction(IDefineDateSelectAction action) {
        this.action = action;
    }

    private class DateChooselistener
    implements ActionListener {
        private int chooseType = 2;
        private JTextField parentFiled;
        private int model;
        private Date currentTime = null;

        public DateChooselistener(int timeType, JTextField field, Date currentTime) {
            this.parentFiled = field;
            this.model = timeType;
            this.currentTime = currentTime;
            if (timeType != 0 && timeType != 1 && timeType != 2) {
                timeType = 2;
            }
            this.chooseType = timeType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.parentFiled.isEnabled()) {
                return;
            }
            Date selectDate = this.chooseDate();
            if (null == selectDate) {
                return;
            }
            String dateStr = this.formateDate(selectDate);
            DateChooseField.this.setText(dateStr);
            if (null != DateChooseField.this.action) {
                DateChooseField.this.action.actionPerformed();
            }
        }

        private String formateDate(Date selectDate) {
            switch (this.chooseType) {
                case 2: {
                    return StringUtils.formatDate(selectDate, "yyyy-MM-dd HH:mm:ss");
                }
                case 0: {
                    return StringUtils.formatDate(selectDate, "yyyy-MM-dd");
                }
                case 1: {
                    return StringUtils.formatDate(selectDate, "HH:mm:ss");
                }
            }
            return "";
        }

        private Date chooseDate() {
            DateChooserDialog dateChooserDialog;
            JDialog parentDialog = this.getParentJDialog();
            if (parentDialog == null) {
                LOGGER.error("the DateChooseField`s parent is not JDialog!!!!");
                return new Date();
            }
            if ("".equals(this.parentFiled.getText())) {
                dateChooserDialog = new DateChooserDialog(parentDialog, null, null, null, this.model);
            } else {
                this.currentTime = new Date(StringUtils.parseDate2Long(this.parentFiled.getText(), this.getFormat(this.model)));
                dateChooserDialog = new DateChooserDialog(parentDialog, null, null, this.currentTime, this.model);
            }
            SwingUtil.setCloseWhenEscKeyPressed((JDialog)dateChooserDialog);
            SwingUtil.cancelEscKeyToClose((JDialog)dateChooserDialog);
            dateChooserDialog.setVisible(true);
            dateChooserDialog.toFront();
            return dateChooserDialog.getDate();
        }

        private String getFormat(int timeModel) {
            String format = "";
            switch (timeModel) {
                case 1: {
                    format = "HH:mm:ss";
                    break;
                }
                case 2: {
                    format = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                case 0: {
                    format = "yyyy-MM-dd";
                    break;
                }
            }
            return format;
        }

        private JDialog getParentJDialog() {
            Container parent = DateChooseField.this;
            do {
                if (!((parent = parent.getParent()) instanceof JDialog)) continue;
                return (JDialog)parent;
            } while (parent != null);
            return null;
        }
    }
}

