/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.ui.component.FuncItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ToolRightPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int FUNCITME_LEFT_GAP = 17;
    private static final int FUNCITME_TOP_GAP = 19;
    private List<FuncItem> funcItems = new ArrayList<FuncItem>();
    private JPanel panel;

    public ToolRightPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
    }

    public synchronized FuncItem getFunItemByToolId(String toolId) {
        for (FuncItem funcItem : this.funcItems) {
            String id = funcItem.getToolId();
            if (!id.equals(toolId)) continue;
            return funcItem;
        }
        return null;
    }

    public synchronized void addFuncItems(List<FuncItem> funItems) {
        ArrayList<FuncItem> exist = new ArrayList<FuncItem>();
        for (FuncItem item : funItems) {
            if (!this.funcItems.contains(item)) continue;
            exist.add(item);
        }
        funItems.removeAll(exist);
        this.funcItems.addAll(funItems);
        this.showFuncItems();
    }

    public synchronized boolean isEmpty() {
        return this.funcItems.isEmpty();
    }

    public synchronized void removeFuncItems(List<FuncItem> funItems) {
        if (null == funItems || funItems.isEmpty()) {
            return;
        }
        ArrayList<FuncItem> exist = new ArrayList<FuncItem>();
        for (FuncItem item : funItems) {
            if (!this.funcItems.contains(item)) continue;
            exist.add(item);
        }
        this.funcItems.removeAll(exist);
        this.showFuncItems();
    }

    public synchronized void showFuncItems() {
        if (null != this.panel) {
            this.remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(19, 17, 0, 17);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        for (FuncItem item : this.funcItems) {
            this.panel.add(this.relayoutItem(item), gbc);
            ++gbc.gridy;
            gbc.insets.top = 0;
        }
        this.setBorder(new EmptyBorder(3, 3, 5, 0));
        this.add((Component)this.panel, "North");
    }

    private Component relayoutItem(FuncItem item) {
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new GridLayout(1, 2));
        newPanel.add(item);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        newPanel.add(jPanel);
        newPanel.setOpaque(false);
        return newPanel;
    }

    @Override
    public String getUIClassID() {
        return "ToolRightPanelUI";
    }
}

