/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.checkboxtree;

import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class CheckTreeNodeRenderer
extends CheckLabelPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = -4607698747503207061L;
    private boolean hasCheckBox = true;
    private boolean isHook;
    private boolean checkBoxHook;

    public CheckTreeNodeRenderer(boolean hasCheckBox) {
        super(hasCheckBox);
        this.hasCheckBox = hasCheckBox;
        this.isHook = false;
        this.checkBoxHook = false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        CheckLabelPanel panel = new CheckLabelPanel(this.hasCheckBox);
        CheckTreeNode checkTreeNode = (CheckTreeNode)value;
        panel.setHasCheckBox(checkTreeNode.isHasCheckBox());
        panel.setEnabled(tree.isEnabled());
        if (panel.getCheckBox() != null) {
            panel.getCheckBox().setSelected(checkTreeNode.isSelected());
            panel.getCheckBox().setPartialSelected(checkTreeNode.isPartSelect());
            panel.getCheckBox().setEnabled(((CheckTreeNode)value).isCheckEnable());
            if (this.checkBoxHook) {
                panel.getCheckBox().setOpaque(true);
                panel.getCheckBox().setEnabled(this.isHook);
            } else {
                panel.getCheckBox().setBackground(null);
                panel.getCheckBox().setEnabled(true);
            }
        }
        if (panel.getTreeLabel() != null) {
            panel.getTreeLabel().setFont(tree.getFont());
            panel.getTreeLabel().setText(stringValue);
            panel.getTreeLabel().setSelected(checkTreeNode.isHilight() || hasFocus);
            if (this.checkBoxHook) {
                panel.getTreeLabel().setOpaque(true);
            } else {
                panel.getTreeLabel().setOpaque(false);
            }
        }
        return panel;
    }
}

