/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.treetable;

import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;

public class TreeTableModel
extends AbstractTableModel {
    public static final int NAME_COLUMN = 0;
    private transient List<RowItem> allItemList;
    private transient List<RowItem> publishedItemList;
    private List<ITreeTableRow<?, ?>> tableRows = new ArrayList();
    private String[] tableColumns = null;

    public TreeTableModel(String[] tableColumns) {
        String[] tempTableColumns = (String[])tableColumns.clone();
        this.tableColumns = tempTableColumns;
        this.allItemList = new ArrayList<RowItem>();
        this.publishedItemList = new ArrayList<RowItem>();
    }

    public List<RowItem> getAllItemList() {
        return this.allItemList;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumns[column];
    }

    public void setRows(ITreeTableRow<?, ?> ... newRows) {
        this.setRows(true, newRows);
    }

    public void setRows(boolean showExpandAndCollapseIcon, ITreeTableRow<?, ?> ... newRows) {
        this.tableRows.clear();
        this.tableRows.addAll(Arrays.asList(newRows));
        this.buildModel(showExpandAndCollapseIcon);
    }

    public List<ITreeTableRow<?, ?>> getAllTableRows() {
        ArrayList allRowList = new ArrayList();
        for (RowItem item : this.allItemList) {
            allRowList.add(item.getTableRow());
        }
        return allRowList;
    }

    @Deprecated
    public void deleteRow(ITreeTableRow<?, ?> row) {
        this.deleteTableRow(row);
        this.allItemList.clear();
        this.addRowListToModel(this.tableRows, null);
        this.updateVisiableRows(true);
    }

    private void deleteTableRow(ITreeTableRow<?, ?> row) {
        ITreeTableRow<?, ?> parentRow = row.getParentRow();
        if (null == parentRow) {
            this.tableRows.remove(row);
        } else {
            for (ITreeTableRow<?, ?> tableRow : this.tableRows) {
                this.removeSubRow(row, tableRow);
            }
        }
    }

    private void removeSubRow(ITreeTableRow<?, ?> needRemoveRow, ITreeTableRow<?, ?> rootTableRow) {
        if (needRemoveRow.getParentRow().equals(rootTableRow)) {
            rootTableRow.getSubRowList().remove(needRemoveRow);
            return;
        }
        rootTableRow.getSubRowList().forEach(middleRow -> this.removeSubRow(needRemoveRow, (ITreeTableRow<?, ?>)middleRow));
    }

    public void deleteRowByUpdate(ITreeTableRow<?, ?> row) {
        this.deleteRowByUpdate(row, true);
    }

    public void deleteRowByUpdate(ITreeTableRow<?, ?> row, boolean showExpandAndCollapseIcon) {
        this.deleteTableRow(row);
        this.updateTabelView(showExpandAndCollapseIcon);
    }

    public void updateTabelView() {
        this.updateTabelView(true);
    }

    public void updateTabelView(boolean showExpandAndCollapseIcon) {
        Map<Object, Boolean> rowAndVisibleMap = this.allItemList.stream().collect(Collectors.toMap(rowItem -> rowItem.getTableRow().getUserObject(), rowItem -> rowItem.isVisible(), (oldRow, newRow) -> newRow));
        this.allItemList.clear();
        this.addRowListToModel(this.tableRows, null, showExpandAndCollapseIcon);
        this.allItemList.stream().filter(rowItem -> rowAndVisibleMap.containsKey(rowItem.getTableRow().getUserObject())).forEach(rowItem -> rowItem.setVisible((Boolean)rowAndVisibleMap.get(rowItem.getTableRow().getUserObject())));
        this.publishedItemList.clear();
        this.allItemList.stream().filter(rowItem -> rowItem.getParent() == null || rowItem.getParent().isVisible()).forEach(rowItem -> this.publishedItemList.add((RowItem)rowItem));
        this.fireTableDataChanged();
    }

    public void updateRow(ITreeTableRow<?, ?> newRow) {
        ITreeTableRow<?, ?> parentRow = newRow.getParentRow();
        if (null != parentRow) {
            this.updateRow(parentRow, newRow);
        } else {
            for (ITreeTableRow<?, ?> parent : this.tableRows) {
                this.updateRow(parent, newRow);
            }
        }
        int currentRow = this.getIndexInItemList(this.allItemList, newRow);
        if (currentRow < 0) {
            return;
        }
        RowItem rowItem = this.allItemList.get(currentRow);
        rowItem.setTableRow(newRow);
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    private void updateRow(ITreeTableRow<?, ?> parentRow, ITreeTableRow<?, ?> childRow) {
        int index = parentRow.getSubRowList().indexOf(childRow);
        if (-1 != index) {
            parentRow.getSubRowList().set(index, childRow);
        }
    }

    private int getIndexInItemList(List<RowItem> itemList, ITreeTableRow<?, ?> row) {
        for (RowItem item : itemList) {
            if (!item.getTableRow().equals(row)) continue;
            return itemList.indexOf(item);
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.length;
    }

    @Override
    public int getRowCount() {
        return this.publishedItemList.size();
    }

    public int getAllRowCount() {
        return this.allItemList.size();
    }

    public RowItem getRowElement(int rowIndex) {
        if (-1 == rowIndex) {
            return null;
        }
        if (this.publishedItemList.size() <= rowIndex) {
            return null;
        }
        return this.publishedItemList.get(rowIndex);
    }

    public ITreeTableRow<?, ?> getRow(int rowIndex) {
        return this.publishedItemList.get(rowIndex).getTableRow();
    }

    public int getRowItemIndex(RowItem rowItem) {
        return this.publishedItemList.indexOf(rowItem);
    }

    public int getRowIndex(Object identifier) {
        if (null == this.allItemList) {
            return -1;
        }
        for (RowItem item : this.allItemList) {
            if (null == item.getTableRow() || null == item.getTableRow().getIdentifier() || !item.getTableRow().getIdentifier().equals(identifier)) continue;
            return this.allItemList.indexOf(item);
        }
        return -1;
    }

    public RowItem getRowItem(Object identifier) {
        if (null == this.allItemList) {
            return null;
        }
        for (RowItem item : this.allItemList) {
            if (null == item.getTableRow() || null == item.getTableRow().getIdentifier() || !item.getTableRow().getIdentifier().equals(identifier)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RowItem item = this.getRowElement(rowIndex);
        if (null == item) {
            return null;
        }
        if (0 == columnIndex) {
            return item;
        }
        return item.getTableRow().getValue(columnIndex);
    }

    protected void updateVisiableRows(boolean isUpdate) {
        this.publishedItemList.clear();
        for (RowItem item : this.allItemList) {
            RowItem parent = item.getParent();
            if (parent != null && !parent.isVisible() && (parent.parent != null || !isUpdate)) continue;
            this.publishedItemList.add(item);
        }
        this.fireTableDataChanged();
    }

    private void buildModel(boolean showExpandAndCollapseIcon) {
        this.allItemList.clear();
        this.addRowListToModel(this.tableRows, null, showExpandAndCollapseIcon);
        for (RowItem item : this.allItemList) {
            item.toggle();
        }
        this.fireTableDataChanged();
    }

    private void addRowListToModel(List<?> rowList, RowItem parent) {
        for (ITreeTableRow row : rowList) {
            RowItem rowItem = new RowItem(row, parent);
            this.allItemList.add(rowItem);
            List subRows = row.getSubRowList();
            this.addRowListToModel(subRows, rowItem);
        }
    }

    private void addRowListToModel(List<?> rowList, RowItem parent, boolean showExpandAndCollapseIcon) {
        for (ITreeTableRow row : rowList) {
            RowItem rowItem = showExpandAndCollapseIcon || parent == null ? new RowItem(row, parent) : new RowItem(row, parent, showExpandAndCollapseIcon);
            this.allItemList.add(rowItem);
            List subRows = row.getSubRowList();
            this.addRowListToModel(subRows, rowItem, showExpandAndCollapseIcon);
        }
    }

    public void addOneRow(ITreeTableRow<?, ?> tableRow) {
        this.addOneRow(tableRow, true);
    }

    public void addOneRow(ITreeTableRow<?, ?> tableRow, boolean showExpandAndCollapseIcon) {
        this.tableRows.add(tableRow);
        RowItem rowItem = new RowItem(tableRow, null);
        this.allItemList.add(rowItem);
        List<ITreeTableRow<?, ?>> subRows = tableRow.getSubRowList();
        this.addRowListToModel(subRows, rowItem, showExpandAndCollapseIcon);
        this.updateTabelView(showExpandAndCollapseIcon);
    }

    private void readObject(ObjectInputStream inStream) {
    }

    public class RowItem {
        private ITreeTableRow<?, ?> tableRow;
        private RowItem parent;
        private boolean showExpandAndCollapseIcon = true;
        private boolean visible = true;
        private SelectType seletType = SelectType.UNSELECT;
        private JComponent checkBox;

        public RowItem(ITreeTableRow<?, ?> row, RowItem parent) {
            this.tableRow = row;
            this.parent = parent;
            boolean bl = this.visible = row == null;
            if (null != row) {
                List<ITreeTableRow<?, ?>> subRows = row.getSubRowList();
                this.showExpandAndCollapseIcon = !subRows.isEmpty();
            }
        }

        public RowItem(ITreeTableRow<?, ?> row, RowItem parent, boolean showExpandAndCollapseIcon) {
            this.tableRow = row;
            this.parent = parent;
            this.visible = row == null;
            this.showExpandAndCollapseIcon = showExpandAndCollapseIcon;
        }

        public void setTableRow(ITreeTableRow<?, ?> row) {
            this.tableRow = row;
        }

        public ITreeTableRow<?, ?> getTableRow() {
            return this.tableRow;
        }

        public RowItem getParent() {
            return this.parent;
        }

        public int getDepth() {
            int depth = 0;
            if (this.parent != null) {
                depth = this.parent.getDepth();
                ++depth;
            }
            return depth;
        }

        public void reverse() {
            if (SelectType.SELECT == this.seletType) {
                this.seletType = SelectType.UNSELECT;
            } else if (SelectType.UNSELECT == this.seletType) {
                this.seletType = SelectType.SELECT;
            }
        }

        public void setSelectType(SelectType type) {
            this.seletType = type;
        }

        public SelectType getSelectType() {
            return this.seletType;
        }

        public boolean hasExpandAndCollapseIcon() {
            return this.showExpandAndCollapseIcon;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public void toggle() {
            if (this.hasExpandAndCollapseIcon()) {
                this.visible = !this.visible;
                TreeTableModel.this.updateVisiableRows(false);
            }
        }

        public boolean isVisible() {
            return !(this.parent != null && !this.parent.isVisible() || this.showExpandAndCollapseIcon && !this.visible);
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public String toString() {
            if (null != this.tableRow && null != this.tableRow.getValue(0)) {
                return this.tableRow.getValue(0).toString();
            }
            return "";
        }

        public boolean isCheckBoxVisible() {
            return this.checkBox != null && this.checkBox.isVisible();
        }

        public void setCheckBox(JComponent checkBox) {
            this.checkBox = checkBox;
        }
    }

    public static enum SelectType {
        HALF,
        UNSELECT,
        SELECT;

    }
}

