/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.dialogs;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PasswordConfirmDialog
extends PublicDialog {
    private static final long serialVersionUID = -6288716217430293719L;
    private ImageIcon qestionImg = ResourceUtil.getImage("important.png");
    private static final int DIALOG_WIDTH = 510;
    private static final int DIALOG_HEIGHT = 280;
    private JTextField usernameFiled;
    private JPasswordField passwordFiled;
    private JCheckBox checkBox = null;
    private DevNode devNode = null;
    private ICallback callback = null;
    private String title = ResourceUtil.getString("password.comfirm.dlg.title");
    private String warnInfo = "";
    private String confirmInfo = ResourceUtil.getString("password.comfirm.dlg.checkbox");

    public PasswordConfirmDialog(DevNode devNode, ICallback callback) {
        this.devNode = devNode;
        this.callback = callback;
    }

    public void showDialog() {
        this.initUI();
        this.setModal(true);
        this.setVisible(true);
    }

    private void initUI() {
        this.setModal(true);
        this.setTitle(this.title);
        this.checkBox = new JCheckBox(this.confirmInfo);
        this.getOkBtn().setEnabled(false);
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add(this.craeteUI(), "North");
        this.getContentPanel().add((Component)UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.checkBox}), "South");
        UiMethod.setComponentSize(new Dimension(510, 280), this);
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.setCompName();
    }

    private Component craeteUI() {
        JTextArea tipsText = UiMethod.createJTextArea(this.warnInfo);
        JLabel usernameLabel = new JLabel(ResourceUtil.getString("password.comfirm.dlg.username"));
        JLabel passwordLabel = new JLabel(ResourceUtil.getString("password.comfirm.dlg.password"));
        this.usernameFiled = IsmTextField.getNameTextField((String)".*", (String)this.devNode.getLoginUser().getUserName(), (int)60, (int)0);
        this.usernameFiled.setEditable(false);
        this.passwordFiled = UiMethod.getPasswordFiled();
        UiMethod.setComponentSameMaxWidthSize(usernameLabel, passwordLabel);
        UiMethod.setComponentSize(new Dimension(150, 21), this.usernameFiled, this.passwordFiled);
        Box userCom = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), usernameLabel, this.usernameFiled, Box.createHorizontalStrut(0)});
        Box pwdCom = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), passwordLabel, this.passwordFiled, Box.createHorizontalStrut(0)});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{Box.createHorizontalStrut(0), new JLabel(this.qestionImg), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), tipsText, userCom, pwdCom}), Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)});
    }

    private void initListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String username = PasswordConfirmDialog.this.usernameFiled.getText();
                String password = String.valueOf(PasswordConfirmDialog.this.passwordFiled.getPassword());
                if (StringUtils.hasNULLStr(username, password)) {
                    DialogUtils.showInfoDialog((JDialog)PasswordConfirmDialog.this, (String)ResourceUtil.getString("password.comfirm.dlg.password.cannot.null"));
                    return;
                }
                String actualPassword = PasswordConfirmDialog.this.devNode.getLoginUser().getPassword();
                if (!password.equals(actualPassword)) {
                    DialogUtils.showInfoDialog((JDialog)PasswordConfirmDialog.this, (String)ResourceUtil.getString("password.comfirm.dlg.password.not.corrent"));
                    return;
                }
                PasswordConfirmDialog.this.dispose();
                PasswordConfirmDialog.this.callback.confirm();
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PasswordConfirmDialog.this.checkBox.isSelected()) {
                    PasswordConfirmDialog.this.getOkBtn().setEnabled(true);
                } else {
                    PasswordConfirmDialog.this.getOkBtn().setEnabled(false);
                }
            }
        });
    }

    private void setCompName() {
        this.checkBox.setName("_JCheckBox_checkBox");
    }

    public void setDialogTitle(String title) {
        this.title = title;
    }

    public void setWarnInfo(String warnInfo) {
        this.warnInfo = warnInfo;
    }

    public void setConfirmInfo(String confirmInfo) {
        this.confirmInfo = confirmInfo;
    }

    public static interface ICallback {
        public void confirm();
    }
}

