/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import java.nio.charset.Charset;
import java.util.Arrays;

public final class BitUtils {
    private BitUtils() {
    }

    public static byte[] short2ByteArray(short val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8)};
        return b;
    }

    public static byte[] float2ByteArray(float val) {
        byte[] b = new byte[4];
        int i = Float.floatToIntBits(val);
        b[0] = (byte)(i >>> 0);
        b[1] = (byte)(i >>> 8);
        b[2] = (byte)(i >>> 16);
        b[3] = (byte)(i >>> 24);
        return b;
    }

    public static byte[] long2ByteArray(long val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8), (byte)(val >>> 16), (byte)(val >>> 24), (byte)(val >>> 32), (byte)(val >>> 40), (byte)(val >>> 48), (byte)(val >>> 56)};
        return b;
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8));
    }

    public static int getShortToInt(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
    }

    public static byte[] int2ByteArray(int val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8), (byte)(val >>> 16), (byte)(val >>> 24)};
        return b;
    }

    public static byte[] stringToByteArray(String str, int maxStringLength) {
        if (str == null) {
            return new byte[maxStringLength];
        }
        return Arrays.copyOf(str.getBytes(Charset.forName("UTF-8")), maxStringLength);
    }

    public static String byteArrayToString(byte[] b, int length, int offset) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (b[offset] != 0) {
                stringBuffer.append((char)b[offset]);
            }
            ++offset;
        }
        if (stringBuffer.length() == 0) {
            return "--";
        }
        return stringBuffer.toString();
    }

    public static String getString(byte[] data, int off, int length) {
        return BitUtils.byteArrayToString(data, length, off);
    }

    public static String getUnicodeString(byte[] data, int off, int length) {
        return new String(data, off, length, Charset.forName("UTF-8")).trim();
    }

    public static int bytesToInt(byte bytes) {
        int num = bytes & 0xFF;
        return num;
    }
}

