/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.lang.reflect.Field;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class CliResolverUtils {
    private static final String ARRT_SEP = ":";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CliResolverUtils.class);
    private static final String LINE_SEP_ERG = "^\\s*-+(\\s+-+)*\\s*$";
    private static final String LINE_ATTR_FIND_REGX = "\\s*-+\\s*";
    private static final char DONW_LINE = '_';
    private static final String LINE_SEP = "\r\n";
    private static final int SECOND_LINE = 1;
    private static final CharSequence UNSUPPORT_SIGN = "^";
    private static final String SUPER_ADMIN = "SUPER_ADMIN";
    private static final String SUPER_ADMIN_ROLEID = "1";
    private static final int TIMEOUT = 30;

    private CliResolverUtils() {
    }

    public static String getDeviceInfo(String cli, String name) {
        cli = Normalizer.normalize(cli, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("$[\\p{ASCII}&&[^:]]+:[\\p{ASCII}&&[^:]]+^", 10);
        Matcher matcher = pattern.matcher(cli);
        if (matcher.find() && !cli.contains("=============================")) {
            return CliResolverUtils.vertical(ARRT_SEP, cli, name);
        }
        if (!cli.contains("*******************************************")) {
            return CliResolverUtils.vertical("|", cli, name);
        }
        return CliResolverUtils.whiteSpaceResolve(cli, name);
    }

    private static String whiteSpaceResolve(String cli, String name) {
        String[] lines = cli.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] kval;
            String key;
            String line = lines[i].trim();
            if (!line.contains("    ") || !line.startsWith("*") || !(key = (kval = line.split("\\s{4,}"))[0]).contains(name) || kval.length < 2) continue;
            StringBuffer sbr = new StringBuffer(kval[1].trim());
            if (sbr.toString().endsWith("*")) {
                sbr.deleteCharAt(sbr.length() - 1);
            }
            return sbr.toString().trim();
        }
        return "";
    }

    public static String vertical(String separator, String cli, String name) {
        String[] lines = cli.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] kv;
            String key;
            String line = lines[i];
            if (!line.contains(separator) || !(key = (kv = line.split("\\" + separator))[0]).contains(name)) continue;
            return StringUtils.safetyGetStr(kv, 1);
        }
        return "";
    }

    public static String getInfoByNames(String cli, String ... names) {
        for (String name : names) {
            String ret = CliResolverUtils.getDeviceInfo(cli, name);
            if (StringUtils.isNULLStr(ret)) continue;
            return ret.trim();
        }
        return "";
    }

    public static String getSerialNumber(String cli) {
        if (cli.contains("===================") || cli.contains("**********************************") || cli.contains("---------------") && cli.contains("Serial Number") && cli.contains("Device Serial Number")) {
            return CliResolverUtils.getDeviceInfo(cli, "Serial Number");
        }
        return CliResolverUtils.getInfoByNames(cli, "Device Serial Number", "Serial Number", "SN");
    }

    public static List<Map<String, String>> resloveCliRetToList(String cliRtn) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (StringUtils.isNULLStr(cliRtn)) {
            return resultList;
        }
        String[] rntLines = cliRtn.split(LINE_SEP);
        int findLineIdx = CliResolverUtils.findSepLineIdx(rntLines);
        if (findLineIdx <= 0 || findLineIdx > rntLines.length - 1) {
            return resultList;
        }
        List<Pair> borderList = CliResolverUtils.getFieldPairList(rntLines, findLineIdx);
        List<String> keyList = CliResolverUtils.getAttrKeyList(rntLines, findLineIdx, borderList);
        CliResolverUtils.resloveToResult(resultList, rntLines, findLineIdx, borderList, keyList);
        return resultList;
    }

    public static List<Map<String, String>> resloveVerticalCliRetToList(String cliRtn) {
        String[] blockRets;
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (StringUtils.isNULLStr(cliRtn)) {
            return resultList;
        }
        String[] lines = cliRtn.split(LINE_SEP);
        String sepLine = "--------";
        Pattern findHeadReg = Pattern.compile(LINE_SEP_ERG);
        for (String line : lines) {
            Matcher mache = findHeadReg.matcher(line);
            if (!mache.matches()) continue;
            sepLine = line;
        }
        for (String blockRet : blockRets = cliRtn.split(sepLine)) {
            HashMap<String, String> recordMap = new HashMap<String, String>();
            CliResolverUtils.resloveAttribute(blockRet, recordMap);
            resultList.add(recordMap);
        }
        return resultList;
    }

    public static <T> List<T> resloveAndMapCliRetToList(String cliRtn, Class<T> rmapEntityClass) {
        List<Map<String, String>> resultList = CliResolverUtils.resloveCliRetToList(cliRtn);
        T instance = null;
        List objectFileds = ReflectionUtils.getFieldOfClass(rmapEntityClass);
        ArrayList<T> results = new ArrayList<T>();
        for (Map<String, String> recordMap : resultList) {
            instance = CliResolverUtils.newInstance(rmapEntityClass);
            for (Field field : objectFileds) {
                FieldInfo fi = field.getAnnotation(FieldInfo.class);
                if (fi == null) continue;
                int appearIndex = fi.columnAppearIdx();
                String[] mappingNames = fi.mappingName().split(",");
                CliResolverUtils.getAndSetFiledVal(instance, recordMap, field, appearIndex, mappingNames);
            }
            results.add(instance);
        }
        return results;
    }

    public static boolean isCLIResultInValid(String cliResult) {
        String[] lines = cliResult.split(LINE_SEP);
        String secondLine = StringUtils.safetyGetStr(lines, 1);
        return cliResult.contains("command not found") || cliResult.contains("not exist") || cliResult.contains("not supported") || cliResult.contains("command name is invalid") || cliResult.contains("No such file or directory") || secondLine.contains("cat: ") || secondLine.equals(UNSUPPORT_SIGN);
    }

    private static <T> void getAndSetFiledVal(T instance, Map<String, String> recordMap, Field field, int appearIndex, String[] mappingNames) {
        for (String mName : mappingNames) {
            String mappingName = appearIndex > -1 ? CliResolverUtils.buildNewKey(mName, appearIndex) : mName;
            field.setAccessible(true);
            try {
                if (recordMap.get(mappingName) == null) continue;
                field.set(instance, recordMap.get(mappingName));
                break;
            }
            catch (Exception e) {
                LOGGER.error("error occured while set val", e);
            }
        }
    }

    public static <T> T mapCliRtnToEntity(String cliRet, Class<T> clazz) {
        if (StringUtils.isNULLStr(cliRet)) {
            return null;
        }
        HashMap<String, String> recordMap = new HashMap<String, String>();
        CliResolverUtils.resloveAttribute(cliRet, recordMap);
        List objectFileds = ReflectionUtils.getFieldOfClass(clazz);
        return CliResolverUtils.resloveToEntity(clazz, recordMap, objectFileds);
    }

    private static <T> T resloveToEntity(Class<T> clazz, Map<String, String> recordMap, List<Field> objectFileds) {
        T instance = CliResolverUtils.newInstance(clazz);
        for (Field field : objectFileds) {
            FieldInfo fi = field.getAnnotation(FieldInfo.class);
            if (fi == null) continue;
            int appearIndex = fi.columnAppearIdx();
            String mappingName = appearIndex > -1 ? CliResolverUtils.buildNewKey(fi.mappingName(), appearIndex) : fi.mappingName();
            field.setAccessible(true);
            try {
                String val = recordMap.get(mappingName);
                if (val == null) continue;
                field.set(instance, val);
            }
            catch (Exception e) {
                LOGGER.error("error occured while set val", e);
            }
        }
        return instance;
    }

    private static void resloveAttribute(String cliRet, Map<String, String> recordMap) {
        String[] lines;
        for (String line : lines = cliRet.split(LINE_SEP)) {
            if (!line.contains(ARRT_SEP)) continue;
            String[] attrVal = line.split(ARRT_SEP);
            if (attrVal.length == 2) {
                recordMap.put(attrVal[0].trim(), attrVal[1].trim());
            }
            if (attrVal.length <= 2) continue;
            int idxOfSep = line.indexOf(ARRT_SEP.charAt(0));
            String key = line.substring(0, idxOfSep);
            String val = line.substring(idxOfSep + 1);
            recordMap.put(key.trim(), val.trim());
        }
    }

    private static String buildNewKey(String key, int appearIndex) {
        return key + '_' + appearIndex + '_';
    }

    private static <T> T newInstance(Class<T> rmapEntityClass) {
        T instance = null;
        try {
            instance = rmapEntityClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("exec new instance error!", e);
            throw new EncapsulatedRuntimeException("new instance error!", (Throwable)e);
        }
        return instance;
    }

    private static void resloveToResult(List<Map<String, String>> resultList, String[] rntLines, int findLineIdx, List<Pair> borderList, List<String> keyList) {
        String line;
        for (int i = findLineIdx + 1; i < rntLines.length && !(line = rntLines[i]).endsWith(":/>"); ++i) {
            resultList.add(CliResolverUtils.resloveLineToRecord(line, keyList, borderList));
        }
    }

    private static Map<String, String> resloveLineToRecord(String dataLine, List<String> keyList, List<Pair> borderList) {
        HashMap<String, String> recordMap = new HashMap<String, String>();
        int dataIdx = 0;
        for (Pair point : borderList) {
            int y = dataLine.length() < point.y ? dataLine.length() : point.y;
            String attrVal = dataLine.substring(point.x, y).trim();
            recordMap.put(keyList.get(dataIdx++), attrVal);
        }
        return recordMap;
    }

    private static List<Pair> getFieldPairList(String[] rntLines, int findLineIdx) {
        String sepLine = rntLines[findLineIdx];
        Pattern findKeyRegPtn = Pattern.compile(LINE_ATTR_FIND_REGX);
        Matcher matcher = findKeyRegPtn.matcher(sepLine);
        ArrayList<Pair> points = new ArrayList<Pair>();
        while (matcher.find()) {
            Pair p = new Pair(matcher.start(), matcher.end());
            points.add(p);
        }
        return points;
    }

    private static List<String> getAttrKeyList(String[] rntLines, int findLineIdx, List<Pair> borderList) {
        ArrayList<String> keyList = new ArrayList<String>();
        String headLine = rntLines[findLineIdx - 1];
        int attrKeyIdx = 0;
        for (Pair point : borderList) {
            String key = headLine.substring(point.x, point.y).trim();
            if (keyList.contains(key)) {
                key = key + CliResolverUtils.buildNewKey(key, attrKeyIdx++);
            }
            keyList.add(key);
        }
        return keyList;
    }

    private static int findSepLineIdx(String[] rntLines) {
        String line;
        Matcher mache;
        Pattern findHeadReg = Pattern.compile(LINE_SEP_ERG);
        int findLineIdx = 0;
        String[] stringArray = rntLines;
        int n = stringArray.length;
        for (int i = 0; i < n && !(mache = findHeadReg.matcher(line = stringArray[i])).matches(); ++i) {
            ++findLineIdx;
        }
        return findLineIdx;
    }

    public static int getRoleId(DevNode dev, ICliConnection con) throws ToolException {
        int pointRoleId = -1;
        String userName = dev.getLoginUser().getUserName();
        String cliResult = con.execCmdWithTimout("show user user_name=" + CliResolverUtils.changeUserName(userName), 30);
        List<Map<String, String>> resultList = CliResolverUtils.resloveCliRetToList(cliResult);
        if (!cliResult.contains("Role ID")) {
            return 1;
        }
        if (resultList.size() >= 1) {
            try {
                String roleID = resultList.get(0).get("Role ID");
                pointRoleId = roleID.equals("--") ? 1 : Integer.parseInt(roleID);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get Role id, details: " + e);
            }
        }
        return pointRoleId;
    }

    public static String changeUserName(String userName) {
        return userName.startsWith("domain/") ? userName.replace("domain/", "") : userName;
    }

    public static boolean checkUserRole(DevNode dev, ICliConnection con, int ... roleIds) {
        try {
            int pointRoleId = CliResolverUtils.getRoleId(dev, con);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Dev RoleID = " + pointRoleId);
            }
            for (int roleId : roleIds) {
                if (roleId != pointRoleId) continue;
                return true;
            }
        }
        catch (Exception toolException) {
            return true;
        }
        return false;
    }

    public static boolean checkSuperAdminUserRole(DevNode devNode) {
        ICliConnection sshConn = null;
        try {
            List<Map<String, String>> cliRetList;
            sshConn = SshConnectionManager.getSshConnection(devNode, null, true, false);
            String result = sshConn.execCmd("show user user_name=" + devNode.getLoginUser().getUserName());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("show user user_name:" + result);
            }
            if (!(cliRetList = CliResolverUtils.resloveCliRetToList(result)).isEmpty()) {
                Map<String, String> retMap = cliRetList.get(0);
                if (SUPER_ADMIN.equalsIgnoreCase(retMap.get("Level"))) {
                    return true;
                }
                return SUPER_ADMIN_ROLEID.equals(retMap.get("Role ID"));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("ssh connection error, get supper admin level error", e);
            return true;
        }
    }

    public static List<Map<String, String>> queryStorageRemoteSNInfo(ICliConnection con, String command) {
        ArrayList<Map<String, String>> hyperMetroDevList = new ArrayList<Map<String, String>>();
        try {
            String cliResult = con.execCmdWithTimout(command, 15);
            cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            if (CliResolverUtils.isCLIResultInValid(cliResult) || cliResult.contains("executed successfully")) {
                return hyperMetroDevList;
            }
            return CliResolverUtils.resloveCliRetToList(cliResult);
        }
        catch (Exception e) {
            LOGGER.error("query remote device info error!", e);
            return hyperMetroDevList;
        }
    }

    public static List<Map<String, String>> parseHorizontalTable(String record, List<String> tittleKeys, String separator) throws ToolException {
        try {
            List<String> lineList = Arrays.asList(record.split(LINE_SEP));
            String tittleLine = lineList.stream().filter(line -> CliResolverUtils.isContainsAllTittleKey(tittleKeys, line)).findFirst().orElse("");
            if (tittleLine.isEmpty()) {
                return Collections.emptyList();
            }
            int dataLength = tittleLine.split(separator).length;
            Map<String, Integer> keyIndexMap = CliResolverUtils.initTittleKeyIndexMap(tittleKeys, separator, tittleLine);
            ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
            lineList.stream().skip(lineList.indexOf(tittleLine) + 1).forEach(line -> {
                String[] data = line.split(separator);
                if (data.length <= tittleKeys.size() || data.length < dataLength) {
                    LOGGER.error("illegal data line: {}", line);
                    return;
                }
                HashMap dataMap = new HashMap();
                keyIndexMap.keySet().stream().forEach(key -> dataMap.put(key, data[(Integer)keyIndexMap.get(key)].trim()));
                dataList.add(dataMap);
            });
            return dataList;
        }
        catch (Exception e) {
            LOGGER.error("Parse record error for cmd.", e);
            throw new ToolException("Parse record error");
        }
    }

    private static boolean isContainsAllTittleKey(List<String> tittleKeys, String line) {
        return tittleKeys.stream().allMatch(key -> line.contains((CharSequence)key));
    }

    private static Map<String, Integer> initTittleKeyIndexMap(List<String> tittleKeys, String dataSeparator, String tittleLine) {
        HashMap<String, Integer> keyIndexMap = new HashMap<String, Integer>();
        String[] tittleData = tittleLine.split(dataSeparator);
        for (int i = 0; i < tittleData.length; ++i) {
            for (String tittleKey : tittleKeys) {
                if (!tittleData[i].trim().equals(tittleKey)) continue;
                keyIndexMap.put(tittleKey, i);
            }
        }
        return keyIndexMap;
    }

    public static String executeCli(ICliConnection ssh, String cmd, boolean needSpilt) throws ToolException {
        if (!ssh.isConnected() || StringUtils.isNULLStr(cmd)) {
            return "";
        }
        String record = ssh.execCmdWithTimout(cmd, 30);
        if (!CliResolverUtils.isCLIResultInValid(record = Normalizer.normalize(record, Normalizer.Form.NFKC))) {
            return needSpilt ? record.split(LINE_SEP)[1].trim() : record;
        }
        return "";
    }

    public static String executeNoLogCli(ICliConnection ssh, String cmd, boolean needSpilt) throws ToolException {
        if (!ssh.isConnected() || StringUtils.isNULLStr(cmd)) {
            return "";
        }
        String record = ssh.execCmdNoLogTimout(cmd, 30);
        if (!CliResolverUtils.isCLIResultInValid(record = Normalizer.normalize(record, Normalizer.Form.NFKC))) {
            return needSpilt ? record.split(LINE_SEP)[1].trim() : record;
        }
        return "";
    }

    public static String getCliInfoWithSeparator(String cli, String name, String separator) {
        String[] record;
        if (StringUtils.isNULLStr(cli) || StringUtils.isNULLStr(name)) {
            return "";
        }
        for (String tmpCli : record = cli.split(LINE_SEP)) {
            String ret = CliResolverUtils.vertical(separator, tmpCli, name);
            if (StringUtils.isNULLStr(ret)) continue;
            return ret;
        }
        return "";
    }

    private static class Pair {
        int x;
        int y;

        public Pair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

