/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.LoggerFactory;

public final class OemUtils {
    public static final String VERDER = "VENDER";

    private OemUtils() {
    }

    public static String getOEMString(String oemStrKey) {
        String oemString;
        ResourceBundle resource = ResourceBundle.getBundle("config.system_base");
        if (ResourceUtil.isOemSupported() && ResourceUtil.isOemKey(oemStrKey)) {
            return ResourceUtil.getString(oemStrKey + OemUtils.getVender().toLowerCase(Locale.ENGLISH));
        }
        try {
            oemString = resource.getString(oemStrKey + OemUtils.getVender().toLowerCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(OemUtils.class).error("", e);
            return "";
        }
        return oemString;
    }

    public static String getVender() {
        if (ApplicationContext.getInstance().isJunit()) {
            return "";
        }
        ResourceBundle resource = ResourceBundle.getBundle("config.system_base");
        String oem = resource.getString("toolbox.system.vender");
        return oem;
    }
}

