/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.constant.UiConstants;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class ToolBorderUtils {
    private static final int CONTENTPANELBORDERWIDTH = 5;

    public static void painRoundBorder(Graphics graphics, JComponent component, Color color) {
        int xCoordinates = 0;
        int yCoordinates = 0;
        int cWidth = component.getWidth();
        int cHeight = component.getHeight();
        Color oldColor = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(xCoordinates, yCoordinates + 1, 2, 1);
        graphics.fillRect(xCoordinates + 1, yCoordinates, 1, 2);
        graphics.fillRect(xCoordinates, yCoordinates + cHeight - 2, 2, 1);
        graphics.fillRect(xCoordinates + 1, yCoordinates + cHeight - 2, 1, 2);
        graphics.fillRect(xCoordinates + cWidth - 2, yCoordinates + cHeight - 2, 2, 1);
        graphics.fillRect(xCoordinates + cWidth - 2, yCoordinates + cHeight - 2, 1, 2);
        graphics.fillRect(xCoordinates + cWidth - 2, yCoordinates + 1, 2, 1);
        graphics.fillRect(xCoordinates + cWidth - 2, yCoordinates, 1, 2);
        graphics.setColor(oldColor);
    }

    public static Border getSplitPaneDividerBorder() {
        return new ToolSplitPaneDividerBorder();
    }

    public static LeftPanelBorder createLeftPanelBorder() {
        return new LeftPanelBorder();
    }

    public static ContentPanelBorder createContentPanelBorder() {
        return new ContentPanelBorder();
    }

    private static class LeftPanelBorder
    implements Border {
        private LeftPanelBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(3, 0, 0, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xCoordinates, int yCoordinates, int width, int height) {
            Color oldColor = graphics.getColor();
            graphics.setColor(UiConstants.INNERBORDERCOLOR);
            graphics.fillRect(xCoordinates, yCoordinates, width, yCoordinates + 3);
            graphics.fillRect(xCoordinates + width - 3, yCoordinates, xCoordinates + width, yCoordinates + height);
            graphics.setColor(oldColor);
        }
    }

    private static class ContentPanelBorder
    implements Border {
        private ContentPanelBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xCoordinates, int yCoordinates, int width, int height) {
            Color oldColor = graphics.getColor();
            graphics.setColor(UiConstants.INNERBORDERCOLOR);
            graphics.fillRect(xCoordinates, yCoordinates, width, yCoordinates + 5);
            graphics.fillRect(xCoordinates, yCoordinates, xCoordinates + 5, height);
            graphics.fillRect(xCoordinates, yCoordinates + height - 5, xCoordinates + width, yCoordinates + height);
            graphics.fillRect(xCoordinates + width - 5, yCoordinates, xCoordinates + width, yCoordinates + height);
            graphics.setColor(oldColor);
        }
    }

    public static class ToolSplitPaneDividerBorder
    extends IsmBorders.SplitPaneDividerBorder {
        public void paintBorder(Component comp, Graphics grap, int xCoordinates, int yCoordinates, int width, int height) {
            Color highlight = UIManager.getColor("SplitPane.borderColor");
            Color shadow = UIManager.getColor("SplitPane.borderColor");
            JSplitPane splitPane = null;
            if (!(comp instanceof BasicSplitPaneDivider)) {
                return;
            }
            BasicSplitPaneDivider tmp = (BasicSplitPaneDivider)comp;
            splitPane = tmp.getBasicSplitPaneUI().getSplitPane();
            Dimension size = comp.getSize();
            Component child = splitPane.getLeftComponent();
            boolean borderCutted = UIManager.getBoolean("SplitPaneDivider.BorderCutted");
            grap.setColor(borderCutted ? highlight : comp.getBackground());
            grap.drawRect(xCoordinates, yCoordinates, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                if (child != null) {
                    grap.setColor(highlight);
                    grap.drawLine(0, 0, 0, size.height);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    grap.setColor(shadow);
                    grap.drawLine(size.width - 1, 0, size.width - 1, size.height);
                }
                if (UIManager.getBoolean("SplitPaneDivider.BorderCutted")) {
                    grap.setColor(UIManager.getColor("IsmArmorStyle.BaseColor"));
                    grap.fillRect(0, 0, width, 3);
                    grap.fillRect(0, height, width, height);
                }
            } else {
                if (child != null) {
                    grap.setColor(highlight);
                    grap.drawLine(0, 0, size.width, 0);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    grap.setColor(shadow);
                    grap.drawLine(0, size.height - 1, size.width, size.height - 1);
                }
            }
        }
    }
}

