/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class ToolUtils {
    private static final String CONFIG = "config";
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED";
    public static final String EXE_TIMEOUT = "TOOLKIT_EXE_CMD_FAILED";
    public static final String COMMAND_NOT_SUPPORT = "127";
    public static final String ERROR_CODE_UNKNOWN = "unknown";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolUtils.class);
    private static final String TEMPFILE_TEMP = "tempfile.temp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPathWriteAble(String path) {
        String tmpFile = path + File.separator + TEMPFILE_TEMP;
        try {
            File file = new File(tmpFile);
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ToolUtils.deleteFile(tmpFile);
        }
    }

    public static String handleCmdResult(String result, String originCmd, Map<String, String> echoValueMap) {
        return result;
    }

    private static boolean isCommandNotSupport(String result, String cmd) {
        if (StringUtils.isNULLStr((String)cmd)) {
            return false;
        }
        String[] cmdWords = cmd.split(" ");
        return result.trim().startsWith('\'' + cmdWords[0] + '\'');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileContent(String filePath) {
        String string;
        InputStream in = null;
        String charSet = null;
        try {
            if (filePath.startsWith(CONFIG)) {
                in = ToolUtils.class.getResourceAsStream(filePath);
                charSet = "UTF-8";
            }
            if (in == null) {
                in = new FileInputStream(new File(filePath));
                charSet = CommonEncodeDetectUtils.endcodeDetect(filePath);
            }
            string = ToolUtils.readLinesFromFile(in, charSet);
        }
        catch (Exception e) {
            try {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Certificate error!", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, in);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)in);
            return "";
        }
        StreamUtils.closeStream(null, (InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLinesFromFile(InputStream in, String charSet) {
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(in, charSet));
            String readLine = null;
            while ((readLine = reader.readLine()) != null) {
                result.append(readLine).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            String string;
            try {
                LOGGER.error("Read powershell result from file error...", e);
                string = null;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            return string;
        }
        StreamUtils.closeResource(null, (Closeable)reader);
        return result.toString();
    }

    public static String getSpecialSymbols(Boolean isSimulator) {
        return isSimulator != false ? " ^>>" : " >> ";
    }

    public static String getAppendFileStr(Boolean isSimulator) {
        return isSimulator != false ? " ^>" : " > ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileCanOperate(String file) {
        boolean bl;
        File resFile = FilePathUtils.checkFile((File)new File(file));
        if (!resFile.exists()) {
            return false;
        }
        RandomAccessFile raf = null;
        FileLock fl = null;
        try {
            raf = new RandomAccessFile(resFile, "rw");
            FileChannel fc = raf.getChannel();
            fl = fc.tryLock();
            bl = fl.isValid();
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.error("lock file error" + e.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, raf);
                ToolUtils.releaseFileLock(fl);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)raf);
            ToolUtils.releaseFileLock(fl);
            return bl2;
        }
        StreamUtils.closeResource(null, (Closeable)raf);
        ToolUtils.releaseFileLock(fl);
        return bl;
    }

    public static void releaseFileLock(FileLock fl) {
        if (fl != null) {
            try {
                fl.close();
            }
            catch (Exception e) {
                LOGGER.error("release lock error");
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        boolean success = false;
        for (int i = 0; i < 10; ++i) {
            ConnUtils.sleep(512);
            if (null == file || !file.exists()) continue;
            success = file.delete();
            if (success) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("delete " + filePath + " success");
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("delete " + filePath + " fail, try again");
                }
                String cmd = "cmd /C del \"" + filePath + "\" /f/s/q";
                OSCmdUtils.executeCmd((String)cmd, (int)32);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("force delete result " + !new File(filePath).exists());
                }
                if (!new File(filePath).exists()) {
                    success = true;
                    break;
                }
            }
            return success;
        }
        return success;
    }

    public static boolean isPaconnected(DevNode dev) {
        if (!ToolUtils.isWindowsHost(dev)) {
            return true;
        }
        try {
            if (dev.isFileNode()) {
                return true;
            }
            WmicConnection wmicConn = (WmicConnection)WmicConnectionManager.getWmicConnection(dev);
            Future<Boolean> paConnFuture = wmicConn.getPaexecConnection().getConnectResult();
            boolean isPaConnected = paConnFuture == null ? false : paConnFuture.get();
            return isPaConnected;
        }
        catch (Exception e) {
            LOGGER.error("conn to server error", e);
            return false;
        }
    }

    public static boolean isCmdExecFailed(String cliReturn) {
        return cliReturn.contains("TOOLKIT_EXE_CMD_FAILED");
    }

    public static boolean isWindowsHost(DevNode devNode) {
        if (devNode != null && devNode.getDevTypeLevel2() != null) {
            return "Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString());
        }
        return false;
    }
}

