/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class XmlWriter {
    private XmlWriter() {
    }

    public static Document createNewDocument() throws ToolException {
        Document doc;
        try {
            doc = XmlUtils.getIgnoreWhitespaceDocBuilderFactory().newDocumentBuilder().newDocument();
            doc.setXmlVersion("1.0");
        }
        catch (ParserConfigurationException e) {
            throw new ToolException("Can't create document", e);
        }
        return doc;
    }

    public static void writeDomToXmlFile(Document doc, String fileAbsolutePath) throws ToolException {
        XmlWriter.writeDomToXmlFile(doc, fileAbsolutePath, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDomToXmlFile(Document doc, String fileAbsolutePath, boolean indent) throws ToolException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(fileAbsolutePath));
            Transformer transformer = XmlUtils.newTransformer();
            transformer.setOutputProperty("indent", indent ? "yes" : "no");
            transformer.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (FileNotFoundException e) {
            try {
                throw new ToolException("Wirte to xml file \"" + new File(fileAbsolutePath).getName() + "\" error");
                catch (IOException e2) {
                    throw new ToolException("Wirte to xml file \"" + new File(fileAbsolutePath).getName() + "\" error:", e2);
                }
                catch (TransformerException e3) {
                    throw new ToolException("Wirte to xml file \"" + new File(fileAbsolutePath).getName() + "\" error:", e3);
                }
                catch (Exception e1) {
                    throw new ToolException("Wirte to xml file \"" + new File(fileAbsolutePath).getName() + "\" error:", e1);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(os, null);
                throw throwable;
            }
        }
        StreamUtils.closeStream(os, null);
    }

    public static Element createTagElement(Document doc, String tagName) {
        Element tagElement = doc.createElement(tagName);
        return tagElement;
    }

    public static Element createTagElement(Document doc, String tagName, String textContent) {
        Element tagElement = XmlWriter.createTagElement(doc, tagName);
        Text text = doc.createTextNode(textContent);
        tagElement.appendChild(text);
        return tagElement;
    }

    public static Element createTagElement(Document doc, String tagName, String attrName, String attrValue) {
        Element tagElement = XmlWriter.createTagElement(doc, tagName);
        Attr attr = doc.createAttribute(attrName);
        attr.setValue(attrValue);
        tagElement.setAttributeNode(attr);
        return tagElement;
    }

    public static Element createTagElement(Document doc, String tagName, List<KeyValue<String, String>> attributeInfos) {
        Element tagElement = XmlWriter.createTagElement(doc, tagName);
        for (KeyValue<String, String> keyValue : attributeInfos) {
            Attr attr = doc.createAttribute(keyValue.getKey());
            attr.setValue(keyValue.getValue());
            tagElement.setAttributeNode(attr);
        }
        return tagElement;
    }
}

