/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Products {
    public static final String KUNPENG = "Kunpeng";
    public static final String V3_SERIES = "V3";
    public static final String V5_SERIES = "V5";
    public static final String PROTECT = "OceanProtect";
    public static final String VRC_VERSION_REGX = "(V\\d{3}R\\d{3}C\\d{2}|\\d+\\.\\d+\\.\\w+)";
    public static final String TABLE_CELL_OCCUPYING_LINE = "--";
    public static final List<String> OCEAN_PROTECT_SUPPORT_FAST_UPGRADE = Arrays.asList("a8000", "x8000", "x9000", "x6000", "x8000k", "x9000k", "x3000");
    public static final List<String> NEW_HYBRID_DORADO = Arrays.asList("oceanstor 5310", "oceanstor 5510", "oceanstor 5510s", "oceanstor 5610", "oceanstor 5810-hs", "oceanstor 6810", "oceanstor 18510", "oceanstor 18500k", "oceanstor 18810", "oceanstor 5300k", "oceanstor 5500k", "oceanstor 5320", "oceanstor 2200", "oceanstor 2220", "oceanstor 5120", "oceanstor 2600", "oceanstor 2620", "oceanstor 5210", "oceanstor 5220", "oceanStor 5310 capacity flash", "oceanStor 5510 capacity flash", "OceanStor A300");
    public static final List<String> DORADO_V6_DEV = Arrays.asList("Dorado18000 V6", "Dorado8000 V6", "Dorado6000 V6", "Dorado5000 V6", "Dorado3000 V6", "OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 6000 V6", "OceanStor Dorado 8000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100", "OceanStor Dorado 18000 V6", "OceanStor Dorado 5300 V6", "OceanStor Dorado 2020", "OceanStor Dorado 5500 V6", "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6", "OceanStor Dorado 6800 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6", "OceanStor Dorado 5600K V6", "OceanStor 2910", "OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5300K", "OceanStor 5500K", "OceanStor 5320", "OceanStor 5310 Capacity Flash", "OceanStor 5610", "OceanStor 6810", "OceanStor 18510", "OceanStor 5810-HS", "OceanStor 5510 Capacity Flash", "OceanStor 18500K", "OceanStor 18810", "OceanStor A300", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220", "OceanStor Dorado 18800K V6", "OceanProtect X8000", "OceanProtect X9000", "OceanProtect E8000", "OceanProtect A8000", "OceanProtect X6000", "OceanProtect X8000K", "OceanProtect X9000K", "OceanProtect X3000", "OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T", "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K", "OceanStor Dorado 18800K", "OceanStor A800");
    public static final List<String> OCEAN_STOR_MICRO_DEVS = Arrays.asList("OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T");
    public static final List<String> KUNPENG_HIGH_DEVS = Collections.unmodifiableList(Arrays.asList("6800 V5", "6810 V5", "18500 V5", "18510 V5", "18800 V5", "18810 V5", "6800F V5", "6810F V5", "18500F V5", "18510F V5", "18800F V5", "18810F V5", "6800K V5", "18500K V5", "18800K V5"));
    public static final List<String> OCEAN_STOR_COMPUTING_DEVS = Arrays.asList("OceanStor 2910");
    public static final List<String> CYBER_ENGINE_DEVS = Arrays.asList("Huawei OceanCyber 300", "Huawei CyberEngine 300");
    public static final List<String> LDAP_SUPPORT_DEVS = Arrays.asList("OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 6000 V6", "OceanStor Dorado 8000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2020", "OceanStor Dorado 18000 V6", "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6", "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6", "OceanStor Dorado 6800 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800K V6", "OceanStor Dorado 2100", "OceanStor Dorado 18800 V6", "OceanStor Dorado 5600K V6", "OceanStor Dorado 18800K", "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K");
    public static final List<String> LDAP_SUPPORT_SUPPER_ADMIN_DORADO_AND_NEW_DORADO = Arrays.asList("OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 6000 V6", "OceanStor Dorado 2020", "OceanStor Dorado 8000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 18000 V6", "OceanStor Dorado 2100", "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6", "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6", "OceanStor Dorado 6800 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6", "OceanStor Dorado 5600K V6", "OceanStor Dorado 18800K V6", "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash", "OceanStor A300", "OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5300K", "OceanStor 5500K", "OceanStor 5320", "OceanStor 5610", "OceanStor 6810", "OceanStor 18510", "OceanStor 5810-HS", "OceanStor 18500K", "OceanStor 18810", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220", "OceanStor Dorado 18800K", "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K");
    public static final List<String> LDAP_SUPPORT_SUPPER_ADMIN_OCEAN_PROTECT = Arrays.asList("OceanProtect X8000", "OceanProtect X9000", "OceanProtect X6000", "OceanProtect X8000K", "OceanProtect X9000K", "OceanProtect X3000", "OceanProtect E8000");

    public static boolean isDigitalVer(String version) {
        return version.matches("\\d+\\.\\d+.*");
    }

    public static boolean isKunpeng(String version) {
        return version.contains(KUNPENG) && version.compareTo("V500R007C60") >= 0;
    }

    public static boolean isKunpengHighDev(String devType, String version) {
        return version.contains(KUNPENG) && KUNPENG_HIGH_DEVS.contains(devType);
    }

    public static int compareVersion(String version1, String version2) {
        if (!version1.matches("\\d+\\.\\d+.*") || !version2.matches("\\d+\\.\\d+.*")) {
            return Products.compare(version1, version2);
        }
        String[] specialKeys = new String[]{"RC", "T", "SPC", "SPH"};
        for (int index = 0; index < specialKeys.length; ++index) {
            String tmpKey = specialKeys[index];
            if (!version1.contains(tmpKey) || !version2.contains(tmpKey)) continue;
            version1 = version1.replace(tmpKey, "");
            version2 = version2.replace(tmpKey, "");
        }
        String[] sectors1 = version1.split("\\.");
        String[] sectors2 = version2.split("\\.");
        for (int i = 0; i < Math.min(sectors1.length, sectors2.length); ++i) {
            Integer tmp2;
            Integer tmp1 = StringUtils.isNumeric((CharSequence)sectors1[i]) ? Integer.valueOf(Integer.parseInt(sectors1[i])) : null;
            Integer n = tmp2 = StringUtils.isNumeric((CharSequence)sectors2[i]) ? Integer.valueOf(Integer.parseInt(sectors2[i])) : null;
            if (tmp1 == null && tmp2 == null) {
                return sectors1[i].compareToIgnoreCase(sectors2[i]);
            }
            if (tmp1 != null && tmp2 != null) {
                if (tmp1.equals(tmp2)) continue;
                return tmp1 > tmp2 ? 1 : -1;
            }
            return Products.compareMix(sectors1[i], sectors2[i]);
        }
        return version1.compareToIgnoreCase(version2);
    }

    public static Optional<Integer> compareVersion(String version, String v5Version, String v3Version) {
        if (version.startsWith(V3_SERIES)) {
            return Optional.of(version.compareTo(v3Version));
        }
        if (version.startsWith(V5_SERIES)) {
            return Optional.of(version.compareTo(v5Version));
        }
        return Optional.empty();
    }

    public static int compare(String version1, String version2) {
        if (version1.contains(KUNPENG) && version2.contains(KUNPENG)) {
            version1 = version1.replace(KUNPENG, "").trim();
            version2 = version2.replace(KUNPENG, "").trim();
        }
        return version1.compareToIgnoreCase(version2);
    }

    private static int compareMix(String version1, String version2) {
        if (version1.contains("T") || version2.contains("T")) {
            return -1;
        }
        if (StringUtils.isNumeric((CharSequence)version1) && version2.contains("RC") || StringUtils.isNumeric((CharSequence)version2) && version1.contains("RC")) {
            return Products.formatVersion(version1).compareToIgnoreCase(Products.formatVersion(version2));
        }
        return version1.compareToIgnoreCase(version2);
    }

    private static String formatVersion(String version) {
        if (StringUtils.isNumeric((CharSequence)version)) {
            return version + "RCX";
        }
        if (version.startsWith("RC")) {
            return "0" + version;
        }
        return version;
    }

    private static String parseDigitalVersion(String version) {
        if (StringUtils.isNumeric((CharSequence)version)) {
            return version;
        }
        if (version.startsWith("RC")) {
            return "0";
        }
        if (version.contains("RC")) {
            return version.substring(0, version.indexOf("RC"));
        }
        return version;
    }

    public static String formatDigitalVersion(String version) {
        if (!Products.isDigitalVer(version)) {
            return version;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] sectors = version.split("\\.");
        for (int i = 0; i < 3; ++i) {
            result.add(Products.parseDigitalVersion(sectors[i]));
        }
        return String.join((CharSequence)".", result);
    }

    public static boolean contains(String devVersion, String subVersion) {
        return Products.contains(devVersion, subVersion, KUNPENG);
    }

    public static boolean containsIgnoreCase(String devVersion, String subVersion) {
        devVersion = devVersion.toLowerCase(Locale.US);
        subVersion = subVersion.toLowerCase(Locale.US);
        String kunpeng = KUNPENG.toLowerCase(Locale.US);
        return Products.contains(devVersion, subVersion, kunpeng);
    }

    private static boolean contains(String devVersion, String subVersion, String modeKey) {
        if (devVersion.contains(modeKey) && !subVersion.contains(modeKey)) {
            return false;
        }
        if (devVersion.contains(modeKey) && subVersion.contains(modeKey)) {
            return devVersion.replace(modeKey, "").trim().contains(subVersion.replace(modeKey, "").trim());
        }
        return devVersion.trim().contains(subVersion.trim());
    }

    public static String getVRCVersion(String version) {
        Pattern pattern = Pattern.compile(VRC_VERSION_REGX);
        Matcher matcher = pattern.matcher(version);
        String vrcVer = TABLE_CELL_OCCUPYING_LINE;
        if (matcher.find()) {
            vrcVer = matcher.group();
        }
        return vrcVer;
    }

    public static boolean isOceanStorMicroDev(String devType) {
        return OCEAN_STOR_MICRO_DEVS.stream().anyMatch(devType::equalsIgnoreCase);
    }

    public static boolean isCyberEngineDev(String devType) {
        return CYBER_ENGINE_DEVS.stream().anyMatch(devType::equalsIgnoreCase);
    }

    public static boolean isOceanStoComputingDev(String devType) {
        return OCEAN_STOR_COMPUTING_DEVS.stream().anyMatch(devType::equalsIgnoreCase);
    }

    public static boolean isOceanProtectDev(String devType) {
        return OCEAN_PROTECT_SUPPORT_FAST_UPGRADE.stream().anyMatch(type -> devType.toLowerCase(Locale.ENGLISH).contains((CharSequence)type));
    }

    public static boolean isNewDoradoDev(String devType) {
        return NEW_HYBRID_DORADO.stream().anyMatch(devType::equalsIgnoreCase);
    }

    public static boolean isDoradoV6SeriseDev(String devType) {
        return DORADO_V6_DEV.stream().anyMatch(devType::equalsIgnoreCase);
    }

    public static boolean isSpecifiedDomainDev(String model, String version) {
        return Products.isSpecifiedDoradoOrNewDoradoDev(model, version) || Products.isSpecifiedOceanProtectDev(model, version) || Products.isSupportDomainVersionModel(model, version) || Products.isSpecifiedMicroDev(model, version);
    }

    public static boolean isSpecifiedDoradoOrNewDoradoDev(String model, String version) {
        return LDAP_SUPPORT_SUPPER_ADMIN_DORADO_AND_NEW_DORADO.contains(model) && Products.compareVersion(version, "6.1.7RC1") >= 0;
    }

    public static boolean isSpecifiedOceanProtectDev(String model, String version) {
        return LDAP_SUPPORT_SUPPER_ADMIN_OCEAN_PROTECT.contains(model) && Products.compareVersion(version, "1.5.RC1") >= 0;
    }

    public static boolean isSpecifiedMicroDev(String model, String version) {
        return Products.isOceanStorMicroDev(model) && Products.compareVersion(version, "1.2.RC1") >= 0;
    }

    public static boolean isSupportDomainVersionModel(String model, String version) {
        return LDAP_SUPPORT_DEVS.contains(model) && Products.compareVersion(version, "6.1.0") >= 0;
    }

    public static final class Feature {
        public static boolean isSupportFastUpgrade(String devType) {
            return Products.isDoradoV6SeriseDev(devType);
        }

        public static boolean isSupportParallUpgrade(String devType, String version) {
            if (devType.toLowerCase().contains("dorado") && Products.isDigitalVer(version) && version.contains("6.0.RC1")) {
                return false;
            }
            return !Objects.equals(devType, "OceanStor A800");
        }

        public static boolean isSupportRollUpgrade(String version) {
            return version.compareTo(Products.V3_SERIES) > 0 || Products.isDigitalVer(version);
        }

        public static boolean isSupportIpEnclosureUpgrade(String devType, String version) {
            if (Products.isKunpeng(version)) {
                return true;
            }
            return Feature.isSupportFastUpgrade(devType);
        }

        public static boolean isSupportIgnoreUpgradeAtom(String devType, String version) {
            if (devType.toLowerCase().contains("dorado") && !Products.isDigitalVer(version) && version.compareTo("V300R001C21") >= 0) {
                return true;
            }
            if (!(devType.toLowerCase().contains("dorado") || Products.isDigitalVer(version) || Products.isKunpeng(version))) {
                if (version.contains(Products.V3_SERIES) && version.compareTo("V300R006C10") >= 0) {
                    return true;
                }
                return version.contains(Products.V5_SERIES) && version.compareTo("V500R007C00") >= 0;
            }
            return false;
        }

        public static boolean isSupportRebootRepair(String devType, String version) {
            if (devType.contains(Products.PROTECT)) {
                return false;
            }
            if (!(Products.isDigitalVer(version) || version.compareTo(Products.V3_SERIES) < 0 && version.compareTo(Products.V5_SERIES) < 0)) {
                return true;
            }
            return Products.isDigitalVer(version);
        }

        public static boolean isSupportInnerCheck(String devType, String version) {
            if (Feature.isSupportFastUpgrade(devType)) {
                return true;
            }
            return Products.isKunpeng(version);
        }
    }
}

